/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tts.utils;

import com.tencent.tts.model.SpeechSynthesisSysConfig;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class LineSplitUtils {
    public static List<String> smartSplit(String line) {
        ArrayList<String> list = new ArrayList<String>();
        if (line.length() <= SpeechSynthesisSysConfig.SEPARATOR_LENGTH_LIMIT) {
            list.add(line);
            return list;
        }
        LineSplitUtils.splitAndAdd(list, line, 0);
        ArrayList<String> resultList = new ArrayList<String>();
        for (String item : list) {
            if (item.length() <= SpeechSynthesisSysConfig.SEPARATOR_LENGTH_LIMIT) {
                resultList.add(item);
                continue;
            }
            LineSplitUtils.slipByComma(resultList, item);
        }
        return resultList;
    }

    private static void splitAndAdd(List<String> list, String line, int charPosi) {
        String[] items;
        String mark = SpeechSynthesisSysConfig.SEPARATOR_CHARS[charPosi];
        for (String item : items = StringUtils.split((String)line, (String)mark)) {
            if (items.length > 1 && LineSplitUtils.notEndWithSeparator(item)) {
                item = item + mark;
            }
            if (charPosi == SpeechSynthesisSysConfig.SEPARATOR_CHARS.length - 1) {
                list.add(item);
                continue;
            }
            if (item.length() <= SpeechSynthesisSysConfig.SEPARATOR_LENGTH_LIMIT) {
                list.add(item);
                continue;
            }
            LineSplitUtils.splitAndAdd(list, item, charPosi + 1);
        }
    }

    private static void slipByComma(List<String> resultList, String item) {
        String[] subItems = StringUtils.split((String)item, (String)"\uff0c,");
        if (subItems.length == 1) {
            resultList.add(item);
            return;
        }
        String subRes = subItems[0] + "\uff0c";
        for (int i = 1; i < subItems.length; ++i) {
            String sub = subItems[i];
            if (sub.length() == 0) continue;
            if (LineSplitUtils.notEndWithSeparator(sub)) {
                sub = sub + "\uff0c";
            }
            if (subRes.length() + sub.length() > SpeechSynthesisSysConfig.SEPARATOR_LENGTH_LIMIT) {
                resultList.add(subRes);
                subRes = sub;
                continue;
            }
            subRes = subRes + sub;
        }
        if (subRes.length() > 0) {
            resultList.add(subRes);
        }
    }

    private static boolean notEndWithSeparator(String str) {
        return !ArrayUtils.contains((Object[])SpeechSynthesisSysConfig.SEPARATOR_CHARS, (Object)str.substring(str.length() - 1));
    }
}

