/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tts.service;

import com.tencent.core.help.SignHelper;
import com.tencent.tts.model.SpeechSynthesisConfig;
import com.tencent.tts.model.SpeechSynthesisRequest;
import com.tencent.tts.model.SpeechSynthesisRequestContent;
import java.util.Map;
import java.util.TreeMap;

class SpeechSynthesisSignService {
    SpeechSynthesisSignService() {
    }

    public String signUrl(SpeechSynthesisConfig speechSynthesisConfig, SpeechSynthesisRequest request, SpeechSynthesisRequestContent content, TreeMap<String, Object> map) {
        String paramUrl = SignHelper.createUrl(map);
        return speechSynthesisConfig.getSignUrl() + paramUrl;
    }

    public static TreeMap<String, Object> getParams(SpeechSynthesisConfig speechSynthesisConfig, SpeechSynthesisRequest request, SpeechSynthesisRequestContent content) {
        TMap treeMap = new TMap();
        treeMap.put("SecretId", speechSynthesisConfig.getSecretId());
        treeMap.put("Text", content.getText());
        treeMap.put("SessionId", content.getSessionId());
        treeMap.put("ModelType", request.getModelType());
        treeMap.put("Volume", request.getVolume());
        if ((float)request.getSpeed().intValue() == request.getSpeed().floatValue()) {
            treeMap.put("Speed", (Object)request.getSpeed().intValue());
        } else {
            treeMap.put("Speed", request.getSpeed());
        }
        treeMap.put("VoiceType", request.getVoiceType());
        treeMap.put("PrimaryLanguage", request.getPrimaryLanguage());
        treeMap.put("SampleRate", request.getSampleRate());
        treeMap.put("Codec", request.getCodec());
        treeMap.put("Timestamp", request.getTimestamp());
        treeMap.put("Expired", request.getExpired());
        treeMap.put("Action", speechSynthesisConfig.getAction());
        treeMap.put("AppId", speechSynthesisConfig.getAppId());
        treeMap.put("ProjectId", request.getProjectId());
        if (request.getExtendsParam() != null) {
            for (Map.Entry<String, Object> entry : request.getExtendsParam().entrySet()) {
                treeMap.put(entry.getKey(), entry.getValue());
            }
        }
        return treeMap;
    }

    public static class TMap<K, V>
    extends TreeMap {
        @Override
        public Object put(Object key, Object value) {
            if (value != null) {
                return super.put(key, value);
            }
            return null;
        }
    }
}

