/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.core.utils;

import com.tencent.asr.model.AsrRequest;
import com.tencent.core.model.TRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class SignBuilder {
    private static final String REQUEST_ENCODE = "UTF-8";
    private static final String SIGN_TYPE = "HmacSHA1";
    private static final Set<String> VALIDE_REQUEST_TYPES = new HashSet<String>();

    public static String createPostSign(String serverUrl, String secretKey, TRequest request) {
        return SignBuilder.createSign(serverUrl, secretKey, "POST", request);
    }

    public static String createGetSign(String serverUrl, String secretKey, TRequest request) {
        return SignBuilder.createSign(serverUrl, secretKey, "GET", request);
    }

    public static String createSign(String serverUrl, String secretKey, String requestType, TRequest request) {
        SignBuilder.validateRequestType(requestType);
        String url = serverUrl.toLowerCase();
        int position = 0;
        String strToBeEncoded = serverUrl;
        if (url.contains("https://")) {
            position = 8;
            strToBeEncoded = requestType + serverUrl.substring(position);
        }
        if (url.contains("http://")) {
            position = 7;
            strToBeEncoded = requestType + serverUrl.substring(position);
        }
        if (url.contains("ws://")) {
            position = 5;
            strToBeEncoded = serverUrl.substring(position);
        }
        if (url.contains("wss://")) {
            position = 6;
            strToBeEncoded = serverUrl.substring(position);
        }
        if (request != null) {
            request.setStrToBeEncoded(strToBeEncoded);
        }
        return SignBuilder.base64_hmac_sha1(strToBeEncoded, secretKey);
    }

    public static String createSignAndUrlEncode(String serverUrl, String secretKey, String requestType, AsrRequest request) {
        SignBuilder.validateRequestType(requestType);
        String sign = SignBuilder.createSign(serverUrl, secretKey, requestType, request);
        try {
            return URLEncoder.encode(sign, REQUEST_ENCODE);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return sign;
        }
    }

    private static String base64_hmac_sha1(String originalText, String secretKey) {
        try {
            Mac hmac = Mac.getInstance(SIGN_TYPE);
            hmac.init(new SecretKeySpec(secretKey.getBytes(REQUEST_ENCODE), SIGN_TYPE));
            byte[] hash = hmac.doFinal(originalText.getBytes(REQUEST_ENCODE));
            return Base64.encodeBase64String((byte[])hash);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private static void validateRequestType(String requestType) {
        if (requestType == null || !VALIDE_REQUEST_TYPES.contains(requestType)) {
            throw new IllegalArgumentException("Unsupported request type: " + requestType + ", must be: GET or POST");
        }
    }

    static {
        VALIDE_REQUEST_TYPES.add("GET");
        VALIDE_REQUEST_TYPES.add("POST");
    }
}

