/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.core.service;

import com.tencent.asr.model.AsrLogInfo;
import com.tencent.core.model.GlobalConfig;
import com.tencent.core.model.LogStatistics;
import com.tencent.core.model.ReportInfo;
import com.tencent.core.model.StatItem;
import com.tencent.core.service.ReportService;
import com.tencent.core.utils.JsonUtil;
import com.tencent.core.utils.Tutils;
import com.tencentcloudapi.asr.v20190614.AsrClient;
import com.tencentcloudapi.common.Credential;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;

public class StatService {
    private static AtomicBoolean open = new AtomicBoolean(false);
    private static long expireTime = System.currentTimeMillis();
    private static LogStatistics asrStatistics = LogStatistics.createLogStatistics();
    private static BlockingQueue<StatItem> statItemBlockingQueue = new LinkedBlockingQueue<StatItem>();
    private static String appId;
    private static String secretId;
    private static String secretKey;
    private static String token;

    public static void setConfig(String secretIds, String secretKeys, String appIds, String tokens) {
        appId = appIds;
        secretId = secretIds;
        secretKey = secretKeys;
        token = tokens;
    }

    public static LogStatistics getAsrStatistics() {
        return asrStatistics;
    }

    protected static void statAsr(boolean success, String code, long delayTime) {
        if (delayTime > 0L) {
            statItemBlockingQueue.add(StatItem.builder().success(success).code(code).delayTime(delayTime).build());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startReportStat() {
        if (open.get()) {
            return;
        }
        Class<StatService> clazz = StatService.class;
        synchronized (StatService.class) {
            if (open.get()) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            ReportService.ifLogMessage("scheduledExecutor", "restart stat", false);
            open.set(true);
            asrStatistics.setAppId(Long.valueOf(appId));
            // ** MonitorExit[var0] (shouldn't be in output)
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    long sendTime = System.currentTimeMillis();
                    while (true) {
                        try {
                            Long scheduleTime;
                            StatItem statItem = (StatItem)statItemBlockingQueue.poll(1L, TimeUnit.SECONDS);
                            if (statItem != null) {
                                expireTime = System.currentTimeMillis() + 30000L;
                                StatService.statistics(statItem);
                            }
                            if ((scheduleTime = Long.valueOf(System.currentTimeMillis() - sendTime)) < 10000L) continue;
                            sendTime = System.currentTimeMillis();
                            StatService.reportToCloud();
                            continue;
                        }
                        catch (Exception exception) {
                            if (System.currentTimeMillis() <= expireTime || !statItemBlockingQueue.isEmpty()) continue;
                            open.set(false);
                            ReportService.ifLogMessage("scheduledExecutor", "break", false);
                        }
                        finally {
                            if (System.currentTimeMillis() <= expireTime || !statItemBlockingQueue.isEmpty()) continue;
                            open.set(false);
                            ReportService.ifLogMessage("scheduledExecutor", "break", false);
                            break;
                            continue;
                        }
                        break;
                    }
                }
            }).start();
            return;
        }
    }

    private static void reportToCloud() {
        LogStatistics statistics = JsonUtil.fromJson(JsonUtil.toJson(asrStatistics), LogStatistics.class);
        if (statistics.getReqNum().get() > 0) {
            DecimalFormat df = new DecimalFormat("0.00");
            statistics.setSuccessRate(Float.parseFloat(df.format((float)statistics.getSuccessNum().get() * 100.0f / (float)statistics.getReqNum().get())));
            statistics.setNonBusinessFailNumRate(Float.parseFloat(df.format((float)statistics.getNonBusinessFailNum().get() * 100.0f / (float)statistics.getReqNum().get())));
            statistics.setBusinessFailNumRate(Float.parseFloat(df.format((float)statistics.getBusinessFailNum().get() * 100.0f / (float)statistics.getReqNum().get())));
        }
        if (statistics.getReqNum().get() == 0 && statistics.getSuccessNum().get() == 0) {
            return;
        }
        StatService.reportStat(secretId, secretKey, statistics);
    }

    public static void heartbeat() {
        expireTime = System.currentTimeMillis() + 30000L;
        if (!open.get()) {
            StatService.startReportStat();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reportStat(String secretId, String secretKey, LogStatistics statistics) {
        Credential cred = StringUtils.isNotEmpty((CharSequence)token) ? new Credential(secretId, secretKey, token) : new Credential(secretId, secretKey);
        AsrClient client = new AsrClient(cred, GlobalConfig.region);
        AsrLogInfo.Log log = new AsrLogInfo.Log();
        statistics.setReportTime(new Date().getTime());
        log.setTime(Tutils.getNowData());
        log.setStat(statistics);
        AsrLogInfo cloudReqInfo = new AsrLogInfo();
        cloudReqInfo.setLog(JsonUtil.toJson(log));
        ReportInfo.AppInfo appInfo = ReportInfo.getAppInfo("", "_STAT");
        cloudReqInfo.setAppInfo(JsonUtil.toJson(appInfo));
        try {
            String resp = client.call("UploadSDKLog", JsonUtil.toJson(cloudReqInfo));
            ReportService.ifLogMessage("stamp", "Statistics report results:" + resp, false);
        }
        catch (Exception exception) {
        }
        finally {
            LogStatistics.resetLogStatistics(asrStatistics);
        }
    }

    private static void statistics(StatItem statItem) {
        asrStatistics.getReqNum().incrementAndGet();
        if (!statItem.getSuccess().booleanValue()) {
            asrStatistics.getFailNum().incrementAndGet();
            ConcurrentHashMap<String, AtomicInteger> map = asrStatistics.getFailCodeStat();
            if (map.get(String.valueOf(statItem.getCode())) != null) {
                map.get(String.valueOf(statItem.getCode())).incrementAndGet();
            } else {
                map.put(String.valueOf(statItem.getCode()), new AtomicInteger(1));
            }
            int codeResult = Integer.valueOf(statItem.getCode());
            if (codeResult > 0) {
                asrStatistics.getBusinessFailNum().incrementAndGet();
            }
            if (codeResult < 0) {
                asrStatistics.getNonBusinessFailNum().incrementAndGet();
            }
        } else {
            asrStatistics.getSuccessNum().incrementAndGet();
        }
        if (statItem.getDelayTime() > 0L) {
            StatService.setDelayTime(statItem.getDelayTime(), "Delay0To100", 0L, 100L);
            StatService.setDelayTime(statItem.getDelayTime(), "Delay100To200", 100L, 200L);
            StatService.setDelayTime(statItem.getDelayTime(), "Delay200To500", 200L, 500L);
            StatService.setDelayTime(statItem.getDelayTime(), "Delay500To1000", 500L, 1000L);
            StatService.setDelayTime(statItem.getDelayTime(), "Delay1000To6000", 1000L, 6000L);
            StatService.setDelayTime(statItem.getDelayTime(), "Delay6000Over", 6000L, Long.MAX_VALUE);
        }
    }

    private static void setDelayTime(long delayTime, String key, long start, long end) {
        ConcurrentHashMap<String, AtomicInteger> delayMap = asrStatistics.getDelayTimeStat();
        if (delayTime >= start && delayTime < end) {
            if (delayMap.get(key) != null) {
                delayMap.get(key).incrementAndGet();
            } else {
                delayMap.put(key, new AtomicInteger(1));
            }
        }
    }
}

