/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.core.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class LogStatistics {
    @JsonProperty(value="ReportTime")
    private Long reportTime;
    @JsonProperty(value="AppId")
    private Long AppId;
    @JsonProperty(value="StreamNum")
    private AtomicInteger streamNum;
    @JsonProperty(value="VoiceIdNum")
    private AtomicInteger voiceIdNum;
    @JsonProperty(value="ReqNum")
    private AtomicInteger reqNum;
    @JsonProperty(value="SuccessNum")
    private AtomicInteger successNum;
    @JsonProperty(value="FailNum")
    private AtomicInteger failNum;
    @JsonProperty(value="NonBusinessFailNum")
    private AtomicInteger nonBusinessFailNum;
    @JsonProperty(value="NonBusinessFailNumRate")
    private float nonBusinessFailNumRate;
    @JsonProperty(value="BusinessFailNum")
    private AtomicInteger businessFailNum;
    @JsonProperty(value="BusinessFailNumRate")
    private float businessFailNumRate;
    @JsonProperty(value="FailCodeStat")
    private ConcurrentHashMap<String, AtomicInteger> FailCodeStat;
    @JsonProperty(value="DelayTimeStat")
    private ConcurrentHashMap<String, AtomicInteger> delayTimeStat;
    @JsonProperty(value="SuccessRate")
    private float successRate;
    @JsonProperty(value="Id")
    private String id;

    public static LogStatistics createLogStatistics() {
        LogStatistics statistics = new LogStatistics();
        statistics.setStreamNum(new AtomicInteger(0));
        statistics.setVoiceIdNum(new AtomicInteger(0));
        statistics.setReqNum(new AtomicInteger(0));
        statistics.setSuccessNum(new AtomicInteger(0));
        statistics.setFailNum(new AtomicInteger(0));
        statistics.setBusinessFailNum(new AtomicInteger(0));
        statistics.setNonBusinessFailNum(new AtomicInteger(0));
        statistics.setFailCodeStat(new ConcurrentHashMap<String, AtomicInteger>());
        statistics.setDelayTimeStat(new ConcurrentHashMap<String, AtomicInteger>());
        statistics.setId(UUID.randomUUID().toString());
        statistics.setSuccessRate(1.0f);
        return statistics;
    }

    public static LogStatistics resetLogStatistics(LogStatistics statistics) {
        statistics.getStreamNum().set(0);
        statistics.getVoiceIdNum().set(0);
        statistics.getReqNum().set(0);
        statistics.getSuccessNum().set(0);
        statistics.setFailCodeStat(new ConcurrentHashMap<String, AtomicInteger>());
        statistics.setDelayTimeStat(new ConcurrentHashMap<String, AtomicInteger>());
        statistics.setId(UUID.randomUUID().toString());
        statistics.getFailNum().set(0);
        statistics.getBusinessFailNum().set(0);
        statistics.getNonBusinessFailNum().set(0);
        statistics.setSuccessRate(1.0f);
        return statistics;
    }

    public static LogStatisticsBuilder builder() {
        return new LogStatisticsBuilder();
    }

    @JsonProperty(value="ReportTime")
    public void setReportTime(Long reportTime) {
        this.reportTime = reportTime;
    }

    @JsonProperty(value="AppId")
    public void setAppId(Long AppId) {
        this.AppId = AppId;
    }

    @JsonProperty(value="StreamNum")
    public void setStreamNum(AtomicInteger streamNum) {
        this.streamNum = streamNum;
    }

    @JsonProperty(value="VoiceIdNum")
    public void setVoiceIdNum(AtomicInteger voiceIdNum) {
        this.voiceIdNum = voiceIdNum;
    }

    @JsonProperty(value="ReqNum")
    public void setReqNum(AtomicInteger reqNum) {
        this.reqNum = reqNum;
    }

    @JsonProperty(value="SuccessNum")
    public void setSuccessNum(AtomicInteger successNum) {
        this.successNum = successNum;
    }

    @JsonProperty(value="FailNum")
    public void setFailNum(AtomicInteger failNum) {
        this.failNum = failNum;
    }

    @JsonProperty(value="NonBusinessFailNum")
    public void setNonBusinessFailNum(AtomicInteger nonBusinessFailNum) {
        this.nonBusinessFailNum = nonBusinessFailNum;
    }

    @JsonProperty(value="NonBusinessFailNumRate")
    public void setNonBusinessFailNumRate(float nonBusinessFailNumRate) {
        this.nonBusinessFailNumRate = nonBusinessFailNumRate;
    }

    @JsonProperty(value="BusinessFailNum")
    public void setBusinessFailNum(AtomicInteger businessFailNum) {
        this.businessFailNum = businessFailNum;
    }

    @JsonProperty(value="BusinessFailNumRate")
    public void setBusinessFailNumRate(float businessFailNumRate) {
        this.businessFailNumRate = businessFailNumRate;
    }

    @JsonProperty(value="FailCodeStat")
    public void setFailCodeStat(ConcurrentHashMap<String, AtomicInteger> FailCodeStat) {
        this.FailCodeStat = FailCodeStat;
    }

    @JsonProperty(value="DelayTimeStat")
    public void setDelayTimeStat(ConcurrentHashMap<String, AtomicInteger> delayTimeStat) {
        this.delayTimeStat = delayTimeStat;
    }

    @JsonProperty(value="SuccessRate")
    public void setSuccessRate(float successRate) {
        this.successRate = successRate;
    }

    @JsonProperty(value="Id")
    public void setId(String id) {
        this.id = id;
    }

    public Long getReportTime() {
        return this.reportTime;
    }

    public Long getAppId() {
        return this.AppId;
    }

    public AtomicInteger getStreamNum() {
        return this.streamNum;
    }

    public AtomicInteger getVoiceIdNum() {
        return this.voiceIdNum;
    }

    public AtomicInteger getReqNum() {
        return this.reqNum;
    }

    public AtomicInteger getSuccessNum() {
        return this.successNum;
    }

    public AtomicInteger getFailNum() {
        return this.failNum;
    }

    public AtomicInteger getNonBusinessFailNum() {
        return this.nonBusinessFailNum;
    }

    public float getNonBusinessFailNumRate() {
        return this.nonBusinessFailNumRate;
    }

    public AtomicInteger getBusinessFailNum() {
        return this.businessFailNum;
    }

    public float getBusinessFailNumRate() {
        return this.businessFailNumRate;
    }

    public ConcurrentHashMap<String, AtomicInteger> getFailCodeStat() {
        return this.FailCodeStat;
    }

    public ConcurrentHashMap<String, AtomicInteger> getDelayTimeStat() {
        return this.delayTimeStat;
    }

    public float getSuccessRate() {
        return this.successRate;
    }

    public String getId() {
        return this.id;
    }

    public LogStatistics() {
    }

    public LogStatistics(Long reportTime, Long AppId, AtomicInteger streamNum, AtomicInteger voiceIdNum, AtomicInteger reqNum, AtomicInteger successNum, AtomicInteger failNum, AtomicInteger nonBusinessFailNum, float nonBusinessFailNumRate, AtomicInteger businessFailNum, float businessFailNumRate, ConcurrentHashMap<String, AtomicInteger> FailCodeStat, ConcurrentHashMap<String, AtomicInteger> delayTimeStat, float successRate, String id) {
        this.reportTime = reportTime;
        this.AppId = AppId;
        this.streamNum = streamNum;
        this.voiceIdNum = voiceIdNum;
        this.reqNum = reqNum;
        this.successNum = successNum;
        this.failNum = failNum;
        this.nonBusinessFailNum = nonBusinessFailNum;
        this.nonBusinessFailNumRate = nonBusinessFailNumRate;
        this.businessFailNum = businessFailNum;
        this.businessFailNumRate = businessFailNumRate;
        this.FailCodeStat = FailCodeStat;
        this.delayTimeStat = delayTimeStat;
        this.successRate = successRate;
        this.id = id;
    }

    public static class LogStatisticsBuilder {
        private Long reportTime;
        private Long AppId;
        private AtomicInteger streamNum;
        private AtomicInteger voiceIdNum;
        private AtomicInteger reqNum;
        private AtomicInteger successNum;
        private AtomicInteger failNum;
        private AtomicInteger nonBusinessFailNum;
        private float nonBusinessFailNumRate;
        private AtomicInteger businessFailNum;
        private float businessFailNumRate;
        private ConcurrentHashMap<String, AtomicInteger> FailCodeStat;
        private ConcurrentHashMap<String, AtomicInteger> delayTimeStat;
        private float successRate;
        private String id;

        LogStatisticsBuilder() {
        }

        @JsonProperty(value="ReportTime")
        public LogStatisticsBuilder reportTime(Long reportTime) {
            this.reportTime = reportTime;
            return this;
        }

        @JsonProperty(value="AppId")
        public LogStatisticsBuilder AppId(Long AppId) {
            this.AppId = AppId;
            return this;
        }

        @JsonProperty(value="StreamNum")
        public LogStatisticsBuilder streamNum(AtomicInteger streamNum) {
            this.streamNum = streamNum;
            return this;
        }

        @JsonProperty(value="VoiceIdNum")
        public LogStatisticsBuilder voiceIdNum(AtomicInteger voiceIdNum) {
            this.voiceIdNum = voiceIdNum;
            return this;
        }

        @JsonProperty(value="ReqNum")
        public LogStatisticsBuilder reqNum(AtomicInteger reqNum) {
            this.reqNum = reqNum;
            return this;
        }

        @JsonProperty(value="SuccessNum")
        public LogStatisticsBuilder successNum(AtomicInteger successNum) {
            this.successNum = successNum;
            return this;
        }

        @JsonProperty(value="FailNum")
        public LogStatisticsBuilder failNum(AtomicInteger failNum) {
            this.failNum = failNum;
            return this;
        }

        @JsonProperty(value="NonBusinessFailNum")
        public LogStatisticsBuilder nonBusinessFailNum(AtomicInteger nonBusinessFailNum) {
            this.nonBusinessFailNum = nonBusinessFailNum;
            return this;
        }

        @JsonProperty(value="NonBusinessFailNumRate")
        public LogStatisticsBuilder nonBusinessFailNumRate(float nonBusinessFailNumRate) {
            this.nonBusinessFailNumRate = nonBusinessFailNumRate;
            return this;
        }

        @JsonProperty(value="BusinessFailNum")
        public LogStatisticsBuilder businessFailNum(AtomicInteger businessFailNum) {
            this.businessFailNum = businessFailNum;
            return this;
        }

        @JsonProperty(value="BusinessFailNumRate")
        public LogStatisticsBuilder businessFailNumRate(float businessFailNumRate) {
            this.businessFailNumRate = businessFailNumRate;
            return this;
        }

        @JsonProperty(value="FailCodeStat")
        public LogStatisticsBuilder FailCodeStat(ConcurrentHashMap<String, AtomicInteger> FailCodeStat) {
            this.FailCodeStat = FailCodeStat;
            return this;
        }

        @JsonProperty(value="DelayTimeStat")
        public LogStatisticsBuilder delayTimeStat(ConcurrentHashMap<String, AtomicInteger> delayTimeStat) {
            this.delayTimeStat = delayTimeStat;
            return this;
        }

        @JsonProperty(value="SuccessRate")
        public LogStatisticsBuilder successRate(float successRate) {
            this.successRate = successRate;
            return this;
        }

        @JsonProperty(value="Id")
        public LogStatisticsBuilder id(String id) {
            this.id = id;
            return this;
        }

        public LogStatistics build() {
            return new LogStatistics(this.reportTime, this.AppId, this.streamNum, this.voiceIdNum, this.reqNum, this.successNum, this.failNum, this.nonBusinessFailNum, this.nonBusinessFailNumRate, this.businessFailNum, this.businessFailNumRate, this.FailCodeStat, this.delayTimeStat, this.successRate, this.id);
        }

        public String toString() {
            return "LogStatistics.LogStatisticsBuilder(reportTime=" + this.reportTime + ", AppId=" + this.AppId + ", streamNum=" + this.streamNum + ", voiceIdNum=" + this.voiceIdNum + ", reqNum=" + this.reqNum + ", successNum=" + this.successNum + ", failNum=" + this.failNum + ", nonBusinessFailNum=" + this.nonBusinessFailNum + ", nonBusinessFailNumRate=" + this.nonBusinessFailNumRate + ", businessFailNum=" + this.businessFailNum + ", businessFailNumRate=" + this.businessFailNumRate + ", FailCodeStat=" + this.FailCodeStat + ", delayTimeStat=" + this.delayTimeStat + ", successRate=" + this.successRate + ", id=" + this.id + ")";
        }
    }
}

