/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.asr.model;

import cn.hutool.core.util.RandomUtil;
import com.tencent.asr.constant.AsrConstant;
import com.tencent.core.model.TRequest;
import java.util.Map;

public class AsrRequest
extends TRequest {
    protected Integer cutLength;
    protected Integer projectId;
    protected Integer subServiceType;
    protected String engineModelType;
    protected String hotWordId;
    protected Integer resultTextFormat;
    protected Integer resType;
    protected Integer voiceFormat;
    protected Integer needVad;
    protected Integer vadSilenceTime;
    protected Integer source;
    protected Long timestamp;
    protected Long expired;
    protected Integer timeout;
    protected Integer nonce;
    protected Integer filterDirty;
    protected Integer filterModal;
    protected Integer filterPunc;
    protected Integer convertNumMode;
    protected Integer wordInfo;
    protected Map<String, Object> extendsParam;

    public static AsrRequest init() {
        AsrRequest request = new AsrRequest();
        request.projectId = 1013976;
        request.subServiceType = 1;
        request.resultTextFormat = AsrConstant.ResponseEncode.UTF_8.getId();
        request.resType = AsrConstant.ReturnType.REALTIME_FOLLOW.getTypeId();
        request.voiceFormat = AsrConstant.VoiceFormat.wav.getFormatId();
        request.needVad = 1;
        request.source = 0;
        request.timestamp = System.currentTimeMillis() / 1000L;
        request.expired = System.currentTimeMillis() / 1000L + 86400L;
        request.timeout = 200;
        request.nonce = RandomUtil.randomInt((int)1000, (int)99999);
        request.cutLength = 3200;
        return request;
    }

    public static AsrRequestBuilder builder() {
        return new AsrRequestBuilder();
    }

    public void setCutLength(Integer cutLength) {
        this.cutLength = cutLength;
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    public void setSubServiceType(Integer subServiceType) {
        this.subServiceType = subServiceType;
    }

    public void setEngineModelType(String engineModelType) {
        this.engineModelType = engineModelType;
    }

    public void setHotWordId(String hotWordId) {
        this.hotWordId = hotWordId;
    }

    public void setResultTextFormat(Integer resultTextFormat) {
        this.resultTextFormat = resultTextFormat;
    }

    public void setResType(Integer resType) {
        this.resType = resType;
    }

    public void setVoiceFormat(Integer voiceFormat) {
        this.voiceFormat = voiceFormat;
    }

    public void setNeedVad(Integer needVad) {
        this.needVad = needVad;
    }

    public void setVadSilenceTime(Integer vadSilenceTime) {
        this.vadSilenceTime = vadSilenceTime;
    }

    public void setSource(Integer source) {
        this.source = source;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public void setExpired(Long expired) {
        this.expired = expired;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public void setNonce(Integer nonce) {
        this.nonce = nonce;
    }

    public void setFilterDirty(Integer filterDirty) {
        this.filterDirty = filterDirty;
    }

    public void setFilterModal(Integer filterModal) {
        this.filterModal = filterModal;
    }

    public void setFilterPunc(Integer filterPunc) {
        this.filterPunc = filterPunc;
    }

    public void setConvertNumMode(Integer convertNumMode) {
        this.convertNumMode = convertNumMode;
    }

    public void setWordInfo(Integer wordInfo) {
        this.wordInfo = wordInfo;
    }

    public void setExtendsParam(Map<String, Object> extendsParam) {
        this.extendsParam = extendsParam;
    }

    public Integer getCutLength() {
        return this.cutLength;
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public Integer getSubServiceType() {
        return this.subServiceType;
    }

    public String getEngineModelType() {
        return this.engineModelType;
    }

    public String getHotWordId() {
        return this.hotWordId;
    }

    public Integer getResultTextFormat() {
        return this.resultTextFormat;
    }

    public Integer getResType() {
        return this.resType;
    }

    public Integer getVoiceFormat() {
        return this.voiceFormat;
    }

    public Integer getNeedVad() {
        return this.needVad;
    }

    public Integer getVadSilenceTime() {
        return this.vadSilenceTime;
    }

    public Integer getSource() {
        return this.source;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public Long getExpired() {
        return this.expired;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public Integer getNonce() {
        return this.nonce;
    }

    public Integer getFilterDirty() {
        return this.filterDirty;
    }

    public Integer getFilterModal() {
        return this.filterModal;
    }

    public Integer getFilterPunc() {
        return this.filterPunc;
    }

    public Integer getConvertNumMode() {
        return this.convertNumMode;
    }

    public Integer getWordInfo() {
        return this.wordInfo;
    }

    public Map<String, Object> getExtendsParam() {
        return this.extendsParam;
    }

    public AsrRequest() {
    }

    public AsrRequest(Integer cutLength, Integer projectId, Integer subServiceType, String engineModelType, String hotWordId, Integer resultTextFormat, Integer resType, Integer voiceFormat, Integer needVad, Integer vadSilenceTime, Integer source, Long timestamp, Long expired, Integer timeout, Integer nonce, Integer filterDirty, Integer filterModal, Integer filterPunc, Integer convertNumMode, Integer wordInfo, Map<String, Object> extendsParam) {
        this.cutLength = cutLength;
        this.projectId = projectId;
        this.subServiceType = subServiceType;
        this.engineModelType = engineModelType;
        this.hotWordId = hotWordId;
        this.resultTextFormat = resultTextFormat;
        this.resType = resType;
        this.voiceFormat = voiceFormat;
        this.needVad = needVad;
        this.vadSilenceTime = vadSilenceTime;
        this.source = source;
        this.timestamp = timestamp;
        this.expired = expired;
        this.timeout = timeout;
        this.nonce = nonce;
        this.filterDirty = filterDirty;
        this.filterModal = filterModal;
        this.filterPunc = filterPunc;
        this.convertNumMode = convertNumMode;
        this.wordInfo = wordInfo;
        this.extendsParam = extendsParam;
    }

    public static class AsrRequestBuilder {
        private Integer cutLength;
        private Integer projectId;
        private Integer subServiceType;
        private String engineModelType;
        private String hotWordId;
        private Integer resultTextFormat;
        private Integer resType;
        private Integer voiceFormat;
        private Integer needVad;
        private Integer vadSilenceTime;
        private Integer source;
        private Long timestamp;
        private Long expired;
        private Integer timeout;
        private Integer nonce;
        private Integer filterDirty;
        private Integer filterModal;
        private Integer filterPunc;
        private Integer convertNumMode;
        private Integer wordInfo;
        private Map<String, Object> extendsParam;

        AsrRequestBuilder() {
        }

        public AsrRequestBuilder cutLength(Integer cutLength) {
            this.cutLength = cutLength;
            return this;
        }

        public AsrRequestBuilder projectId(Integer projectId) {
            this.projectId = projectId;
            return this;
        }

        public AsrRequestBuilder subServiceType(Integer subServiceType) {
            this.subServiceType = subServiceType;
            return this;
        }

        public AsrRequestBuilder engineModelType(String engineModelType) {
            this.engineModelType = engineModelType;
            return this;
        }

        public AsrRequestBuilder hotWordId(String hotWordId) {
            this.hotWordId = hotWordId;
            return this;
        }

        public AsrRequestBuilder resultTextFormat(Integer resultTextFormat) {
            this.resultTextFormat = resultTextFormat;
            return this;
        }

        public AsrRequestBuilder resType(Integer resType) {
            this.resType = resType;
            return this;
        }

        public AsrRequestBuilder voiceFormat(Integer voiceFormat) {
            this.voiceFormat = voiceFormat;
            return this;
        }

        public AsrRequestBuilder needVad(Integer needVad) {
            this.needVad = needVad;
            return this;
        }

        public AsrRequestBuilder vadSilenceTime(Integer vadSilenceTime) {
            this.vadSilenceTime = vadSilenceTime;
            return this;
        }

        public AsrRequestBuilder source(Integer source) {
            this.source = source;
            return this;
        }

        public AsrRequestBuilder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public AsrRequestBuilder expired(Long expired) {
            this.expired = expired;
            return this;
        }

        public AsrRequestBuilder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public AsrRequestBuilder nonce(Integer nonce) {
            this.nonce = nonce;
            return this;
        }

        public AsrRequestBuilder filterDirty(Integer filterDirty) {
            this.filterDirty = filterDirty;
            return this;
        }

        public AsrRequestBuilder filterModal(Integer filterModal) {
            this.filterModal = filterModal;
            return this;
        }

        public AsrRequestBuilder filterPunc(Integer filterPunc) {
            this.filterPunc = filterPunc;
            return this;
        }

        public AsrRequestBuilder convertNumMode(Integer convertNumMode) {
            this.convertNumMode = convertNumMode;
            return this;
        }

        public AsrRequestBuilder wordInfo(Integer wordInfo) {
            this.wordInfo = wordInfo;
            return this;
        }

        public AsrRequestBuilder extendsParam(Map<String, Object> extendsParam) {
            this.extendsParam = extendsParam;
            return this;
        }

        public AsrRequest build() {
            return new AsrRequest(this.cutLength, this.projectId, this.subServiceType, this.engineModelType, this.hotWordId, this.resultTextFormat, this.resType, this.voiceFormat, this.needVad, this.vadSilenceTime, this.source, this.timestamp, this.expired, this.timeout, this.nonce, this.filterDirty, this.filterModal, this.filterPunc, this.convertNumMode, this.wordInfo, this.extendsParam);
        }

        public String toString() {
            return "AsrRequest.AsrRequestBuilder(cutLength=" + this.cutLength + ", projectId=" + this.projectId + ", subServiceType=" + this.subServiceType + ", engineModelType=" + this.engineModelType + ", hotWordId=" + this.hotWordId + ", resultTextFormat=" + this.resultTextFormat + ", resType=" + this.resType + ", voiceFormat=" + this.voiceFormat + ", needVad=" + this.needVad + ", vadSilenceTime=" + this.vadSilenceTime + ", source=" + this.source + ", timestamp=" + this.timestamp + ", expired=" + this.expired + ", timeout=" + this.timeout + ", nonce=" + this.nonce + ", filterDirty=" + this.filterDirty + ", filterModal=" + this.filterModal + ", filterPunc=" + this.filterPunc + ", convertNumMode=" + this.convertNumMode + ", wordInfo=" + this.wordInfo + ", extendsParam=" + this.extendsParam + ")";
        }
    }
}

