/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader.shareutil;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.ShareTinkerLog;
import java.io.File;
import java.io.IOException;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ShareSecurityCheck {
    private static final String TAG = "Tinker.SecurityCheck";
    private static String mPublicKeyMd5 = null;
    private final Context mContext;
    private final HashMap<String, String> metaContentMap;
    private final HashMap<String, String> packageProperties;

    public ShareSecurityCheck(Context context) {
        this.mContext = context;
        this.metaContentMap = new HashMap();
        this.packageProperties = new HashMap();
        if (mPublicKeyMd5 == null) {
            this.init(this.mContext);
        }
    }

    public HashMap<String, String> getMetaContentMap() {
        return this.metaContentMap;
    }

    public HashMap<String, String> getPackagePropertiesIfPresent() {
        String[] lines;
        if (!this.packageProperties.isEmpty()) {
            return this.packageProperties;
        }
        String property = this.metaContentMap.get("assets/package_meta.txt");
        if (property == null) {
            return null;
        }
        for (String line : lines = property.split("\n")) {
            String[] kv;
            if (line == null || line.length() <= 0 || line.startsWith("#") || (kv = line.split("=", 2)) == null || kv.length < 2) continue;
            this.packageProperties.put(kv[0].trim(), kv[1].trim());
        }
        return this.packageProperties;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean verifyPatchMetaSignature(File path) {
        JarFile jarFile;
        block14: {
            boolean bl;
            block13: {
                if (!SharePatchFileUtil.isLegalFile(path)) {
                    return false;
                }
                jarFile = null;
                try {
                    jarFile = new JarFile(path);
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        String name;
                        JarEntry jarEntry = entries.nextElement();
                        if (jarEntry == null || (name = jarEntry.getName()).startsWith("META-INF/") || !name.endsWith("meta.txt")) continue;
                        this.metaContentMap.put(name, SharePatchFileUtil.loadDigestes(jarFile, jarEntry));
                        Certificate[] certs = jarEntry.getCertificates();
                        if (certs != null && this.check(path, certs)) continue;
                        bl = false;
                        break block13;
                    }
                    break block14;
                }
                catch (Exception e) {
                    try {
                        throw new TinkerRuntimeException(String.format("ShareSecurityCheck file %s, size %d verifyPatchMetaSignature fail", path.getAbsolutePath(), path.length()), e);
                    }
                    catch (Throwable throwable) {
                        try {
                            if (jarFile == null) throw throwable;
                            jarFile.close();
                            throw throwable;
                        }
                        catch (IOException e2) {
                            ShareTinkerLog.e(TAG, path.getAbsolutePath(), e2);
                        }
                        throw throwable;
                    }
                }
            }
            try {
                if (jarFile == null) return bl;
                jarFile.close();
                return bl;
            }
            catch (IOException e) {
                ShareTinkerLog.e(TAG, path.getAbsolutePath(), e);
            }
            return bl;
        }
        try {
            if (jarFile == null) return true;
            jarFile.close();
            return true;
        }
        catch (IOException e) {
            ShareTinkerLog.e(TAG, path.getAbsolutePath(), e);
            return true;
        }
    }

    private boolean check(File path, Certificate[] certs) {
        if (certs.length > 0) {
            for (int i = certs.length - 1; i >= 0; --i) {
                try {
                    if (mPublicKeyMd5.equals(SharePatchFileUtil.getMD5(certs[i].getEncoded()))) {
                        return true;
                    }
                    continue;
                }
                catch (Exception e) {
                    ShareTinkerLog.e(TAG, path.getAbsolutePath(), e);
                }
            }
        }
        return false;
    }

    @SuppressLint(value={"PackageManagerGetSignatures"})
    private void init(Context context) {
        Object stream = null;
        try {
            PackageManager pm = context.getPackageManager();
            String packageName = context.getPackageName();
            PackageInfo packageInfo = pm.getPackageInfo(packageName, 64);
            mPublicKeyMd5 = SharePatchFileUtil.getMD5(packageInfo.signatures[0].toByteArray());
            if (mPublicKeyMd5 == null) {
                throw new TinkerRuntimeException("get public key md5 is null");
            }
        }
        catch (Exception e) {
            throw new TinkerRuntimeException("ShareSecurityCheck init public key fail", e);
        }
        finally {
            SharePatchFileUtil.closeQuietly(stream);
        }
    }
}

