/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader.shareutil;

import android.os.Build;
import android.util.Log;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.shareutil.ShareFileLockHelper;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import com.tencent.tinker.loader.shareutil.ShareTinkerLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class SharePatchInfo {
    private static final String TAG = "Tinker.PatchInfo";
    public static final int MAX_EXTRACT_ATTEMPTS = 2;
    public static final String OLD_VERSION = "old";
    public static final String NEW_VERSION = "new";
    public static final String IS_PROTECTED_APP = "is_protected_app";
    public static final String USE_CUSTOM_FILE_PATCH = "use_custom_file_patch";
    public static final String VERSION_TO_REMOVE = "version_to_remove";
    public static final String FINGER_PRINT = "print";
    public static final String OAT_DIR = "dir";
    public static final String IS_REMOVE_INTERPRET_OAT_DIR = "is_remove_interpret_oat_dir";
    public static final String DEFAULT_DIR = "odex";
    public String oldVersion;
    public String newVersion;
    public boolean isProtectedApp;
    public boolean useCustomPatch;
    public String versionToRemove;
    public String fingerPrint;
    public String oatDir;
    public boolean isRemoveInterpretOATDir;

    public SharePatchInfo(String oldVer, String newVer, boolean isProtectedApp, boolean useCustomPatch, String versionToRemove, String finger, String oatDir, boolean isRemoveInterpretOATDir) {
        this.oldVersion = oldVer;
        this.newVersion = newVer;
        this.isProtectedApp = isProtectedApp;
        this.versionToRemove = versionToRemove;
        this.fingerPrint = finger;
        this.oatDir = oatDir;
        this.isRemoveInterpretOATDir = isRemoveInterpretOATDir;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SharePatchInfo readAndCheckPropertyWithLock(File pathInfoFile, File lockFile) {
        SharePatchInfo patchInfo;
        if (pathInfoFile == null) return null;
        if (lockFile == null) {
            return null;
        }
        File lockParentFile = lockFile.getParentFile();
        if (!lockParentFile.exists()) {
            lockParentFile.mkdirs();
        }
        ShareFileLockHelper fileLock = null;
        try {
            fileLock = ShareFileLockHelper.getFileLock(lockFile);
            patchInfo = SharePatchInfo.readAndCheckProperty(pathInfoFile);
        }
        catch (Exception e) {
            try {
                throw new TinkerRuntimeException("readAndCheckPropertyWithLock fail", e);
            }
            catch (Throwable throwable) {
                try {
                    if (fileLock == null) throw throwable;
                    fileLock.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    ShareTinkerLog.w(TAG, "releaseInfoLock error", e2);
                }
                throw throwable;
            }
        }
        try {
            if (fileLock == null) return patchInfo;
            fileLock.close();
            return patchInfo;
        }
        catch (IOException e) {
            ShareTinkerLog.w(TAG, "releaseInfoLock error", e);
            return patchInfo;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean rewritePatchInfoFileWithLock(File pathInfoFile, SharePatchInfo info, File lockFile) {
        boolean rewriteSuccess;
        if (pathInfoFile == null) return false;
        if (info == null) return false;
        if (lockFile == null) {
            return false;
        }
        File lockParentFile = lockFile.getParentFile();
        if (!lockParentFile.exists()) {
            lockParentFile.mkdirs();
        }
        ShareFileLockHelper fileLock = null;
        try {
            fileLock = ShareFileLockHelper.getFileLock(lockFile);
            rewriteSuccess = SharePatchInfo.rewritePatchInfoFile(pathInfoFile, info);
        }
        catch (Exception e) {
            try {
                throw new TinkerRuntimeException("rewritePatchInfoFileWithLock fail", e);
            }
            catch (Throwable throwable) {
                try {
                    if (fileLock == null) throw throwable;
                    fileLock.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    ShareTinkerLog.i(TAG, "releaseInfoLock error", e2);
                }
                throw throwable;
            }
        }
        try {
            if (fileLock == null) return rewriteSuccess;
            fileLock.close();
            return rewriteSuccess;
        }
        catch (IOException e) {
            ShareTinkerLog.i(TAG, "releaseInfoLock error", e);
            return rewriteSuccess;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SharePatchInfo readAndCheckProperty(File pathInfoFile) {
        boolean isReadPatchSuccessful = false;
        int numAttempts = 0;
        String oldVer = null;
        String newVer = null;
        String lastFingerPrint = null;
        boolean isProtectedApp = false;
        boolean useCustomPatch = false;
        String versionToRemove = null;
        String oatDir = null;
        boolean isRemoveInterpretOATDir = false;
        while (numAttempts < 2 && !isReadPatchSuccessful) {
            ++numAttempts;
            Properties properties = new Properties();
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(pathInfoFile);
                properties.load(inputStream);
                oldVer = properties.getProperty(OLD_VERSION);
                newVer = properties.getProperty(NEW_VERSION);
                String isProtectedAppStr = properties.getProperty(IS_PROTECTED_APP);
                isProtectedApp = isProtectedAppStr != null && !isProtectedAppStr.isEmpty() && !"0".equals(isProtectedAppStr);
                String useCustomPatchStr = properties.getProperty(USE_CUSTOM_FILE_PATCH);
                useCustomPatch = useCustomPatchStr != null && !useCustomPatchStr.isEmpty() && !"0".equals(useCustomPatchStr);
                versionToRemove = properties.getProperty(VERSION_TO_REMOVE);
                lastFingerPrint = properties.getProperty(FINGER_PRINT);
                oatDir = properties.getProperty(OAT_DIR);
                String isRemoveInterpretOATDirStr = properties.getProperty(IS_REMOVE_INTERPRET_OAT_DIR);
                isRemoveInterpretOATDir = isRemoveInterpretOATDirStr != null && !isRemoveInterpretOATDirStr.isEmpty() && !"0".equals(isRemoveInterpretOATDirStr);
            }
            catch (IOException e) {
                try {
                    ShareTinkerLog.w(TAG, "read property failed, e:" + e, new Object[0]);
                }
                catch (Throwable throwable) {
                    SharePatchFileUtil.closeQuietly(inputStream);
                    throw throwable;
                }
                SharePatchFileUtil.closeQuietly(inputStream);
            }
            SharePatchFileUtil.closeQuietly(inputStream);
            if (oldVer == null || newVer == null) continue;
            if (!oldVer.equals("") && !SharePatchFileUtil.checkIfMd5Valid(oldVer) || !SharePatchFileUtil.checkIfMd5Valid(newVer)) {
                ShareTinkerLog.w(TAG, "path info file  corrupted:" + pathInfoFile.getAbsolutePath(), new Object[0]);
                continue;
            }
            isReadPatchSuccessful = true;
        }
        if (isReadPatchSuccessful) {
            return new SharePatchInfo(oldVer, newVer, isProtectedApp, useCustomPatch, versionToRemove, lastFingerPrint, oatDir, isRemoveInterpretOATDir);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean rewritePatchInfoFile(File pathInfoFile, SharePatchInfo info) {
        if (pathInfoFile == null || info == null) {
            return false;
        }
        if (ShareTinkerInternals.isNullOrNil(info.fingerPrint)) {
            info.fingerPrint = Build.FINGERPRINT;
        }
        if (ShareTinkerInternals.isNullOrNil(info.oatDir)) {
            info.oatDir = DEFAULT_DIR;
        }
        ShareTinkerLog.i(TAG, "rewritePatchInfoFile file path:" + pathInfoFile.getAbsolutePath() + " , oldVer:" + info.oldVersion + ", newVer:" + info.newVersion + ", isProtectedApp:" + (info.isProtectedApp ? 1 : 0) + ", versionToRemove:" + info.versionToRemove + ", fingerprint:" + info.fingerPrint + ", oatDir:" + info.oatDir + ", isRemoveInterpretOATDir:" + (info.isRemoveInterpretOATDir ? 1 : 0) + ", stack: " + Log.getStackTraceString((Throwable)new Throwable()), new Object[0]);
        boolean isWritePatchSuccessful = false;
        int numAttempts = 0;
        File parentFile = pathInfoFile.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        while (numAttempts < 2 && !isWritePatchSuccessful) {
            SharePatchInfo tempInfo;
            ++numAttempts;
            Properties newProperties = new Properties();
            newProperties.put(OLD_VERSION, info.oldVersion);
            newProperties.put(NEW_VERSION, info.newVersion);
            newProperties.put(IS_PROTECTED_APP, info.isProtectedApp ? "1" : "0");
            newProperties.put(USE_CUSTOM_FILE_PATCH, info.useCustomPatch ? "1" : "0");
            newProperties.put(VERSION_TO_REMOVE, info.versionToRemove);
            newProperties.put(FINGER_PRINT, info.fingerPrint);
            newProperties.put(OAT_DIR, info.oatDir);
            newProperties.put(IS_REMOVE_INTERPRET_OAT_DIR, info.isRemoveInterpretOATDir ? "1" : "0");
            FileOutputStream outputStream = null;
            try {
                outputStream = new FileOutputStream(pathInfoFile, false);
                String comment = "from old version:" + info.oldVersion + " to new version:" + info.newVersion;
                newProperties.store(outputStream, comment);
            }
            catch (Exception e) {
                try {
                    ShareTinkerLog.w(TAG, "write property failed, e:" + e, new Object[0]);
                }
                catch (Throwable throwable) {
                    SharePatchFileUtil.closeQuietly(outputStream);
                    throw throwable;
                }
                SharePatchFileUtil.closeQuietly(outputStream);
            }
            SharePatchFileUtil.closeQuietly(outputStream);
            if (isWritePatchSuccessful = (tempInfo = SharePatchInfo.readAndCheckProperty(pathInfoFile)) != null && tempInfo.oldVersion.equals(info.oldVersion) && tempInfo.newVersion.equals(info.newVersion)) continue;
            pathInfoFile.delete();
        }
        return isWritePatchSuccessful;
    }
}

