/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader.shareutil;

import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import java.util.ArrayList;

public class ShareDexDiffPatchInfo {
    public final String rawName;
    public final String destMd5InDvm;
    public final String destMd5InArt;
    public final String oldDexCrC;
    public final String newOrPatchedDexCrC;
    public final String dexDiffMd5;
    public final String path;
    public final String dexMode;
    public final boolean isJarMode;
    public final String realName;

    public ShareDexDiffPatchInfo(String name, String path, String destMd5InDvm, String destMd5InArt, String dexDiffMd5, String oldDexCrc, String newOrPatchedDexCrC, String dexMode) {
        this.rawName = name;
        this.path = path;
        this.destMd5InDvm = destMd5InDvm;
        this.destMd5InArt = destMd5InArt;
        this.dexDiffMd5 = dexDiffMd5;
        this.oldDexCrC = oldDexCrc;
        this.newOrPatchedDexCrC = newOrPatchedDexCrC;
        this.dexMode = dexMode;
        if (dexMode.equals("jar")) {
            this.isJarMode = true;
            this.realName = SharePatchFileUtil.isRawDexFile(name) ? name + ".jar" : name;
        } else if (dexMode.equals("raw")) {
            this.isJarMode = false;
            this.realName = name;
        } else {
            throw new TinkerRuntimeException("can't recognize dex mode:" + dexMode);
        }
    }

    public static void parseDexDiffPatchInfo(String meta, ArrayList<ShareDexDiffPatchInfo> dexList) {
        String[] lines;
        if (meta == null || meta.length() == 0) {
            return;
        }
        for (String line : lines = meta.split("\n")) {
            String[] kv;
            if (line == null || line.length() <= 0 || (kv = line.split(",", 8)) == null || kv.length < 8) continue;
            String name = kv[0].trim();
            String path = kv[1].trim();
            String destMd5InDvm = kv[2].trim();
            String destMd5InArt = kv[3].trim();
            String dexDiffMd5 = kv[4].trim();
            String oldDexCrc = kv[5].trim();
            String newDexCrc = kv[6].trim();
            String dexMode = kv[7].trim();
            ShareDexDiffPatchInfo dexInfo = new ShareDexDiffPatchInfo(name, path, destMd5InDvm, destMd5InArt, dexDiffMd5, oldDexCrc, newDexCrc, dexMode);
            dexList.add(dexInfo);
        }
    }

    public static boolean checkDexDiffPatchInfo(ShareDexDiffPatchInfo info) {
        String md5;
        if (info == null) {
            return false;
        }
        String name = info.rawName;
        String string = md5 = ShareTinkerInternals.isVmArt() ? info.destMd5InArt : info.destMd5InDvm;
        return name != null && name.length() > 0 && md5 != null && md5.length() == 32;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.rawName);
        sb.append(",");
        sb.append(this.path);
        sb.append(",");
        sb.append(this.destMd5InDvm);
        sb.append(",");
        sb.append(this.destMd5InArt);
        sb.append(",");
        sb.append(this.oldDexCrC);
        sb.append(",");
        sb.append(this.newOrPatchedDexCrC);
        sb.append(",");
        sb.append(this.dexDiffMd5);
        sb.append(",");
        sb.append(this.dexMode);
        return sb.toString();
    }
}

