/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader.hotplug.interceptor;

import com.tencent.tinker.loader.hotplug.interceptor.InterceptFailedException;
import com.tencent.tinker.loader.shareutil.ShareTinkerLog;

public abstract class Interceptor<T_TARGET> {
    private static final String TAG = "Tinker.Interceptor";
    private T_TARGET mTarget = null;
    private volatile boolean mInstalled = false;

    protected abstract T_TARGET fetchTarget() throws Throwable;

    protected T_TARGET decorate(T_TARGET target) throws Throwable {
        return target;
    }

    protected abstract void inject(T_TARGET var1) throws Throwable;

    public synchronized void install() throws InterceptFailedException {
        try {
            T_TARGET target = this.fetchTarget();
            this.mTarget = target;
            T_TARGET decorated = this.decorate(target);
            if (decorated != target) {
                this.inject(decorated);
            } else {
                ShareTinkerLog.w(TAG, "target: " + target + " was already hooked.", new Object[0]);
            }
            this.mInstalled = true;
        }
        catch (Throwable thr) {
            this.mTarget = null;
            throw new InterceptFailedException(thr);
        }
    }

    public synchronized void uninstall() throws InterceptFailedException {
        if (this.mInstalled) {
            try {
                this.inject(this.mTarget);
                this.mTarget = null;
                this.mInstalled = false;
            }
            catch (Throwable thr) {
                throw new InterceptFailedException(thr);
            }
        }
    }

    protected static interface ITinkerHotplugProxy {
    }
}

