/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader.app;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Handler;
import android.os.SystemClock;
import com.tencent.tinker.anno.Keep;
import com.tencent.tinker.loader.TinkerLoader;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.TinkerUncaughtHandler;
import com.tencent.tinker.loader.app.TinkerInlineFenceAction;
import com.tencent.tinker.loader.shareutil.ShareIntentUtil;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public abstract class TinkerApplication
extends Application {
    private static final String INTENT_PATCH_EXCEPTION = "intent_patch_exception";
    private static final String TINKER_LOADER_METHOD = "tryLoad";
    private static final TinkerApplication[] SELF_HOLDER = new TinkerApplication[]{null};
    private final int tinkerFlags;
    private final boolean tinkerLoadVerifyFlag;
    private final String delegateClassName;
    private final String loaderClassName;
    private boolean useSafeMode;
    protected Intent tinkerResultIntent;
    protected ClassLoader mCurrentClassLoader = null;
    private Handler mInlineFence = null;
    private final boolean useDelegateLastClassLoader;
    private final boolean useInterpretModeOnSupported32BitSystem;

    protected TinkerApplication(int tinkerFlags) {
        this(tinkerFlags, "com.tencent.tinker.entry.DefaultApplicationLike");
    }

    protected TinkerApplication(int tinkerFlags, String delegateClassName) {
        this(tinkerFlags, delegateClassName, TinkerLoader.class.getName(), false);
    }

    protected TinkerApplication(int tinkerFlags, String delegateClassName, String loaderClassName, boolean tinkerLoadVerifyFlag) {
        this(tinkerFlags, delegateClassName, loaderClassName, tinkerLoadVerifyFlag, true, false);
    }

    protected TinkerApplication(int tinkerFlags, String delegateClassName, String loaderClassName, boolean tinkerLoadVerifyFlag, boolean useDelegateLastClassLoader) {
        this(tinkerFlags, delegateClassName, loaderClassName, tinkerLoadVerifyFlag, useDelegateLastClassLoader, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TinkerApplication(int tinkerFlags, String delegateClassName, String loaderClassName, boolean tinkerLoadVerifyFlag, boolean useDelegateLastClassLoader, boolean useInterpretModeOnSupported32BitSystem) {
        TinkerApplication[] tinkerApplicationArray = SELF_HOLDER;
        synchronized (SELF_HOLDER) {
            TinkerApplication.SELF_HOLDER[0] = this;
            // ** MonitorExit[var7_7] (shouldn't be in output)
            this.tinkerFlags = tinkerFlags;
            this.delegateClassName = delegateClassName;
            this.loaderClassName = loaderClassName;
            this.tinkerLoadVerifyFlag = tinkerLoadVerifyFlag;
            this.useDelegateLastClassLoader = useDelegateLastClassLoader;
            this.useInterpretModeOnSupported32BitSystem = useInterpretModeOnSupported32BitSystem;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TinkerApplication getInstance() {
        TinkerApplication[] tinkerApplicationArray = SELF_HOLDER;
        synchronized (SELF_HOLDER) {
            if (SELF_HOLDER[0] == null) {
                throw new IllegalStateException("TinkerApplication is not initialized.");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return SELF_HOLDER[0];
        }
    }

    private void loadTinker() {
        try {
            Class<?> tinkerLoadClass = Class.forName(this.loaderClassName, false, TinkerApplication.class.getClassLoader());
            Method loadMethod = tinkerLoadClass.getMethod(TINKER_LOADER_METHOD, TinkerApplication.class);
            Constructor<?> constructor = tinkerLoadClass.getConstructor(new Class[0]);
            this.tinkerResultIntent = (Intent)loadMethod.invoke(constructor.newInstance(new Object[0]), new Object[]{this});
        }
        catch (Throwable e) {
            this.tinkerResultIntent = new Intent();
            ShareIntentUtil.setIntentReturnCode(this.tinkerResultIntent, -20);
            this.tinkerResultIntent.putExtra(INTENT_PATCH_EXCEPTION, (Serializable)e);
        }
    }

    private Handler createInlineFence(Application app, int tinkerFlags, String delegateClassName, boolean tinkerLoadVerifyFlag, long applicationStartElapsedTime, long applicationStartMillisTime, Intent resultIntent) {
        try {
            Class<?> delegateClass = Class.forName(delegateClassName, false, this.mCurrentClassLoader);
            Constructor<?> constructor = delegateClass.getConstructor(Application.class, Integer.TYPE, Boolean.TYPE, Long.TYPE, Long.TYPE, Intent.class);
            Object appLike = constructor.newInstance(app, tinkerFlags, tinkerLoadVerifyFlag, applicationStartElapsedTime, applicationStartMillisTime, resultIntent);
            Class<?> inlineFenceClass = Class.forName("com.tencent.tinker.entry.TinkerApplicationInlineFence", false, this.mCurrentClassLoader);
            Class<?> appLikeClass = Class.forName("com.tencent.tinker.entry.ApplicationLike", false, this.mCurrentClassLoader);
            Constructor<?> inlineFenceCtor = inlineFenceClass.getConstructor(appLikeClass);
            inlineFenceCtor.setAccessible(true);
            return (Handler)inlineFenceCtor.newInstance(appLike);
        }
        catch (Throwable thr) {
            throw new TinkerRuntimeException("createInlineFence failed", thr);
        }
    }

    protected void onBaseContextAttached(Context base, long applicationStartElapsedTime, long applicationStartMillisTime) {
        try {
            this.loadTinker();
            this.mCurrentClassLoader = base.getClassLoader();
            this.mInlineFence = this.createInlineFence(this, this.tinkerFlags, this.delegateClassName, this.tinkerLoadVerifyFlag, applicationStartElapsedTime, applicationStartMillisTime, this.tinkerResultIntent);
            TinkerInlineFenceAction.callOnBaseContextAttached(this.mInlineFence, base);
            if (this.useSafeMode) {
                ShareTinkerInternals.setSafeModeCount((Context)this, 0);
            }
        }
        catch (TinkerRuntimeException e) {
            throw e;
        }
        catch (Throwable thr) {
            throw new TinkerRuntimeException(thr.getMessage(), thr);
        }
    }

    protected void attachBaseContext(Context base) {
        super.attachBaseContext(base);
        long applicationStartElapsedTime = SystemClock.elapsedRealtime();
        long applicationStartMillisTime = System.currentTimeMillis();
        Thread.setDefaultUncaughtExceptionHandler(new TinkerUncaughtHandler((Context)this));
        this.onBaseContextAttached(base, applicationStartElapsedTime, applicationStartMillisTime);
    }

    public void onCreate() {
        super.onCreate();
        if (this.mInlineFence == null) {
            return;
        }
        TinkerInlineFenceAction.callOnCreate(this.mInlineFence);
    }

    public void onTerminate() {
        super.onTerminate();
        if (this.mInlineFence == null) {
            return;
        }
        TinkerInlineFenceAction.callOnTerminate(this.mInlineFence);
    }

    public void onLowMemory() {
        super.onLowMemory();
        if (this.mInlineFence == null) {
            return;
        }
        TinkerInlineFenceAction.callOnLowMemory(this.mInlineFence);
    }

    @TargetApi(value=14)
    public void onTrimMemory(int level) {
        super.onTrimMemory(level);
        if (this.mInlineFence == null) {
            return;
        }
        TinkerInlineFenceAction.callOnTrimMemory(this.mInlineFence, level);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.mInlineFence == null) {
            return;
        }
        TinkerInlineFenceAction.callOnConfigurationChanged(this.mInlineFence, newConfig);
    }

    public Resources getResources() {
        Resources resources = super.getResources();
        if (this.mInlineFence == null) {
            return resources;
        }
        return TinkerInlineFenceAction.callGetResources(this.mInlineFence, resources);
    }

    public ClassLoader getClassLoader() {
        ClassLoader classLoader = super.getClassLoader();
        if (this.mInlineFence == null) {
            return classLoader;
        }
        return TinkerInlineFenceAction.callGetClassLoader(this.mInlineFence, classLoader);
    }

    public AssetManager getAssets() {
        AssetManager assets = super.getAssets();
        if (this.mInlineFence == null) {
            return assets;
        }
        return TinkerInlineFenceAction.callGetAssets(this.mInlineFence, assets);
    }

    public Object getSystemService(String name) {
        Object service = super.getSystemService(name);
        if (this.mInlineFence == null) {
            return service;
        }
        return TinkerInlineFenceAction.callGetSystemService(this.mInlineFence, name, service);
    }

    public Context getBaseContext() {
        Context base = super.getBaseContext();
        if (this.mInlineFence == null) {
            return base;
        }
        return TinkerInlineFenceAction.callGetBaseContext(this.mInlineFence, base);
    }

    @Keep
    public int mzNightModeUseOf() {
        if (this.mInlineFence == null) {
            return 1;
        }
        return TinkerInlineFenceAction.callMZNightModeUseOf(this.mInlineFence);
    }

    public void setUseSafeMode(boolean useSafeMode) {
        this.useSafeMode = useSafeMode;
    }

    public boolean isTinkerLoadVerifyFlag() {
        return this.tinkerLoadVerifyFlag;
    }

    public int getTinkerFlags() {
        return this.tinkerFlags;
    }

    public boolean isUseDelegateLastClassLoader() {
        return this.useDelegateLastClassLoader;
    }

    public boolean isUseInterpretModeOnSupported32BitSystem() {
        return this.useInterpretModeOnSupported32BitSystem;
    }
}

