/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader;

import android.content.Context;
import android.content.ContextWrapper;
import android.content.pm.PackageManager;
import android.os.Binder;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.SystemClock;
import com.tencent.tinker.loader.NewClassLoaderInjector;
import com.tencent.tinker.loader.app.TinkerApplication;
import com.tencent.tinker.loader.shareutil.ShareFileLockHelper;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.ShareReflectUtil;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import com.tencent.tinker.loader.shareutil.ShareTinkerLog;
import dalvik.system.DexFile;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public final class TinkerDexOptimizer {
    private static final String TAG = "Tinker.ParallelDex";
    private static final String INTERPRET_LOCK_FILE_NAME = "interpret.lock";
    private static final int[] sPerformDexOptSecondaryTransactionCode = new int[]{-1};
    private static final IBinder[] sPMSBinderProxy = new IBinder[]{null};
    private static final int SHELL_COMMAND_TRANSACTION = 1598246212;
    private static final Handler sHandler = new Handler(Looper.getMainLooper());
    private static final ResultReceiver sEmptyResultReceiver = new ResultReceiver(sHandler);
    private static final PackageManager[] sSynchronizedPMCache = new PackageManager[]{null};

    public static boolean optimizeAll(Context context, Collection<File> dexFiles, File optimizedDir, boolean useDLC, boolean useEmergencyMode, ResultCallback cb) {
        String targetISA = ShareTinkerInternals.getCurrentInstructionSet();
        return TinkerDexOptimizer.optimizeAll(context, dexFiles, optimizedDir, false, useDLC, targetISA, useEmergencyMode, cb);
    }

    public static boolean optimizeAll(Context context, Collection<File> dexFiles, File optimizedDir, boolean useInterpretMode, boolean useDLC, String targetISA, boolean useEmergencyMode, ResultCallback cb) {
        ArrayList<File> sortList = new ArrayList<File>(dexFiles);
        Collections.sort(sortList, new Comparator<File>(){

            @Override
            public int compare(File lhs, File rhs) {
                long rhsSize;
                long lhsSize = lhs.length();
                if (lhsSize < (rhsSize = rhs.length())) {
                    return 1;
                }
                if (lhsSize == rhsSize) {
                    return 0;
                }
                return -1;
            }
        });
        for (File dexFile : sortList) {
            OptimizeWorker worker = new OptimizeWorker(context, dexFile, optimizedDir, useInterpretMode, useDLC, targetISA, useEmergencyMode, cb);
            if (worker.run()) continue;
            return false;
        }
        return true;
    }

    private static void createFakeODexPathStructureOnDemand(String odexPath) {
        if (!ShareTinkerInternals.isNewerOrEqualThanVersion(29, true)) {
            return;
        }
        ShareTinkerLog.i(TAG, "Creating fake odex path structure.", new Object[0]);
        File odexFile = new File(odexPath);
        if (!odexFile.exists()) {
            File odexDir = odexFile.getParentFile();
            if (!odexDir.exists()) {
                odexDir.mkdirs();
            }
            try {
                odexFile.createNewFile();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void triggerPMDexOptOnDemand(Context context, String dexPath, String oatPath) throws Exception {
        int i;
        if (!ShareTinkerInternals.isNewerOrEqualThanVersion(29, true)) {
            ShareTinkerLog.w(TAG, "[+] Not API 29, 30 and newer device, skip triggering dexopt.", new Object[0]);
            return;
        }
        ShareTinkerLog.i(TAG, "[+] Hit target device, do dexopt logic now.", new Object[0]);
        File oatFile = new File(oatPath);
        if (SharePatchFileUtil.isLegalFile(oatFile)) {
            ShareTinkerLog.i(TAG, "[+] Oat file %s should be valid, skip triggering dexopt.", oatPath);
            return;
        }
        File dexFile = new File(dexPath);
        for (i = 0; i < 10; ++i) {
            if (!TinkerDexOptimizer.triggerSecondaryDexOpt(context, dexFile, oatFile, true)) continue;
            return;
        }
        if (!SharePatchFileUtil.isLegalFile(oatFile)) {
            if ("huawei".equalsIgnoreCase(Build.MANUFACTURER) || "honor".equalsIgnoreCase(Build.MANUFACTURER)) {
                for (i = 0; i < 5; ++i) {
                    try {
                        TinkerDexOptimizer.registerDexModule(context, dexPath);
                        if (SharePatchFileUtil.isLegalFile(oatFile)) {
                            break;
                        }
                    }
                    catch (Throwable thr) {
                        ShareTinkerLog.printErrStackTrace(TAG, thr, "[-] Error.", new Object[0]);
                    }
                    SystemClock.sleep((long)3000L);
                }
                if (!SharePatchFileUtil.isLegalFile(oatFile)) {
                    throw new IllegalStateException("No odex file was generated after calling registerDexModule");
                }
            } else {
                throw new IllegalStateException("No odex file was generated after calling performDexOptSecondary");
            }
        }
    }

    private static boolean triggerSecondaryDexOpt(Context context, File dexFile, File oatFile, boolean waitForOAT) {
        try {
            TinkerDexOptimizer.performDexOptSecondary(context);
            if (SharePatchFileUtil.isLegalFile(oatFile)) {
                return true;
            }
        }
        catch (Throwable thr) {
            ShareTinkerLog.printErrStackTrace(TAG, thr, "[-] Error.", new Object[0]);
        }
        try {
            TinkerDexOptimizer.performBgDexOptJob(context);
            if (SharePatchFileUtil.isLegalFile(oatFile)) {
                return true;
            }
        }
        catch (Throwable thr) {
            ShareTinkerLog.printErrStackTrace(TAG, thr, "[-] Error.", new Object[0]);
        }
        try {
            TinkerDexOptimizer.performDexOptSecondaryByTransactionCode(context);
            if (SharePatchFileUtil.isLegalFile(oatFile)) {
                return true;
            }
        }
        catch (Throwable thr) {
            ShareTinkerLog.printErrStackTrace(TAG, thr, "[-] Error.", new Object[0]);
        }
        if (waitForOAT) {
            return TinkerDexOptimizer.waitUntilFileGeneratedOrTimeout(context, oatFile.getAbsolutePath(), 3000L);
        }
        return SharePatchFileUtil.isLegalFile(oatFile);
    }

    private static void performDexOptSecondary(Context context) throws IllegalStateException {
        String[] args = new String[]{"compile", "-f", "--secondary-dex", "-m", ShareTinkerInternals.isNewerOrEqualThanVersion(31, true) ? "verify" : "speed-profile", context.getPackageName()};
        TinkerDexOptimizer.executePMSShellCommand(context, args);
    }

    private static void performBgDexOptJob(Context context) throws IllegalStateException {
        String[] args = new String[]{"bg-dexopt-job", context.getPackageName()};
        TinkerDexOptimizer.executePMSShellCommand(context, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performDexOptSecondaryByTransactionCode(Context context) throws IllegalStateException {
        int[] nArray = sPerformDexOptSecondaryTransactionCode;
        synchronized (sPerformDexOptSecondaryTransactionCode) {
            if (sPerformDexOptSecondaryTransactionCode[0] == -1) {
                try {
                    Method getDeclaredFieldMethod = ShareReflectUtil.findMethod(Class.class, "getDeclaredField", String.class);
                    getDeclaredFieldMethod.setAccessible(true);
                    Field cstField = (Field)getDeclaredFieldMethod.invoke(Class.forName("android.content.pm.IPackageManager$Stub"), "TRANSACTION_performDexOptSecondary");
                    cstField.setAccessible(true);
                    TinkerDexOptimizer.sPerformDexOptSecondaryTransactionCode[0] = (Integer)cstField.get(null);
                }
                catch (Throwable thr) {
                    throw new IllegalStateException("Cannot query transaction code of performDexOptSecondary.", thr);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            ShareTinkerLog.i(TAG, "[+] performDexOptSecondaryByTransactionCode, code: %s", sPerformDexOptSecondaryTransactionCode[0]);
            IBinder pmsBinder = TinkerDexOptimizer.getPMSBinderProxy(context);
            Parcel data = null;
            Parcel reply = null;
            try {
                boolean result;
                data = Parcel.obtain();
                reply = Parcel.obtain();
                try {
                    data.writeInterfaceToken(pmsBinder.getInterfaceDescriptor());
                    data.writeString(context.getPackageName());
                    String compileFilter = ShareTinkerInternals.isNewerOrEqualThanVersion(31, true) ? "verify" : "speed-profile";
                    data.writeString(compileFilter);
                    data.writeInt(1);
                    boolean status = pmsBinder.transact(sPerformDexOptSecondaryTransactionCode[0], data, reply, 0);
                    if (!status) {
                        throw new IllegalStateException("Binder transaction failure.");
                    }
                }
                catch (RemoteException e) {
                    throw new IllegalStateException(e);
                }
                try {
                    reply.readException();
                }
                catch (Throwable thr) {
                    throw new IllegalStateException(thr);
                }
                boolean bl = result = 0 != reply.readInt();
                if (!result) {
                    ShareTinkerLog.w(TAG, "[!] System API return false.", new Object[0]);
                }
            }
            finally {
                if (reply != null) {
                    reply.recycle();
                }
                if (data != null) {
                    data.recycle();
                }
            }
            return;
        }
    }

    private static IBinder getPMSBinderProxy(Context context) throws IllegalStateException {
        IBinder[] iBinderArray = sPMSBinderProxy;
        synchronized (sPMSBinderProxy) {
            IBinder cachedPMSBinderProxy = sPMSBinderProxy[0];
            if (cachedPMSBinderProxy != null && cachedPMSBinderProxy.isBinderAlive()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return cachedPMSBinderProxy;
            }
            try {
                Class<?> smClazz = Class.forName("android.os.ServiceManager");
                Method getServiceMethod = ShareReflectUtil.findMethod(smClazz, "getService", String.class);
                TinkerDexOptimizer.sPMSBinderProxy[0] = (IBinder)getServiceMethod.invoke(null, "package");
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return sPMSBinderProxy[0];
            }
            catch (Throwable thr) {
                if (thr instanceof InvocationTargetException) {
                    throw new IllegalStateException(((InvocationTargetException)thr).getTargetException());
                }
                throw new IllegalStateException(thr);
            }
        }
    }

    private static void executePMSShellCommand(Context context, String[] args) throws IllegalStateException {
        IBinder pmsBinderProxy = TinkerDexOptimizer.getPMSBinderProxy(context);
        Parcel data = null;
        Parcel reply = null;
        long lastIdentity = Binder.clearCallingIdentity();
        try {
            ShareTinkerLog.i(TAG, "[+] Execute shell cmd, args: %s", Arrays.toString(args));
            data = Parcel.obtain();
            reply = Parcel.obtain();
            data.writeFileDescriptor(FileDescriptor.in);
            data.writeFileDescriptor(FileDescriptor.out);
            data.writeFileDescriptor(FileDescriptor.err);
            data.writeStringArray(args);
            data.writeStrongBinder(null);
            sEmptyResultReceiver.writeToParcel(data, 0);
            pmsBinderProxy.transact(1598246212, data, reply, 0);
            reply.readException();
            ShareTinkerLog.i(TAG, "[+] Execute shell cmd done.", new Object[0]);
        }
        catch (Throwable thr) {
            throw new IllegalStateException("Failure on executing shell cmd.", thr);
        }
        finally {
            if (reply != null) {
                reply.recycle();
            }
            if (data != null) {
                data.recycle();
            }
            Binder.restoreCallingIdentity((long)lastIdentity);
        }
    }

    private static void registerDexModule(Context context, String dexPath) throws IllegalStateException {
        PackageManager synchronizedPM = TinkerDexOptimizer.getSynchronizedPackageManager(context);
        try {
            Class<?> dexModuleRegisterCallbackClazz = Class.forName("android.content.pm.PackageManager$DexModuleRegisterCallback");
            ShareReflectUtil.findMethod(synchronizedPM, "registerDexModule", String.class, dexModuleRegisterCallbackClazz).invoke((Object)synchronizedPM, dexPath, null);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.getTargetException());
        }
        catch (Throwable thr) {
            if (thr instanceof IllegalStateException) {
                throw (IllegalStateException)thr;
            }
            throw new IllegalStateException(thr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static final PackageManager getSynchronizedPackageManager(Context context) throws IllegalStateException {
        PackageManager[] packageManagerArray = sSynchronizedPMCache;
        // MONITORENTER : sSynchronizedPMCache
        try {
            PackageManager appPM;
            if (sSynchronizedPMCache[0] != null) {
                IBinder[] iBinderArray = sPMSBinderProxy;
                // MONITORENTER : sPMSBinderProxy
                if (sPMSBinderProxy[0] != null && sPMSBinderProxy[0].isBinderAlive()) {
                    // MONITOREXIT : iBinderArray
                    // MONITOREXIT : packageManagerArray
                    return sSynchronizedPMCache[0];
                }
                // MONITOREXIT : iBinderArray
            }
            final IBinder pmsBinderProxy = TinkerDexOptimizer.getPMSBinderProxy(context);
            IBinder syncPMSBinderProxy = (IBinder)Proxy.newProxyInstance(context.getClassLoader(), pmsBinderProxy.getClass().getInterfaces(), new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if ("transact".equals(method.getName())) {
                        args[3] = 0;
                    }
                    return method.invoke((Object)pmsBinderProxy, args);
                }
            });
            Class<?> pmsStubClazz = Class.forName("android.content.pm.IPackageManager$Stub");
            Object pmsStubProxy = ShareReflectUtil.findMethod(pmsStubClazz, "asInterface", IBinder.class).invoke(null, syncPMSBinderProxy);
            Class<?> appPMClazz = Class.forName("android.app.ApplicationPackageManager");
            Context contextImpl = context instanceof ContextWrapper ? ((ContextWrapper)context).getBaseContext() : context;
            Class<?> pmsItfClazz = Class.forName("android.content.pm.IPackageManager");
            TinkerDexOptimizer.sSynchronizedPMCache[0] = appPM = (PackageManager)ShareReflectUtil.findConstructor(appPMClazz, contextImpl.getClass(), pmsItfClazz).newInstance(contextImpl, pmsStubProxy);
            // MONITOREXIT : packageManagerArray
            return appPM;
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.getTargetException());
        }
        catch (Throwable thr) {
            if (!(thr instanceof IllegalStateException)) throw new IllegalStateException(thr);
            throw (IllegalStateException)thr;
        }
    }

    private static boolean waitUntilFileGeneratedOrTimeout(Context context, String filePath, Long ... timeOutSeq) {
        Long[] longArray;
        File file = new File(filePath);
        if (timeOutSeq != null && timeOutSeq.length > 0) {
            longArray = timeOutSeq;
        } else {
            Long[] longArray2 = new Long[6];
            longArray2[0] = 1000L;
            longArray2[1] = 2000L;
            longArray2[2] = 4000L;
            longArray2[3] = 8000L;
            longArray2[4] = 16000L;
            longArray = longArray2;
            longArray2[5] = 32000L;
        }
        Long[] delaySeq = longArray;
        int delaySeqIdx = 0;
        while (!SharePatchFileUtil.isLegalFile(file) && delaySeqIdx < delaySeq.length) {
            SystemClock.sleep((long)delaySeq[delaySeqIdx++]);
            ShareTinkerLog.w(TAG, "[!] File %s does not exist after waiting %s time(s), wait again.", filePath, delaySeqIdx);
        }
        if (SharePatchFileUtil.isLegalFile(file)) {
            ShareTinkerLog.i(TAG, "[+] File %s was found.", filePath);
            return true;
        }
        ShareTinkerLog.e(TAG, "[-] File %s does not exist after waiting for %s times.", filePath, delaySeq.length);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void interpretDex2Oat(String dexFilePath, String oatFilePath, String targetISA) throws Exception {
        File oatFile = new File(oatFilePath);
        if (!oatFile.exists()) {
            oatFile.getParentFile().mkdirs();
        }
        File lockFile = new File(oatFile.getParentFile(), INTERPRET_LOCK_FILE_NAME);
        ShareFileLockHelper fileLock = null;
        try {
            fileLock = ShareFileLockHelper.getFileLock(lockFile);
            ArrayList<String> commandAndParams = new ArrayList<String>();
            commandAndParams.add("dex2oat");
            if (Build.VERSION.SDK_INT >= 24) {
                commandAndParams.add("--runtime-arg");
                commandAndParams.add("-classpath");
                commandAndParams.add("--runtime-arg");
                commandAndParams.add("&");
            }
            commandAndParams.add("--dex-file=" + dexFilePath);
            commandAndParams.add("--oat-file=" + oatFilePath);
            commandAndParams.add("--instruction-set=" + targetISA);
            if (Build.VERSION.SDK_INT > 25) {
                commandAndParams.add("--compiler-filter=quicken");
            } else {
                commandAndParams.add("--compiler-filter=interpret-only");
            }
            ProcessBuilder pb = new ProcessBuilder(commandAndParams);
            pb.redirectErrorStream(true);
            Process dex2oatProcess = pb.start();
            StreamConsumer.consumeInputStream(dex2oatProcess.getInputStream());
            StreamConsumer.consumeInputStream(dex2oatProcess.getErrorStream());
            try {
                int ret = dex2oatProcess.waitFor();
                if (ret != 0) {
                    throw new IOException("dex2oat works unsuccessfully, exit code: " + ret);
                }
            }
            catch (InterruptedException e) {
                throw new IOException("dex2oat is interrupted, msg: " + e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            try {
                if (fileLock != null) {
                    fileLock.close();
                }
            }
            catch (IOException e) {
                ShareTinkerLog.w(TAG, "release interpret Lock error", e);
            }
            throw throwable;
        }
        try {
            if (fileLock != null) {
                fileLock.close();
            }
        }
        catch (IOException e) {
            ShareTinkerLog.w(TAG, "release interpret Lock error", e);
        }
    }

    private static class StreamConsumer {
        static final Executor STREAM_CONSUMER = Executors.newSingleThreadExecutor();

        private StreamConsumer() {
        }

        static void consumeInputStream(final InputStream is) {
            STREAM_CONSUMER.execute(new Runnable(){

                @Override
                public void run() {
                    if (is == null) {
                        return;
                    }
                    byte[] buffer = new byte[256];
                    try {
                        while (is.read(buffer) > 0) {
                        }
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        try {
                            is.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            });
        }
    }

    private static class OptimizeWorker {
        private static ClassLoader patchClassLoaderStrongRef = null;
        private final String targetISA;
        private final Context context;
        private final File dexFile;
        private final File optimizedDir;
        private final boolean useInterpretMode;
        private final boolean useDLC;
        private final boolean useEmergencyMode;
        private final ResultCallback callback;

        OptimizeWorker(Context context, File dexFile, File optimizedDir, boolean useInterpretMode, boolean useDLC, String targetISA, boolean useEmergencyMode, ResultCallback cb) {
            this.context = context;
            this.dexFile = dexFile;
            this.optimizedDir = optimizedDir;
            this.useInterpretMode = useInterpretMode;
            this.useDLC = useDLC;
            this.callback = cb;
            this.targetISA = targetISA;
            this.useEmergencyMode = useEmergencyMode;
        }

        boolean run() {
            try {
                File odexFile;
                if (!SharePatchFileUtil.isLegalFile(this.dexFile) && this.callback != null) {
                    this.callback.onFailed(this.dexFile, this.optimizedDir, new IOException("dex file " + this.dexFile.getAbsolutePath() + " is not exist!"));
                    return false;
                }
                if (this.callback != null) {
                    this.callback.onStart(this.dexFile, this.optimizedDir);
                }
                final String optimizedPath = SharePatchFileUtil.optimizedPathFor(this.dexFile, this.optimizedDir);
                if (!ShareTinkerInternals.isArkHotRuning()) {
                    if (this.useInterpretMode) {
                        TinkerDexOptimizer.interpretDex2Oat(this.dexFile.getAbsolutePath(), optimizedPath, this.targetISA);
                    } else if (TinkerApplication.getInstance().isUseInterpretModeOnSupported32BitSystem() && ShareTinkerInternals.isVersionInRange(21, 25, true) && ShareTinkerInternals.is32BitEnv()) {
                        try {
                            ShareTinkerLog.i(TinkerDexOptimizer.TAG, "dexopt with interpret mode on 32bit supported system was enabled.", new Object[0]);
                            TinkerDexOptimizer.interpretDex2Oat(this.dexFile.getAbsolutePath(), optimizedPath, this.targetISA);
                        }
                        catch (Throwable thr) {
                            ShareTinkerLog.printErrStackTrace(TinkerDexOptimizer.TAG, thr, "exception occurred on dexopt triggering.", new Object[0]);
                        }
                        if (!SharePatchFileUtil.isLegalFile(new File(optimizedPath))) {
                            ShareTinkerLog.w(TinkerDexOptimizer.TAG, "interpret dexopt failure, compensate with system method.", new Object[0]);
                            DexFile.loadDex((String)this.dexFile.getAbsolutePath(), (String)optimizedPath, (int)0);
                        }
                    } else if (ShareTinkerInternals.isNewerOrEqualThanVersion(26, true)) {
                        if (ShareTinkerInternals.isNewerOrEqualThanVersion(29, true)) {
                            TinkerDexOptimizer.createFakeODexPathStructureOnDemand(optimizedPath);
                            patchClassLoaderStrongRef = NewClassLoaderInjector.triggerDex2Oat(this.context, this.optimizedDir, this.useDLC, this.dexFile.getAbsolutePath());
                            Runnable task = new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        TinkerDexOptimizer.triggerPMDexOptOnDemand(context, dexFile.getAbsolutePath(), optimizedPath);
                                    }
                                    catch (Throwable thr) {
                                        ShareTinkerLog.printErrStackTrace(TinkerDexOptimizer.TAG, thr, "Fail to call triggerPMDexOptAsyncOnDemand.", new Object[0]);
                                    }
                                    finally {
                                        if (!useEmergencyMode) {
                                            String vdexPath = optimizedPath.substring(0, optimizedPath.lastIndexOf(".odex")) + ".vdex";
                                            TinkerDexOptimizer.waitUntilFileGeneratedOrTimeout(context, vdexPath, new Long[0]);
                                        }
                                    }
                                }
                            };
                            if (this.useEmergencyMode) {
                                new Thread(task, "TinkerDex2oatTrigger").start();
                            } else {
                                task.run();
                            }
                        } else {
                            patchClassLoaderStrongRef = NewClassLoaderInjector.triggerDex2Oat(this.context, this.optimizedDir, this.useDLC, this.dexFile.getAbsolutePath());
                        }
                    } else {
                        DexFile.loadDex((String)this.dexFile.getAbsolutePath(), (String)optimizedPath, (int)0);
                    }
                }
                if (SharePatchFileUtil.isLegalFile(odexFile = new File(optimizedPath)) || SharePatchFileUtil.shouldAcceptEvenIfIllegal(odexFile)) {
                    if (this.callback != null) {
                        this.callback.onSuccess(this.dexFile, this.optimizedDir, odexFile);
                    }
                    return true;
                }
                FileNotFoundException e = new FileNotFoundException("Odex file: " + odexFile.getAbsolutePath() + " does not exist.");
                if (this.callback != null) {
                    this.callback.onFailed(this.dexFile, this.optimizedDir, e);
                }
                return false;
            }
            catch (Throwable e) {
                ShareTinkerLog.e(TinkerDexOptimizer.TAG, "Failed to optimize dex: " + this.dexFile.getAbsolutePath(), e);
                if (this.callback != null) {
                    this.callback.onFailed(this.dexFile, this.optimizedDir, e);
                }
                return false;
            }
        }
    }

    public static interface ResultCallback {
        public void onStart(File var1, File var2);

        public void onSuccess(File var1, File var2, File var3);

        public void onFailed(File var1, File var2, Throwable var3);
    }
}

