/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.ratelimiter.reject;

import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.cache.FlowCache;
import com.tencent.polaris.api.plugin.ratelimiter.AmountInfo;
import com.tencent.polaris.api.plugin.ratelimiter.InitCriteria;
import com.tencent.polaris.api.plugin.ratelimiter.LocalQuotaInfo;
import com.tencent.polaris.api.plugin.ratelimiter.QuotaBucket;
import com.tencent.polaris.api.plugin.ratelimiter.QuotaResult;
import com.tencent.polaris.api.plugin.ratelimiter.RemoteQuotaInfo;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.ratelimiter.common.bucket.BucketShareInfo;
import com.tencent.polaris.plugins.ratelimiter.common.bucket.UpdateIdentifier;
import com.tencent.polaris.plugins.ratelimiter.common.slide.SlidingWindow;
import com.tencent.polaris.plugins.ratelimiter.reject.TokenBucket;
import com.tencent.polaris.specification.api.v1.traffic.manage.RateLimitProto;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class RemoteAwareBucket
implements QuotaBucket {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteAwareBucket.class);
    private final Map<Long, TokenBucket> tokenBucketMap = new HashMap<Long, TokenBucket>();
    private final List<TokenBucket> tokenBuckets = new ArrayList<TokenBucket>();
    private final FlowCache flowCache;

    public RemoteAwareBucket(InitCriteria initCriteria, FlowCache flowCache) {
        RateLimitProto.Rule rule = initCriteria.getRule();
        this.flowCache = flowCache;
        boolean shareEqual = rule.getAmountMode() == RateLimitProto.Rule.AmountMode.SHARE_EQUALLY;
        boolean local = rule.getType() == RateLimitProto.Rule.Type.LOCAL;
        boolean passOnRemoteFail = rule.getFailover() == RateLimitProto.Rule.FailoverType.FAILOVER_PASS;
        BucketShareInfo bucketShareInfo = new BucketShareInfo(shareEqual, local, passOnRemoteFail);
        long minDurationMs = 0L;
        for (int i = 0; i < rule.getAmountsCount(); ++i) {
            RateLimitProto.Amount amount = (RateLimitProto.Amount)rule.getAmountsList().get(i);
            long validDurationMs = amount.getValidDuration().getSeconds() * 1000L;
            if (minDurationMs == 0L || minDurationMs > validDurationMs) {
                minDurationMs = validDurationMs;
            }
            TokenBucket tokenBucket = new TokenBucket(initCriteria.getWindowKey(), validDurationMs, amount.getMaxAmount().getValue(), bucketShareInfo);
            this.tokenBuckets.add(tokenBucket);
            this.tokenBucketMap.put(validDurationMs, tokenBucket);
        }
        Collections.sort(this.tokenBuckets);
        bucketShareInfo.setMinDurationMs(minDurationMs);
    }

    public QuotaResult allocateQuota(long curTimeMs, int token) throws PolarisException {
        QuotaResult response;
        Object tokenBucket;
        int i;
        int stopIdx = -1;
        TokenBucket.TokenBucketMode mode = TokenBucket.TokenBucketMode.UNKNOWN;
        UpdateIdentifier[] identifiers = new UpdateIdentifier[this.tokenBuckets.size()];
        TokenBucket.AllocateResult[] results = new TokenBucket.AllocateResult[this.tokenBuckets.size()];
        for (i = 0; i < this.tokenBuckets.size(); ++i) {
            identifiers[i] = (UpdateIdentifier)this.flowCache.borrowThreadCacheObject(UpdateIdentifier.class);
            results[i] = (TokenBucket.AllocateResult)this.flowCache.borrowThreadCacheObject(TokenBucket.AllocateResult.class);
        }
        for (i = 0; i < this.tokenBuckets.size(); ++i) {
            tokenBucket = this.tokenBuckets.get(i);
            TokenBucket.AllocateResult allocateResult = ((TokenBucket)tokenBucket).tryAllocateToken(mode, token, curTimeMs, identifiers[i], results[i]);
            mode = allocateResult.getMode();
            if (allocateResult.getLeft() >= 0L) continue;
            stopIdx = i;
            break;
        }
        if (stopIdx >= 0) {
            tokenBucket = this.tokenBuckets.get(stopIdx);
            ((TokenBucket)tokenBucket).confirmLimited(token, curTimeMs);
            for (int i2 = 0; i2 < stopIdx; ++i2) {
                TokenBucket bucket = this.tokenBuckets.get(i2);
                bucket.giveBackToken(identifiers[i2], token, mode);
            }
            response = new QuotaResult(QuotaResult.Code.QuotaResultLimited, 0L, "");
        } else {
            for (TokenBucket tokenBucket2 : this.tokenBuckets) {
                tokenBucket2.confirmPassed(token, curTimeMs);
            }
            response = new QuotaResult(QuotaResult.Code.QuotaResultOk, 0L, "");
        }
        for (int i3 = 0; i3 < this.tokenBuckets.size(); ++i3) {
            this.flowCache.giveBackThreadCacheObject((Object)identifiers[i3]);
            this.flowCache.giveBackThreadCacheObject((Object)results[i3]);
        }
        return response;
    }

    public void release() {
    }

    public void onRemoteUpdate(RemoteQuotaInfo remoteQuotaInfo) {
        long localCurTimeMs = System.currentTimeMillis();
        long remoteCurTimeMs = remoteQuotaInfo.getCurTimeMs();
        long durationMs = remoteQuotaInfo.getDurationMs();
        long localCurStartMs = SlidingWindow.calculateStartTimeMs((long)localCurTimeMs, (long)durationMs);
        long remoteCurStartMs = SlidingWindow.calculateStartTimeMs((long)remoteCurTimeMs, (long)durationMs);
        TokenBucket tokenBucket = this.tokenBucketMap.get(durationMs);
        if (null == tokenBucket) {
            return;
        }
        LOG.debug("[RateLimit]reset remote quota, localTimeMilli {}(startMilli {}), remoteTimeMilli {}(startMilli {}), duration {}, remote quota left {}", new Object[]{localCurTimeMs, localCurStartMs, remoteCurTimeMs, remoteCurStartMs, durationMs, remoteQuotaInfo.getRemoteQuotaLeft()});
        if (remoteCurStartMs != localCurStartMs) {
            long remoteQuotaLeft = remoteQuotaInfo.getRemoteQuotaLeft();
            if (remoteCurStartMs + durationMs == localCurStartMs) {
                remoteQuotaInfo = new RemoteQuotaInfo(tokenBucket.getRuleTotal(), remoteQuotaInfo.getClientCount(), localCurStartMs, durationMs);
                LOG.debug("[RateLimit]reset remote quota, localTimeMilli {}(startMilli {}), remoteTimeMilli {}(startMilli {}), duration {}, remoteLeft is {}, reset to {}", new Object[]{localCurTimeMs, localCurStartMs, remoteCurTimeMs, remoteCurStartMs, durationMs, remoteQuotaLeft, remoteQuotaInfo.getRemoteQuotaLeft()});
            } else {
                tokenBucket.syncUpdateRemoteClientCount(remoteQuotaInfo);
                LOG.warn("[RateLimit]drop remote quota, localTimeMilli {}(startMilli {}), remoteTimeMilli {}(startMilli {}), duration {}, remoteLeft is {}", new Object[]{localCurTimeMs, localCurStartMs, remoteCurTimeMs, remoteCurStartMs, durationMs, remoteQuotaLeft});
                return;
            }
        }
        tokenBucket.syncUpdateRemoteToken(remoteQuotaInfo);
    }

    public Map<Integer, LocalQuotaInfo> fetchLocalUsage(long curTimeMs) {
        HashMap<Integer, LocalQuotaInfo> localInfos = new HashMap<Integer, LocalQuotaInfo>();
        for (Map.Entry<Long, TokenBucket> entry : this.tokenBucketMap.entrySet()) {
            TokenBucket tokenBucket = entry.getValue();
            SlidingWindow.Result result = tokenBucket.getSlidingWindow().acquireCurrentValues(curTimeMs);
            LocalQuotaInfo localQuotaInfo = new LocalQuotaInfo(result.getPassed(), result.getLimited());
            localInfos.put(tokenBucket.getValidDurationSecond(), localQuotaInfo);
        }
        return localInfos;
    }

    public Map<Integer, AmountInfo> getAmountInfo() {
        HashMap<Integer, AmountInfo> amountInfos = new HashMap<Integer, AmountInfo>();
        for (Map.Entry<Long, TokenBucket> entry : this.tokenBucketMap.entrySet()) {
            TokenBucket tokenBucket = entry.getValue();
            AmountInfo amountInfo = new AmountInfo();
            amountInfo.setMaxAmount(tokenBucket.getRuleTotal());
            amountInfos.put(tokenBucket.getValidDurationSecond(), amountInfo);
        }
        return amountInfos;
    }
}

