/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.stat.prometheus.exporter;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import javax.xml.bind.DatatypeConverter;
import shade.polaris.io.prometheus.client.CollectorRegistry;
import shade.polaris.io.prometheus.client.exporter.DefaultHttpConnectionFactory;
import shade.polaris.io.prometheus.client.exporter.HttpConnectionFactory;
import shade.polaris.io.prometheus.client.exporter.common.TextFormat;

public class PushGateway
extends shade.polaris.io.prometheus.client.exporter.PushGateway {
    private static final int MILLISECONDS_PER_SECOND = 1000;
    private HttpConnectionFactory connectionFactory = new DefaultHttpConnectionFactory();

    public PushGateway(String address) {
        super(address);
    }

    public PushGateway(URL serverBaseURL) {
        super(serverBaseURL);
    }

    @Override
    public void setConnectionFactory(HttpConnectionFactory connectionFactory) {
        super.setConnectionFactory(connectionFactory);
        this.connectionFactory = connectionFactory;
    }

    public void pushAddByGzip(CollectorRegistry registry, String job, Map<String, String> groupingKey) throws IOException {
        this.doRequestByGzip(registry, job, groupingKey, "POST");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doRequestByGzip(CollectorRegistry registry, String job, Map<String, String> groupingKey, String method) throws IOException {
        String url = this.gatewayBaseURL;
        url = job.contains("/") ? url + "job@base64/" + PushGateway.base64url(job) : url + "job/" + URLEncoder.encode(job, "UTF-8");
        if (groupingKey != null) {
            for (Map.Entry<String, String> entry : groupingKey.entrySet()) {
                if (entry.getValue().isEmpty()) {
                    url = url + "/" + entry.getKey() + "@base64/=";
                    continue;
                }
                if (entry.getValue().contains("/")) {
                    url = url + "/" + entry.getKey() + "@base64/" + PushGateway.base64url(entry.getValue());
                    continue;
                }
                url = url + "/" + entry.getKey() + "/" + URLEncoder.encode(entry.getValue(), "UTF-8");
            }
        }
        HttpURLConnection connection = this.connectionFactory.create(url);
        connection.setRequestProperty("Content-Type", "text/plain; version=0.0.4; charset=utf-8");
        connection.setRequestProperty("Content-Encoding", "gzip");
        if (!method.equals("DELETE")) {
            connection.setDoOutput(true);
        }
        connection.setRequestMethod(method);
        connection.setConnectTimeout(10000);
        connection.setReadTimeout(10000);
        connection.connect();
        try {
            int response;
            if (!method.equals("DELETE")) {
                ByteArrayOutputStream outputStream2 = new ByteArrayOutputStream();
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream2, "UTF-8"));
                TextFormat.write004(writer, registry.metricFamilySamples());
                writer.flush();
                writer.close();
                GZIPOutputStream zipStream = new GZIPOutputStream(connection.getOutputStream());
                zipStream.write(outputStream2.toByteArray());
                zipStream.finish();
                zipStream.flush();
                zipStream.close();
            }
            if ((response = connection.getResponseCode()) / 100 != 2) {
                String errorMessage;
                InputStream errorStream = connection.getErrorStream();
                if (errorStream != null) {
                    String errBody = PushGateway.readFromStream(errorStream);
                    errorMessage = "Response code from " + url + " was " + response + ", response body: " + errBody;
                } else {
                    errorMessage = "Response code from " + url + " was " + response;
                }
                throw new IOException(errorMessage);
            }
        }
        finally {
            connection.disconnect();
        }
    }

    private static String base64url(String v) {
        try {
            return DatatypeConverter.printBase64Binary(v.getBytes("UTF-8")).replace("+", "-").replace("/", "_");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String readFromStream(InputStream is) throws IOException {
        int length;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = is.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toString("UTF-8");
    }

    private static class LocalByteArray
    extends ThreadLocal<ByteArrayOutputStream> {
        private LocalByteArray() {
        }

        @Override
        protected ByteArrayOutputStream initialValue() {
            return new ByteArrayOutputStream(0x100000);
        }
    }
}

