/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.loadbalancer.ringhash;

import com.tencent.polaris.plugins.loadbalancer.ringhash.HashStrategy;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class MurmurHash
implements HashStrategy {
    @Override
    public int getHashCode(String origin) {
        ByteBuffer buf = ByteBuffer.wrap(origin.getBytes());
        int seed = 305441741;
        buf.order(ByteOrder.LITTLE_ENDIAN);
        long m = -4132994306676758123L;
        int r = 47;
        long h = (long)seed ^ (long)buf.remaining() * m;
        while (buf.remaining() >= 8) {
            long k = buf.getLong();
            k *= m;
            k ^= k >>> r;
            h ^= (k *= m);
            h *= m;
        }
        if (buf.remaining() > 0) {
            ByteBuffer finish = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
            finish.put(buf).rewind();
            h ^= finish.getLong();
            h *= m;
        }
        h ^= h >>> r;
        h *= m;
        h ^= h >>> r;
        ByteOrder byteOrder = buf.order();
        buf.order(byteOrder);
        return (int)(h & 0xFFFFFFFFL);
    }
}

