/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.configuration.client.internal;

import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.configuration.api.core.ConfigFile;
import com.tencent.polaris.configuration.api.core.ConfigFileFormat;
import com.tencent.polaris.configuration.api.core.ConfigFileMetadata;
import com.tencent.polaris.configuration.api.core.ConfigKVFile;
import com.tencent.polaris.configuration.client.factory.ConfigFileFactory;
import com.tencent.polaris.configuration.client.factory.ConfigFileFactoryManager;
import com.tencent.polaris.configuration.client.factory.ConfigFilePublishFactory;
import com.tencent.polaris.configuration.client.factory.DefaultConfigFileFactoryManager;
import com.tencent.polaris.configuration.client.internal.ConfigFileManager;
import java.util.Map;
import shade.polaris.com.google.common.collect.Maps;

public class DefaultConfigFileManager
implements ConfigFileManager {
    private static DefaultConfigFileManager instance;
    private ConfigFileFactoryManager configFileFactoryManager;
    private final Map<ConfigFileMetadata, ConfigFile> configFileCache = Maps.newConcurrentMap();
    private final Map<ConfigFileMetadata, ConfigKVFile> configPropertiesFileCache = Maps.newConcurrentMap();

    private DefaultConfigFileManager(SDKContext sdkContext) {
        this.configFileFactoryManager = DefaultConfigFileFactoryManager.getInstance(sdkContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultConfigFileManager getInstance(SDKContext sdkContext) {
        if (instance != null) return instance;
        Class<DefaultConfigFileManager> clazz = DefaultConfigFileManager.class;
        synchronized (DefaultConfigFileManager.class) {
            if (instance != null) return instance;
            instance = new DefaultConfigFileManager(sdkContext);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigFile getConfigFile(ConfigFileMetadata configFileMetadata) {
        ConfigFile configFile = this.configFileCache.get(configFileMetadata);
        if (configFile == null) {
            DefaultConfigFileManager defaultConfigFileManager = this;
            synchronized (defaultConfigFileManager) {
                configFile = this.configFileCache.get(configFileMetadata);
                if (configFile == null) {
                    ConfigFileFactory configFileFactory = this.configFileFactoryManager.getConfigFileFactory(configFileMetadata);
                    configFile = configFileFactory.createConfigFile(configFileMetadata);
                    this.configFileCache.put(configFileMetadata, configFile);
                }
            }
        }
        return configFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigKVFile getConfigKVFile(ConfigFileMetadata configFileMetadata, ConfigFileFormat fileFormat) {
        ConfigKVFile configFile = this.configPropertiesFileCache.get(configFileMetadata);
        if (configFile == null) {
            DefaultConfigFileManager defaultConfigFileManager = this;
            synchronized (defaultConfigFileManager) {
                configFile = this.configPropertiesFileCache.get(configFileMetadata);
                if (configFile == null) {
                    ConfigFileFactory configFileFactory = this.configFileFactoryManager.getConfigFileFactory(configFileMetadata);
                    configFile = configFileFactory.createConfigKVFile(configFileMetadata, fileFormat);
                    this.configPropertiesFileCache.put(configFileMetadata, configFile);
                }
            }
        }
        return configFile;
    }

    @Override
    public void createConfigFile(ConfigFileMetadata configFileMetadata, String content) {
        ConfigFilePublishFactory configFilePublishFactory = this.configFileFactoryManager.getConfigFilePublishFactory(configFileMetadata);
        configFilePublishFactory.createConfigFile(configFileMetadata, content);
    }

    @Override
    public void updateConfigFile(ConfigFileMetadata configFileMetadata, String content) {
        ConfigFilePublishFactory configFilePublishFactory = this.configFileFactoryManager.getConfigFilePublishFactory(configFileMetadata);
        configFilePublishFactory.updateConfigFile(configFileMetadata, content);
    }

    @Override
    public void releaseConfigFile(ConfigFileMetadata configFileMetadata) {
        ConfigFilePublishFactory configFilePublishFactory = this.configFileFactoryManager.getConfigFilePublishFactory(configFileMetadata);
        configFilePublishFactory.releaseConfigFile(configFileMetadata);
    }

    void setConfigFileFactoryManager(ConfigFileFactoryManager configFileFactoryManager) {
        this.configFileFactoryManager = configFileFactoryManager;
    }
}

