/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.configuration.client.factory;

import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.configuration.ConfigFile;
import com.tencent.polaris.api.plugin.configuration.ConfigFileConnector;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.configuration.api.core.ConfigFileMetadata;
import com.tencent.polaris.configuration.client.factory.ConfigFilePublishFactory;
import com.tencent.polaris.configuration.client.factory.DefaultConfigFileFactory;

public class DefaultConfigFilePublishFactory
implements ConfigFilePublishFactory {
    private static DefaultConfigFilePublishFactory instance;
    private final SDKContext sdkContext;
    private final ConfigFileConnector configFileConnector;

    public DefaultConfigFilePublishFactory(SDKContext sdkContext) {
        this.sdkContext = sdkContext;
        String configFileConnectorType = sdkContext.getConfig().getConfigFile().getServerConnector().getConnectorType();
        this.configFileConnector = (ConfigFileConnector)sdkContext.getExtensions().getPlugins().getPlugin(PluginTypes.CONFIG_FILE_CONNECTOR.getBaseType(), configFileConnectorType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultConfigFilePublishFactory getInstance(SDKContext sdkContext) {
        if (instance != null) return instance;
        Class<DefaultConfigFileFactory> clazz = DefaultConfigFileFactory.class;
        synchronized (DefaultConfigFileFactory.class) {
            if (instance != null) return instance;
            instance = new DefaultConfigFilePublishFactory(sdkContext);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void createConfigFile(ConfigFileMetadata configFileMetadata, String content) {
        ConfigFile configFile = new ConfigFile(configFileMetadata.getNamespace(), configFileMetadata.getFileGroup(), configFileMetadata.getFileName());
        configFile.setContent(content);
        this.configFileConnector.createConfigFile(configFile);
    }

    @Override
    public void updateConfigFile(ConfigFileMetadata configFileMetadata, String content) {
        ConfigFile configFile = new ConfigFile(configFileMetadata.getNamespace(), configFileMetadata.getFileGroup(), configFileMetadata.getFileName());
        configFile.setContent(content);
        this.configFileConnector.updateConfigFile(configFile);
    }

    @Override
    public void releaseConfigFile(ConfigFileMetadata configFileMetadata) {
        ConfigFile configFile = new ConfigFile(configFileMetadata.getNamespace(), configFileMetadata.getFileGroup(), configFileMetadata.getFileName());
        this.configFileConnector.releaseConfigFile(configFile);
    }
}

