/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.configuration.client.factory;

import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.configuration.ConfigFileConnector;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.configuration.api.core.ConfigFile;
import com.tencent.polaris.configuration.api.core.ConfigFileFormat;
import com.tencent.polaris.configuration.api.core.ConfigFileMetadata;
import com.tencent.polaris.configuration.api.core.ConfigKVFile;
import com.tencent.polaris.configuration.client.factory.ConfigFileFactory;
import com.tencent.polaris.configuration.client.internal.ConfigFileLongPollingService;
import com.tencent.polaris.configuration.client.internal.ConfigFileRepo;
import com.tencent.polaris.configuration.client.internal.ConfigPropertiesFile;
import com.tencent.polaris.configuration.client.internal.ConfigYamlFile;
import com.tencent.polaris.configuration.client.internal.DefaultConfigFile;
import com.tencent.polaris.configuration.client.internal.DefaultConfigFileLongPollingService;
import com.tencent.polaris.configuration.client.internal.RemoteConfigFileRepo;

public class DefaultConfigFileFactory
implements ConfigFileFactory {
    private static DefaultConfigFileFactory instance;
    private final SDKContext sdkContext;
    private final ConfigFileConnector configFileConnector;
    private final ConfigFileLongPollingService configFileLongPollingService;

    private DefaultConfigFileFactory(SDKContext sdkContext) {
        this.sdkContext = sdkContext;
        this.configFileLongPollingService = DefaultConfigFileLongPollingService.getInstance(sdkContext);
        String configFileConnectorType = sdkContext.getConfig().getConfigFile().getServerConnector().getConnectorType();
        this.configFileConnector = (ConfigFileConnector)sdkContext.getExtensions().getPlugins().getPlugin(PluginTypes.CONFIG_FILE_CONNECTOR.getBaseType(), configFileConnectorType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultConfigFileFactory getInstance(SDKContext sdkContext) {
        if (instance != null) return instance;
        Class<DefaultConfigFileFactory> clazz = DefaultConfigFileFactory.class;
        synchronized (DefaultConfigFileFactory.class) {
            if (instance != null) return instance;
            instance = new DefaultConfigFileFactory(sdkContext);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public ConfigFile createConfigFile(ConfigFileMetadata configFileMetadata) {
        ConfigFileRepo configFileRepo = this.createConfigFileRepo(configFileMetadata);
        return new DefaultConfigFile(configFileMetadata.getNamespace(), configFileMetadata.getFileGroup(), configFileMetadata.getFileName(), configFileRepo, this.sdkContext.getConfig().getConfigFile());
    }

    @Override
    public ConfigKVFile createConfigKVFile(ConfigFileMetadata configFileMetadata, ConfigFileFormat format) {
        ConfigFileRepo configFileRepo = this.createConfigFileRepo(configFileMetadata);
        switch (format) {
            case Properties: {
                return new ConfigPropertiesFile(configFileMetadata.getNamespace(), configFileMetadata.getFileGroup(), configFileMetadata.getFileName(), configFileRepo, this.sdkContext.getConfig().getConfigFile());
            }
            case Yaml: {
                return new ConfigYamlFile(configFileMetadata.getNamespace(), configFileMetadata.getFileGroup(), configFileMetadata.getFileName(), configFileRepo, this.sdkContext.getConfig().getConfigFile());
            }
        }
        throw new IllegalArgumentException("KV file only support properties and yaml file.");
    }

    private ConfigFileRepo createConfigFileRepo(ConfigFileMetadata configFileMetadata) {
        return new RemoteConfigFileRepo(this.sdkContext, this.configFileLongPollingService, null, configFileMetadata);
    }
}

