/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.utils;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.taosdata.jdbc.enums.TimestampPrecision;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Utils {
    private static Pattern ptn = Pattern.compile(".*?'");
    private static final DateTimeFormatter milliSecFormatter = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss.SSS").toFormatter();
    private static final DateTimeFormatter microSecFormatter = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss.SSSSSS").toFormatter();
    private static final DateTimeFormatter nanoSecFormatter = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss.SSSSSSSSS").toFormatter();

    public static Time parseTime(String timestampStr) throws DateTimeParseException {
        LocalDateTime dateTime = Utils.parseLocalDateTime(timestampStr);
        return dateTime != null ? Time.valueOf(dateTime.toLocalTime()) : null;
    }

    public static Date parseDate(String timestampStr) {
        LocalDateTime dateTime = Utils.parseLocalDateTime(timestampStr);
        return dateTime != null ? Date.valueOf(String.valueOf(dateTime)) : null;
    }

    public static Timestamp parseTimestamp(String timeStampStr) {
        LocalDateTime dateTime = Utils.parseLocalDateTime(timeStampStr);
        return dateTime != null ? Timestamp.valueOf(dateTime) : null;
    }

    private static LocalDateTime parseLocalDateTime(String timeStampStr) {
        try {
            return Utils.parseMilliSecTimestamp(timeStampStr);
        }
        catch (DateTimeParseException e) {
            try {
                return Utils.parseMicroSecTimestamp(timeStampStr);
            }
            catch (DateTimeParseException ee) {
                try {
                    return Utils.parseNanoSecTimestamp(timeStampStr);
                }
                catch (DateTimeParseException eee) {
                    eee.printStackTrace();
                    return null;
                }
            }
        }
    }

    private static LocalDateTime parseMilliSecTimestamp(String timeStampStr) throws DateTimeParseException {
        return LocalDateTime.parse(timeStampStr, milliSecFormatter);
    }

    private static LocalDateTime parseMicroSecTimestamp(String timeStampStr) throws DateTimeParseException {
        return LocalDateTime.parse(timeStampStr, microSecFormatter);
    }

    private static LocalDateTime parseNanoSecTimestamp(String timeStampStr) throws DateTimeParseException {
        return LocalDateTime.parse(timeStampStr, nanoSecFormatter);
    }

    public static String escapeSingleQuota(String origin) {
        Matcher m = ptn.matcher(origin);
        StringBuffer sb = new StringBuffer();
        int end = 0;
        while (m.find()) {
            end = m.end();
            String seg = origin.substring(m.start(), end);
            int len = seg.length();
            if (len == 1) {
                if ('\'' == seg.charAt(0)) {
                    sb.append("\\'");
                    continue;
                }
                sb.append(seg);
                continue;
            }
            sb.append(seg.substring(0, seg.length() - 2));
            char lastcSec = seg.charAt(seg.length() - 2);
            if (lastcSec == '\\') {
                sb.append("\\'");
                continue;
            }
            sb.append(lastcSec);
            sb.append("\\'");
        }
        if (end < origin.length()) {
            sb.append(origin.substring(end));
        }
        return sb.toString();
    }

    public static String getNativeSql(String rawSql, Object[] parameters) {
        if (parameters == null || !rawSql.contains("?")) {
            return rawSql;
        }
        String preparedSql = rawSql.trim().toLowerCase();
        String[] clause = new String[]{"values\\s*\\(.*?\\)", "tags\\s*\\(.*?\\)", "where\\s*.*"};
        HashMap<Integer, Integer> placeholderPositions = new HashMap<Integer, Integer>();
        TreeRangeSet clauseRangeSet = TreeRangeSet.create();
        Utils.findPlaceholderPosition(preparedSql, placeholderPositions);
        Utils.findClauseRangeSet(preparedSql, clause, (RangeSet<Integer>)clauseRangeSet);
        return Utils.transformSql(rawSql, parameters, placeholderPositions, (RangeSet<Integer>)clauseRangeSet);
    }

    private static void findClauseRangeSet(String preparedSql, String[] regexArr, RangeSet<Integer> clauseRangeSet) {
        clauseRangeSet.clear();
        for (String regex : regexArr) {
            Matcher matcher = Pattern.compile(regex).matcher(preparedSql);
            while (matcher.find()) {
                int start = matcher.start();
                int end = matcher.end();
                clauseRangeSet.add(Range.closed((Comparable)Integer.valueOf(start), (Comparable)Integer.valueOf(end)));
            }
        }
    }

    private static void findPlaceholderPosition(String preparedSql, Map<Integer, Integer> placeholderPosition) {
        placeholderPosition.clear();
        Matcher matcher = Pattern.compile("\\?").matcher(preparedSql);
        int index = 0;
        while (matcher.find()) {
            int pos = matcher.start();
            placeholderPosition.put(index, pos);
            ++index;
        }
    }

    private static String transformSql(String rawSql, Object[] paramArr, Map<Integer, Integer> placeholderPosition, RangeSet<Integer> clauseRangeSet) {
        String[] sqlArr = rawSql.split("\\?");
        return IntStream.range(0, sqlArr.length).mapToObj(index -> {
            String paraStr;
            if (index == paramArr.length) {
                return sqlArr[index];
            }
            Object para = paramArr[index];
            if (para != null) {
                paraStr = para instanceof byte[] ? new String((byte[])para, StandardCharsets.UTF_8) : para.toString();
                if (para instanceof Timestamp || para instanceof String || para instanceof byte[]) {
                    paraStr = Utils.escapeSingleQuota(paraStr);
                    Integer pos = (Integer)placeholderPosition.get(index);
                    boolean contains = clauseRangeSet.contains((Comparable)pos);
                    if (contains) {
                        paraStr = "'" + paraStr + "'";
                    }
                }
            } else {
                paraStr = "NULL";
            }
            return sqlArr[index] + paraStr;
        }).collect(Collectors.joining());
    }

    public static String formatTimestamp(Timestamp timestamp) {
        int nanos = timestamp.getNanos();
        if ((long)nanos % 1000000L != 0L) {
            return timestamp.toLocalDateTime().format(microSecFormatter);
        }
        return timestamp.toLocalDateTime().format(milliSecFormatter);
    }

    public static TimestampPrecision guessTimestampPrecision(String value) {
        if (Utils.isMilliSecFormat(value)) {
            return TimestampPrecision.MS;
        }
        if (Utils.isMicroSecFormat(value)) {
            return TimestampPrecision.US;
        }
        if (Utils.isNanoSecFormat(value)) {
            return TimestampPrecision.NS;
        }
        return TimestampPrecision.UNKNOWN;
    }

    private static boolean isMilliSecFormat(String timestampStr) {
        try {
            milliSecFormatter.parse(timestampStr);
        }
        catch (DateTimeParseException e) {
            return false;
        }
        return true;
    }

    private static boolean isMicroSecFormat(String timestampStr) {
        try {
            microSecFormatter.parse(timestampStr);
        }
        catch (DateTimeParseException e) {
            return false;
        }
        return true;
    }

    private static boolean isNanoSecFormat(String timestampStr) {
        try {
            nanoSecFormatter.parse(timestampStr);
        }
        catch (DateTimeParseException e) {
            return false;
        }
        return true;
    }
}

