/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.utils;

public class SqlSyntaxValidator {
    private static final String[] SQL = new String[]{"select", "insert", "import", "create", "use", "alter", "drop", "set", "show", "describe"};
    private static final String[] updateSQL = new String[]{"insert", "import", "create", "use", "alter", "drop", "set"};
    private static final String[] querySQL = new String[]{"select", "show", "describe"};
    private static final String[] databaseUnspecifiedShow = new String[]{"databases", "dnodes", "mnodes", "variables"};

    public static boolean isValidForExecuteUpdate(String sql) {
        for (String prefix : updateSQL) {
            if (!sql.trim().toLowerCase().startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidForExecuteQuery(String sql) {
        for (String prefix : querySQL) {
            if (!sql.trim().toLowerCase().startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidForExecute(String sql) {
        for (String prefix : SQL) {
            if (!sql.trim().toLowerCase().startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDatabaseUnspecifiedQuery(String sql) {
        for (String databaseObj : databaseUnspecifiedShow) {
            if (!sql.trim().toLowerCase().matches("show\\s+" + databaseObj + ".*")) continue;
            return true;
        }
        return false;
    }

    public static boolean isDatabaseUnspecifiedUpdate(String sql) {
        return (sql = sql.trim().toLowerCase()).matches("create\\s+database.*") || sql.startsWith("set") || sql.matches("drop\\s+database.*");
    }

    public static boolean isUseSql(String sql) {
        return sql.trim().toLowerCase().startsWith("use");
    }

    public static boolean isShowSql(String sql) {
        return sql.trim().toLowerCase().startsWith("show");
    }

    public static boolean isDescribeSql(String sql) {
        return sql.trim().toLowerCase().startsWith("describe");
    }

    public static boolean isInsertSql(String sql) {
        return sql.trim().toLowerCase().startsWith("insert") || sql.trim().toLowerCase().startsWith("import");
    }

    public static boolean isSelectSql(String sql) {
        return sql.trim().toLowerCase().startsWith("select");
    }

    public static boolean isShowDatabaseSql(String sql) {
        return sql.trim().toLowerCase().matches("show\\s*databases");
    }
}

