/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.utils;

import java.nio.charset.StandardCharsets;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class HttpClientPoolUtil {
    private static final String DEFAULT_CONTENT_TYPE = "application/json";
    private static final int DEFAULT_TIME_OUT = 15000;
    private static final int DEFAULT_MAX_PER_ROUTE = 32;
    private static final int DEFAULT_MAX_TOTAL = 1000;
    private static final int DEFAULT_HTTP_KEEP_TIME = 15000;
    private static CloseableHttpClient httpClient;
    private static final ConnectionKeepAliveStrategy DEFAULT_KEEP_ALIVE_STRATEGY;

    private static synchronized void initPools() {
        if (httpClient == null) {
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
            connectionManager.setDefaultMaxPerRoute(32);
            connectionManager.setMaxTotal(1000);
            httpClient = HttpClients.custom().setKeepAliveStrategy(DEFAULT_KEEP_ALIVE_STRATEGY).setConnectionManager((HttpClientConnectionManager)connectionManager).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String execute(String uri, String data, String token) {
        long startTime = System.currentTimeMillis();
        HttpEntity httpEntity = null;
        HttpEntityEnclosingRequestBase method = null;
        String responseBody = "";
        try {
            if (httpClient == null) {
                HttpClientPoolUtil.initPools();
            }
            method = (HttpEntityEnclosingRequestBase)HttpClientPoolUtil.getRequest(uri, "POST", DEFAULT_CONTENT_TYPE, 0);
            method.setHeader("Content-Type", "text/plain");
            method.setHeader("Connection", "keep-alive");
            method.setHeader("Authorization", "Taosd " + token);
            method.setEntity((HttpEntity)new StringEntity(data, StandardCharsets.UTF_8));
            HttpClientContext context = HttpClientContext.create();
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)method, (HttpContext)context);
            httpEntity = httpResponse.getEntity();
            if (httpEntity != null) {
                responseBody = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
            }
            if (httpEntity == null) return responseBody;
        }
        catch (Exception e) {
            if (method != null) {
                method.abort();
            }
            new Exception("execute post request exception, url:" + uri + ", exception:" + e.toString() + ", cost time(ms):" + (System.currentTimeMillis() - startTime)).printStackTrace();
            return responseBody;
        }
        try {
            EntityUtils.consumeQuietly((HttpEntity)httpEntity);
            return responseBody;
        }
        catch (Exception e) {
            new Exception("close response exception, url:" + uri + ", exception:" + e.toString() + ", cost time(ms):" + (System.currentTimeMillis() - startTime)).printStackTrace();
            return responseBody;
        }
        finally {
            if (httpEntity != null) {
                try {
                    EntityUtils.consumeQuietly(httpEntity);
                }
                catch (Exception e) {
                    new Exception("close response exception, url:" + uri + ", exception:" + e.toString() + ", cost time(ms):" + (System.currentTimeMillis() - startTime)).printStackTrace();
                }
            }
        }
    }

    private static HttpRequestBase getRequest(String uri, String methodName, String contentType, int timeout) {
        if (httpClient == null) {
            HttpClientPoolUtil.initPools();
        }
        if (timeout <= 0) {
            timeout = 15000;
        }
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(timeout * 1000).setConnectTimeout(timeout * 1000).setConnectionRequestTimeout(timeout * 1000).setExpectContinueEnabled(false).build();
        Object method = "PUT".equalsIgnoreCase(methodName) ? new HttpPut(uri) : ("POST".equalsIgnoreCase(methodName) ? new HttpPost(uri) : ("GET".equalsIgnoreCase(methodName) ? new HttpGet(uri) : new HttpPost(uri)));
        if (contentType == null || contentType.isEmpty() || contentType.replaceAll("\\s", "").isEmpty()) {
            contentType = DEFAULT_CONTENT_TYPE;
        }
        method.addHeader("Content-Type", contentType);
        method.addHeader("Accept", contentType);
        method.setConfig(requestConfig);
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String execute(String uri) {
        long startTime = System.currentTimeMillis();
        HttpEntity httpEntity = null;
        HttpRequestBase method = null;
        String responseBody = "";
        try {
            HttpClientContext context;
            CloseableHttpResponse httpResponse;
            if (httpClient == null) {
                HttpClientPoolUtil.initPools();
            }
            if ((httpEntity = (httpResponse = httpClient.execute((HttpUriRequest)(method = HttpClientPoolUtil.getRequest(uri, "GET", DEFAULT_CONTENT_TYPE, 0)), (HttpContext)(context = HttpClientContext.create()))).getEntity()) != null) {
                responseBody = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
            }
            if (httpEntity == null) return responseBody;
        }
        catch (Exception e) {
            if (method != null) {
                method.abort();
            }
            e.printStackTrace();
            return responseBody;
        }
        try {
            EntityUtils.consumeQuietly((HttpEntity)httpEntity);
            return responseBody;
        }
        catch (Exception e) {
            new Exception("close response exception, url:" + uri + ", exception:" + e.toString() + ",cost time(ms):" + (System.currentTimeMillis() - startTime)).printStackTrace();
            return responseBody;
        }
        finally {
            if (httpEntity != null) {
                try {
                    EntityUtils.consumeQuietly(httpEntity);
                }
                catch (Exception e) {
                    new Exception("close response exception, url:" + uri + ", exception:" + e.toString() + ",cost time(ms):" + (System.currentTimeMillis() - startTime)).printStackTrace();
                }
            }
        }
    }

    static {
        DEFAULT_KEEP_ALIVE_STRATEGY = (response, context) -> {
            BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
            int keepTime = 15000000;
            while (it.hasNext()) {
                HeaderElement headerElement = it.nextElement();
                String param = headerElement.getName();
                String value = headerElement.getValue();
                if (value == null || !param.equalsIgnoreCase("timeout")) continue;
                try {
                    return Long.parseLong(value) * 1000L;
                }
                catch (Exception e) {
                    new Exception("format KeepAlive timeout exception, exception:" + e.toString()).printStackTrace();
                }
            }
            return keepTime;
        };
    }
}

