/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.multipart;

import com.sun.jersey.multipart.BodyPart;
import com.sun.jersey.multipart.FormDataBodyPart;
import com.sun.jersey.multipart.MultiPart;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.MediaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormDataMultiPart
extends MultiPart {
    public FormDataMultiPart() {
        super(MediaType.MULTIPART_FORM_DATA_TYPE);
    }

    public FormDataMultiPart field(String name, String value) {
        this.getBodyParts().add(new FormDataBodyPart(name, value));
        return this;
    }

    public FormDataMultiPart field(String name, Object entity, MediaType mediaType) {
        this.getBodyParts().add(new FormDataBodyPart(name, entity, mediaType));
        return this;
    }

    public FormDataBodyPart getField(String name) {
        FormDataBodyPart result = null;
        for (BodyPart bodyPart : this.getBodyParts()) {
            if (!(bodyPart instanceof FormDataBodyPart) || !name.equals(((FormDataBodyPart)bodyPart).getName())) continue;
            result = (FormDataBodyPart)bodyPart;
        }
        return result;
    }

    public Map<String, FormDataBodyPart> getFields() {
        HashMap<String, FormDataBodyPart> map = new HashMap<String, FormDataBodyPart>();
        for (BodyPart bodyPart : this.getBodyParts()) {
            if (!(bodyPart instanceof FormDataBodyPart)) continue;
            map.put(((FormDataBodyPart)bodyPart).getName(), (FormDataBodyPart)bodyPart);
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    public void setMediaType(MediaType mediaType) {
        if (!"multipart".equals(mediaType.getType()) || !"form-data".equals(mediaType.getSubtype())) {
            throw new IllegalArgumentException("Cannot change media type of a FormDataMultiPart instance");
        }
        super.setMediaType(mediaType);
    }
}

