/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.Attribute;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.NavigationCase;
import javax.faces.application.NavigationHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutcomeTarget;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OutcomeTargetRenderer
extends HtmlBasicRenderer {
    @Override
    public void decode(FacesContext context, UIComponent component) {
    }

    protected void renderPassThruAttributes(FacesContext ctx, ResponseWriter writer, UIComponent component, Attribute[] attributes, List excludedAttributes) throws IOException {
        RenderKitUtils.renderPassThruAttributes(ctx, writer, component, attributes);
        RenderKitUtils.renderXHTMLStyleBooleanAttributes(writer, component, excludedAttributes);
    }

    protected String getLabel(UIComponent component) {
        Object value = ((UIOutcomeTarget)component).getValue();
        return value != null ? value.toString() : "";
    }

    protected String getFragment(UIComponent component) {
        String fragment = (String)component.getAttributes().get("fragment");
        String string = fragment = fragment != null ? fragment.trim() : "";
        if (fragment.length() > 0) {
            fragment = "#" + fragment;
        }
        return fragment;
    }

    @Override
    protected Object getValue(UIComponent component) {
        return ((UIOutcomeTarget)component).getValue();
    }

    protected boolean isIncludeViewParams(UIComponent component, NavigationCase navcase) {
        return ((UIOutcomeTarget)component).isIncludeViewParams() || navcase.isIncludeViewParams();
    }

    protected NavigationCase getNavigationCase(FacesContext context, UIComponent component) {
        NavigationCase navCase;
        NavigationHandler navHandler = context.getApplication().getNavigationHandler();
        if (!(navHandler instanceof ConfigurableNavigationHandler)) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "jsf.outcome.target.invalid.navigationhandler.type", component.getId());
            }
            return null;
        }
        String outcome = ((UIOutcomeTarget)component).getOutcome();
        if (outcome == null) {
            outcome = context.getViewRoot().getViewId();
        }
        if ((navCase = ((ConfigurableNavigationHandler)navHandler).getNavigationCase(context, null, outcome)) == null && logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "jsf.outcometarget.navigation.case.not.resolved", component.getId());
        }
        return navCase;
    }

    protected String getEncodedTargetURL(FacesContext context, UIComponent component, NavigationCase navCase) {
        String toViewId = navCase.getToViewId(context);
        Map<String, List<String>> params = this.getParamOverrides(component);
        this.addNavigationParams(navCase, params);
        return Util.getViewHandler(context).getBookmarkableURL(context, toViewId, params, this.isIncludeViewParams(component, navCase));
    }

    protected void addNavigationParams(NavigationCase navCase, Map<String, List<String>> existingParams) {
        Map navParams = navCase.getParameters();
        if (navParams == null || navParams.isEmpty()) {
            return;
        }
        for (Map.Entry entry : navParams.entrySet()) {
            String navParamName = (String)entry.getKey();
            if (existingParams.containsKey(navParamName)) continue;
            if (((List)entry.getValue()).size() == 1) {
                String value = (String)((List)entry.getValue()).get(0);
                if (value.trim().startsWith("#{")) {
                    FacesContext fc = FacesContext.getCurrentInstance();
                    value = (String)fc.getApplication().evaluateExpressionGet(fc, value, String.class);
                    ArrayList<String> values = new ArrayList<String>();
                    values.add(value);
                    existingParams.put(navParamName, values);
                    continue;
                }
                existingParams.put(navParamName, (List<String>)entry.getValue());
                continue;
            }
            existingParams.put(navParamName, (List<String>)entry.getValue());
        }
    }

    protected Map<String, List<String>> getParamOverrides(UIComponent component) {
        HtmlBasicRenderer.Param[] declaredParams;
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        for (HtmlBasicRenderer.Param candidate : declaredParams = this.getParamList(component)) {
            if (candidate.name == null || candidate.name.trim().length() <= 0) continue;
            candidate.name = candidate.name.trim();
            ArrayList<String> values = (ArrayList<String>)params.get(candidate.name);
            if (values == null) {
                values = new ArrayList<String>();
                params.put(candidate.name, values);
            }
            values.add(candidate.value);
        }
        return params;
    }
}

