/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.resource;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.log.LogFormatUtils;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.support.ServletContextResource;
import org.springframework.web.util.UriUtils;

public abstract class ResourceHandlerUtils {
    private static final Log logger = LogFactory.getLog(ResourceHandlerUtils.class);

    public static String normalizeInputPath(String path) {
        path = StringUtils.replace((String)path, (String)"\\", (String)"/");
        path = ResourceHandlerUtils.cleanDuplicateSlashes(path);
        path = ResourceHandlerUtils.cleanLeadingSlash(path);
        return ResourceHandlerUtils.normalizePath(path);
    }

    private static String normalizePath(String path) {
        String result = path;
        if ((result = ResourceHandlerUtils.decode(result)).contains("%")) {
            result = ResourceHandlerUtils.decode(result);
        }
        if (!StringUtils.hasText((String)result)) {
            return result;
        }
        if (result.contains("../")) {
            return StringUtils.cleanPath((String)result);
        }
        return path;
    }

    private static String decode(String path) {
        try {
            return UriUtils.decode((String)path, (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception ex) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String cleanDuplicateSlashes(String path) {
        StringBuilder sb = null;
        char prev = '\u0000';
        for (int i2 = 0; i2 < path.length(); ++i2) {
            char curr = path.charAt(i2);
            try {
                if (curr == '/' && prev == '/') {
                    if (sb != null) continue;
                    sb = new StringBuilder(path.substring(0, i2));
                    continue;
                }
                if (sb == null) continue;
                sb.append(path.charAt(i2));
                continue;
            }
            finally {
                prev = curr;
            }
        }
        return sb != null ? sb.toString() : path;
    }

    private static String cleanLeadingSlash(String path) {
        boolean slash = false;
        for (int i2 = 0; i2 < path.length(); ++i2) {
            if (path.charAt(i2) == '/') {
                slash = true;
                continue;
            }
            if (path.charAt(i2) <= ' ' || path.charAt(i2) == '\u007f') continue;
            if (i2 == 0 || i2 == 1 && slash) {
                return path;
            }
            return slash ? "/" + path.substring(i2) : path.substring(i2);
        }
        return slash ? "/" : "";
    }

    public static boolean shouldIgnoreInputPath(String path) {
        return !StringUtils.hasText((String)path) || ResourceHandlerUtils.isInvalidPath(path) || ResourceHandlerUtils.isInvalidEncodedPath(path);
    }

    public static boolean isInvalidPath(String path) {
        if (path.contains("WEB-INF") || path.contains("META-INF")) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)LogFormatUtils.formatValue((Object)("Path with \"WEB-INF\" or \"META-INF\": [" + path + "]"), (int)-1, (boolean)true));
            }
            return true;
        }
        if (path.contains(":/")) {
            String relativePath;
            String string = relativePath = path.charAt(0) == '/' ? path.substring(1) : path;
            if (ResourceUtils.isUrl((String)relativePath) || relativePath.startsWith("url:")) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)LogFormatUtils.formatValue((Object)("Path represents URL or has \"url:\" prefix: [" + path + "]"), (int)-1, (boolean)true));
                }
                return true;
            }
        }
        if (path.contains("..") && StringUtils.cleanPath((String)path).contains("../")) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)LogFormatUtils.formatValue((Object)("Path contains \"../\" after call to StringUtils#cleanPath: [" + path + "]"), (int)-1, (boolean)true));
            }
            return true;
        }
        return false;
    }

    private static boolean isInvalidEncodedPath(String path) {
        if (path.contains("%")) {
            try {
                String decodedPath = URLDecoder.decode(path, StandardCharsets.UTF_8.toString());
                if (ResourceHandlerUtils.isInvalidPath(decodedPath)) {
                    return true;
                }
                if (ResourceHandlerUtils.isInvalidPath(decodedPath = ResourceHandlerUtils.normalizeInputPath(decodedPath))) {
                    return true;
                }
            }
            catch (UnsupportedEncodingException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isResourceUnderLocation(Resource location, Resource resource) throws IOException {
        String locationPath;
        String resourcePath;
        if (resource.getClass() != location.getClass()) {
            return false;
        }
        if (resource instanceof UrlResource) {
            resourcePath = resource.getURL().toExternalForm();
            locationPath = StringUtils.cleanPath((String)location.getURL().toString());
        } else if (resource instanceof ClassPathResource) {
            ClassPathResource classPathResource = (ClassPathResource)resource;
            resourcePath = classPathResource.getPath();
            locationPath = StringUtils.cleanPath((String)((ClassPathResource)location).getPath());
        } else if (resource instanceof ServletContextResource) {
            ServletContextResource servletContextResource = (ServletContextResource)resource;
            resourcePath = servletContextResource.getPath();
            locationPath = StringUtils.cleanPath((String)((ServletContextResource)location).getPath());
        } else {
            resourcePath = resource.getURL().getPath();
            locationPath = StringUtils.cleanPath((String)location.getURL().getPath());
        }
        if (locationPath.equals(resourcePath)) {
            return true;
        }
        locationPath = locationPath.endsWith("/") || locationPath.isEmpty() ? locationPath : locationPath + "/";
        return resourcePath.startsWith(locationPath) && !ResourceHandlerUtils.isInvalidEncodedResourcePath(resourcePath);
    }

    private static boolean isInvalidEncodedResourcePath(String resourcePath) {
        if (resourcePath.contains("%")) {
            try {
                String decodedPath = URLDecoder.decode(resourcePath, StandardCharsets.UTF_8.toString());
                if (decodedPath.contains("../") || decodedPath.contains("..\\")) {
                    logger.warn((Object)LogFormatUtils.formatValue((Object)("Resolved resource path contains encoded \"../\" or \"..\\\": " + resourcePath), (int)-1, (boolean)true));
                    return true;
                }
            }
            catch (UnsupportedEncodingException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return false;
    }
}

