/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.hyperexpress.serialization.jackson;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.strategicgains.hyperexpress.domain.Link;
import com.strategicgains.hyperexpress.domain.Namespace;
import com.strategicgains.hyperexpress.domain.Resource;
import com.strategicgains.hyperexpress.domain.hal.HalLink;
import com.strategicgains.hyperexpress.domain.hal.HalResource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HalResourceSerializer
extends JsonSerializer<HalResource> {
    private static final String CURIES = "curies";
    private static final String EMBEDDED = "_embedded";
    private static final String LINKS = "_links";

    public void serialize(HalResource resource, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        jgen.writeStartObject();
        this.renderJson(resource, jgen, false);
        jgen.writeEndObject();
    }

    private void renderJson(HalResource resource, JsonGenerator jgen, boolean isEmbedded) throws JsonGenerationException, IOException {
        this.writeLinks(resource, isEmbedded, jgen);
        this.writeEmbedded(resource, jgen);
        this.writeProperties(resource.getProperties(), jgen);
    }

    private void writeLinks(HalResource resource, boolean isEmbedded, JsonGenerator jgen) throws JsonGenerationException, IOException {
        List links = resource.getLinks();
        List namespaces = resource.getNamespaces();
        if (links.isEmpty() && (isEmbedded || namespaces.isEmpty())) {
            return;
        }
        jgen.writeObjectFieldStart(LINKS);
        this.writeCuries(namespaces, isEmbedded, jgen);
        Map<String, List<HalLink>> linksByRel = this.indexLinksByRel(resource.getLinks());
        for (Map.Entry<String, List<HalLink>> entry : linksByRel.entrySet()) {
            if (entry.getValue().size() == 1 && !resource.isMultipleLinks(entry.getKey())) {
                HalLink link = entry.getValue().iterator().next();
                if (null == link.getTemplated()) {
                    link.setTemplated(link.hasTemplate() ? Boolean.valueOf(true) : null);
                }
                jgen.writeObjectField(entry.getKey(), (Object)link);
                continue;
            }
            jgen.writeArrayFieldStart(entry.getKey());
            for (HalLink link : entry.getValue()) {
                if (null == link.getTemplated()) {
                    link.setTemplated(link.hasTemplate() ? Boolean.valueOf(true) : null);
                }
                jgen.writeObject((Object)link);
            }
            jgen.writeEndArray();
        }
        jgen.writeEndObject();
    }

    private Map<String, List<HalLink>> indexLinksByRel(List<Link> links) {
        HashMap<String, List<HalLink>> linksByRel = new HashMap<String, List<HalLink>>();
        for (Link link : links) {
            ArrayList<HalLink> linksForRel = (ArrayList<HalLink>)linksByRel.get(link.getRel());
            if (linksForRel == null) {
                linksForRel = new ArrayList<HalLink>();
                linksByRel.put(link.getRel(), linksForRel);
            }
            linksForRel.add(new HalLink(link));
        }
        return linksByRel;
    }

    private void writeCuries(List<Namespace> namespaces, boolean isEmbedded, JsonGenerator jgen) throws IOException, JsonGenerationException, JsonProcessingException {
        if (isEmbedded || namespaces.isEmpty()) {
            return;
        }
        if (namespaces.size() == 1) {
            jgen.writeObjectField(CURIES, (Object)namespaces.iterator().next());
        } else {
            jgen.writeArrayFieldStart(CURIES);
            for (Namespace ns : namespaces) {
                jgen.writeObject((Object)ns);
            }
            jgen.writeEndArray();
        }
    }

    private void writeEmbedded(Resource resource, JsonGenerator jgen) throws JsonGenerationException, IOException {
        Map embedded = resource.getResources();
        if (embedded.isEmpty()) {
            return;
        }
        jgen.writeObjectFieldStart(EMBEDDED);
        for (Map.Entry entry : embedded.entrySet()) {
            if (((List)entry.getValue()).size() == 1 && !resource.isMultipleResources((String)entry.getKey())) {
                jgen.writeObjectFieldStart((String)entry.getKey());
                this.renderJson((HalResource)((Object)((List)entry.getValue()).iterator().next()), jgen, true);
                jgen.writeEndObject();
                continue;
            }
            jgen.writeArrayFieldStart((String)entry.getKey());
            for (Resource r : (List)entry.getValue()) {
                jgen.writeStartObject();
                this.renderJson((HalResource)r, jgen, true);
                jgen.writeEndObject();
            }
            jgen.writeEndArray();
        }
        jgen.writeEndObject();
    }

    private void writeProperties(Map<String, Object> properties, JsonGenerator jgen) throws JsonProcessingException, IOException {
        if (properties.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            jgen.writeObjectField(entry.getKey(), entry.getValue());
        }
    }
}

