/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.hyperexpress.serialization.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.strategicgains.hyperexpress.BuilderFactory;
import com.strategicgains.hyperexpress.builder.ConditionalLinkBuilder;
import com.strategicgains.hyperexpress.builder.DefaultBuilderFactory;
import com.strategicgains.hyperexpress.builder.LinkBuilder;
import com.strategicgains.hyperexpress.domain.Namespace;
import com.strategicgains.hyperexpress.domain.hal.HalResource;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class HalResourceDeserializer
extends JsonDeserializer<HalResource> {
    private static final String LINKS = "_links";
    private static final String CURIES = "curies";
    private static final String EMBEDDED = "_embedded";
    private static final Set<String> RESERVED_PROPERTIES = new HashSet<String>(Arrays.asList("_links", "_embedded"));
    private BuilderFactory factory;

    public HalResourceDeserializer() {
        this.factory = new DefaultBuilderFactory();
    }

    public HalResourceDeserializer(BuilderFactory factory) {
        this.factory = factory;
    }

    public HalResource deserialize(JsonParser jp, DeserializationContext context) throws IOException, JsonProcessingException {
        ObjectCodec oc = jp.getCodec();
        return this.deserializeResource((JsonNode)jp.readValueAsTree(), oc);
    }

    private HalResource deserializeResource(JsonNode root, ObjectCodec oc) throws JsonProcessingException, IOException {
        HalResource resource = new HalResource();
        this.processLinks(root.get(LINKS), resource, oc);
        this.processEmbedded(root.get(EMBEDDED), resource, oc);
        this.processProperties(root, resource);
        return resource;
    }

    private void processLinks(JsonNode links, HalResource resource, ObjectCodec oc) throws JsonProcessingException, IOException {
        if (links == null) {
            return;
        }
        this.processCuries(links.get(CURIES), resource, oc);
        Iterator fields = links.fields();
        while (fields.hasNext()) {
            Map.Entry field = (Map.Entry)fields.next();
            if (CURIES.equals(field.getKey())) continue;
            if (((JsonNode)field.getValue()).isArray()) {
                this.addAllLinks(resource, field);
                continue;
            }
            this.addLink(resource, field);
        }
    }

    private void processCuries(JsonNode curies, HalResource resource, ObjectCodec oc) throws JsonProcessingException, IOException {
        if (curies == null) {
            return;
        }
        if (curies.isArray()) {
            resource.addNamespaces(Arrays.asList((Object[])curies.traverse(oc).readValueAs(Namespace[].class)));
        } else {
            resource.addNamespace((Namespace)curies.traverse(oc).readValueAs(Namespace.class));
        }
    }

    private void addAllLinks(HalResource resource, Map.Entry<String, JsonNode> field) {
        ConditionalLinkBuilder lb = this.factory.newLinkBuilder();
        Iterator values = field.getValue().elements();
        while (values.hasNext()) {
            lb.rel(field.getKey());
            JsonNode value = (JsonNode)values.next();
            this.processLinkProperties((LinkBuilder)lb, value);
            resource.addLink(lb.build());
            lb.clearAttributes();
        }
    }

    private void addLink(HalResource resource, Map.Entry<String, JsonNode> field) {
        ConditionalLinkBuilder lb = this.factory.newLinkBuilder();
        lb.rel(field.getKey());
        this.processLinkProperties((LinkBuilder)lb, field.getValue());
        resource.addLink(lb.build());
    }

    private void processLinkProperties(LinkBuilder lb, JsonNode value) {
        Iterator elements = value.fields();
        while (elements.hasNext()) {
            Map.Entry element = (Map.Entry)elements.next();
            if ("href".equals(element.getKey())) {
                lb.urlPattern(((JsonNode)element.getValue()).asText());
                continue;
            }
            lb.set((String)element.getKey(), ((JsonNode)element.getValue()).asText());
        }
    }

    private void processEmbedded(JsonNode embedded, HalResource resource, ObjectCodec oc) throws JsonProcessingException, IOException {
        if (embedded == null) {
            return;
        }
        Iterator fields = embedded.fields();
        while (fields.hasNext()) {
            Map.Entry fieldEntry = (Map.Entry)fields.next();
            if (((JsonNode)fieldEntry.getValue()).isArray()) {
                Iterator values = ((JsonNode)fieldEntry.getValue()).elements();
                while (values.hasNext()) {
                    JsonNode value = (JsonNode)values.next();
                    resource.addResource((String)fieldEntry.getKey(), this.deserializeResource(value, oc));
                }
                continue;
            }
            resource.addResource((String)fieldEntry.getKey(), this.deserializeResource((JsonNode)fieldEntry.getValue(), oc));
        }
    }

    private void processProperties(JsonNode root, HalResource resource) {
        Iterator fields = root.fields();
        while (fields.hasNext()) {
            Map.Entry fieldEntry = (Map.Entry)fields.next();
            if (RESERVED_PROPERTIES.contains(fieldEntry.getKey())) continue;
            resource.setProperty((String)fieldEntry.getKey(), ((JsonNode)fieldEntry.getValue()).asText());
        }
    }
}

