/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.hyperexpress.annotation;

import com.strategicgains.hyperexpress.annotation.BindToken;
import com.strategicgains.hyperexpress.annotation.TokenBindings;
import com.strategicgains.hyperexpress.annotation.TokenFormatter;
import com.strategicgains.hyperexpress.builder.TokenBinder;
import com.strategicgains.hyperexpress.builder.TokenResolver;
import com.strategicgains.hyperexpress.domain.Resource;
import com.strategicgains.hyperexpress.exception.ResourceException;
import com.strategicgains.hyperexpress.util.Objects;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AnnotationTokenBinder
implements TokenBinder<Object> {
    private static final AnnotationTokenBinder INSTANCE = new AnnotationTokenBinder();
    private Map<Class<?>, TokenFormatter> formatters = new ConcurrentHashMap();

    public static AnnotationTokenBinder instance() {
        return INSTANCE;
    }

    @Override
    public void bind(Object object, TokenResolver resolver) {
        this.bindProperties(object.getClass(), object, resolver);
    }

    private void bindProperties(Class<?> type, Object from, TokenResolver resolver) {
        if (type == null) {
            return;
        }
        if (Resource.class.isAssignableFrom(type)) {
            return;
        }
        this.performClassBindings(from, resolver);
        Field[] fields = type.getDeclaredFields();
        try {
            for (Field f : fields) {
                BindToken annotation = f.getAnnotation(BindToken.class);
                if (annotation == null) continue;
                f.setAccessible(true);
                Object value = f.get(from);
                if (this.hasPropertyPath(annotation)) {
                    value = Objects.property(annotation.field(), value);
                }
                if (value == null) continue;
                this.bindAnnotatedProperty(annotation, value, resolver);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException e) {
            throw new ResourceException(e);
        }
        this.bindProperties(type.getSuperclass(), from, resolver);
    }

    private void performClassBindings(Object from, TokenResolver resolver) {
        if (from == null) {
            return;
        }
        TokenBindings bindings = from.getClass().getAnnotation(TokenBindings.class);
        if (bindings == null) {
            return;
        }
        for (BindToken binding : bindings.value()) {
            if (this.hasPropertyPath(binding)) {
                try {
                    Object value = Objects.property(binding.field(), from);
                    this.bindAnnotatedProperty(binding, value, resolver);
                    continue;
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException e) {
                    throw new ResourceException(e);
                }
            }
            throw new ResourceException("Class-level BindToken annotations require 'field' path.");
        }
    }

    private boolean hasPropertyPath(BindToken annotation) {
        return !"".equals(annotation.field());
    }

    private void bindAnnotatedProperty(BindToken annotation, Object field, TokenResolver resolver) throws InstantiationException, IllegalAccessException {
        Class<? extends TokenFormatter> formatterClass = annotation.formatter();
        TokenFormatter formatter = this.formatters.get(formatterClass);
        if (formatter == null) {
            formatter = formatterClass.newInstance();
            this.formatters.put(formatterClass, formatter);
        }
        resolver.bind(annotation.value(), formatter.format(field));
    }
}

