/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.hyperexpress;

import com.strategicgains.hyperexpress.ResourceFactoryStrategy;
import com.strategicgains.hyperexpress.domain.Resource;
import com.strategicgains.hyperexpress.exception.ResourceException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractResourceFactoryStrategy
implements ResourceFactoryStrategy {
    public static final int IGNORED_FIELD_MODIFIERS = 216;
    private Set<Class<? extends Annotation>> inclusionAnnotations;
    private Set<Class<? extends Annotation>> exclusionAnnotations;

    @SafeVarargs
    public final AbstractResourceFactoryStrategy includeAnnotations(Class<? extends Annotation> ... annotations) {
        if (annotations == null) {
            return this;
        }
        if (this.inclusionAnnotations == null) {
            this.inclusionAnnotations = new HashSet<Class<? extends Annotation>>();
        }
        this.inclusionAnnotations.addAll(Arrays.asList(annotations));
        return this;
    }

    @SafeVarargs
    public final AbstractResourceFactoryStrategy excludeAnnotations(Class<? extends Annotation> ... annotations) {
        if (annotations == null) {
            return this;
        }
        if (this.exclusionAnnotations == null) {
            this.exclusionAnnotations = new HashSet<Class<? extends Annotation>>();
        }
        this.exclusionAnnotations.addAll(Arrays.asList(annotations));
        return this;
    }

    protected void copyProperties(Object from, Resource to) {
        this.copyProperties0(from.getClass(), from, to);
    }

    private void copyProperties0(Class<?> type, Object from, Resource to) {
        if (type == null) {
            return;
        }
        if (Resource.class.isAssignableFrom(type)) {
            to.from((Resource)from);
            return;
        }
        Field[] fields = this.getDeclaredFields(type);
        try {
            for (Field f : fields) {
                if (!this.isIncluded(f)) continue;
                f.setAccessible(true);
                Object value = f.get(from);
                if (value == null) continue;
                this.addProperty(to, f, value);
            }
        }
        catch (IllegalAccessException e) {
            throw new ResourceException(e);
        }
        this.copyProperties0(type.getSuperclass(), from, to);
    }

    protected void addProperty(Resource to, Field f, Object value) {
        to.addProperty(f.getName(), value);
    }

    private boolean isIncluded(Field f) {
        if (this.inclusionAnnotations == null && this.exclusionAnnotations == null || f.getAnnotations().length == 0) {
            return (f.getModifiers() & 0xD8) == 0;
        }
        for (Annotation annotation : f.getAnnotations()) {
            Class<? extends Annotation> type = annotation.annotationType();
            if (this.inclusionAnnotations != null && this.inclusionAnnotations.contains(type)) {
                return true;
            }
            if (this.exclusionAnnotations == null || !this.exclusionAnnotations.contains(type)) continue;
            return false;
        }
        return (f.getModifiers() & 0xD8) == 0;
    }

    private Field[] getDeclaredFields(Class<?> type) {
        return type.getDeclaredFields();
    }
}

