/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webviewer.helper;

import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.utils.StiLoggingUtil;
import com.stimulsoft.base.utils.StiResourceUtil;
import com.stimulsoft.lib.io.StiIOUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.web.classes.StiRequestParams;
import com.stimulsoft.web.helper.StiWebActionResult;
import com.stimulsoft.web.helper.StiWebResourceHelper;
import com.stimulsoft.webviewer.StiWebViewer;
import com.stimulsoft.webviewer.helper.StiCollectionsHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;

public class StiResourcesHelper {
    private static ConcurrentHashMap<String, StiWebActionResult> STYLES = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, ConcurrentHashMap<String, StiWebActionResult>> SCRIPTS = new ConcurrentHashMap();

    private static StringBuilder getViewerStyles(String url, String theme) throws UnsupportedEncodingException, IOException {
        String stylesFolder = theme;
        if (theme.startsWith("Simple")) {
            stylesFolder = "Simple";
        } else if (theme.startsWith("Office2007")) {
            stylesFolder = "Office2007";
        } else if (theme.startsWith("Office2010")) {
            stylesFolder = "Office2010";
        } else if (theme.startsWith("Office2013")) {
            stylesFolder = "Office2013";
        }
        String path = "webviewer/Styles/" + stylesFolder + "/";
        HashMap<String, String> constants = null;
        HashMap result = new HashMap();
        try {
            StiWebResourceHelper.getResources(StiWebViewer.class, (String)"webviewer", (String)path, (String)url, (String)theme, null, result);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        StringBuilder css = new StringBuilder();
        for (String file : result.keySet()) {
            if (!file.endsWith(".css")) continue;
            file = file.replaceAll("//", "/");
            StringBuffer cssText = null;
            try {
                cssText = StiIOUtil.toStringBuffer((InputStream)StiResourceUtil.getStream((String)("/" + file)));
                if (file.endsWith("Constants.css") && file.indexOf(theme) >= 0) {
                    constants = StiResourcesHelper.getCssConstants(cssText);
                    continue;
                }
                if (file.endsWith("Constants.css")) continue;
                css.append(cssText).append("\r\n");
            }
            catch (IOException e) {
                StiLoggingUtil.showWarning((String)("Error get stream for " + file), (Exception)e);
            }
        }
        if (constants != null) {
            for (String key : constants.keySet()) {
                int i = -1;
                int ln = key.length();
                while ((i = css.indexOf(key)) >= 0) {
                    css.replace(i, i + ln, (String)constants.get(key));
                }
            }
        }
        return css;
    }

    private static HashMap<String, String> getCssConstants(StringBuffer css) {
        HashMap<String, String> constants = new HashMap<String, String>();
        String[] constantsArray = css.toString().split(";");
        for (int i = 0; i < constantsArray.length; ++i) {
            int index = constantsArray[i].indexOf(64);
            String[] values = constantsArray[i].substring(index >= 0 ? index : 0).split("=");
            if (values.length != 2) continue;
            constants.put(values[0].trim(), values[1].trim());
        }
        return constants;
    }

    public static StringBuilder getScripts(StiRequestParams requestParams, String url) throws UnsupportedEncodingException, IOException, NoSuchAlgorithmException {
        StringBuilder script = new StringBuilder();
        HashMap result = new HashMap();
        try {
            StiWebResourceHelper.getResources(StiWebViewer.class, (String)"webviewer", (String)"webviewer/Scripts/", (String)url, (String)requestParams.theme, null, result);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        for (String file : result.keySet()) {
            if (!file.endsWith(".js")) continue;
            file = file.replaceAll("//", "/");
            StringBuffer cssText = null;
            try {
                cssText = StiIOUtil.toStringBuffer((InputStream)StiResourceUtil.getStream((String)("/" + file)));
                if (file.endsWith("Main.js")) {
                    script.append(cssText.toString().replace("this.collections = {};", String.format("this.collections = %s", StiResourcesHelper.getCollections(requestParams, url))));
                } else {
                    script.append(cssText);
                }
                script.append("\r\n");
            }
            catch (IOException e) {
                StiLoggingUtil.showWarning((String)("Error get stream for " + file), (Exception)e);
            }
        }
        return script;
    }

    private static HashMap<String, String> getImagesArray(StiRequestParams requestParams, String url) throws IOException {
        String imagesThemePath = "webviewer/Images/" + (StiValidationUtil.isNullOrEmpty((String)requestParams.theme) ? "Default" : requestParams.theme) + "/";
        String imagesPath = "webviewer/Images/";
        HashMap images = StiWebResourceHelper.getImages(StiWebViewer.class, (String)"webviewer", (String)imagesPath, (String)url, (String)requestParams.theme, (boolean)true);
        HashMap tImages = StiWebResourceHelper.getImages(StiWebViewer.class, (String)"webviewer", (String)imagesThemePath, (String)url, (String)requestParams.theme, (boolean)true);
        images.putAll(tImages);
        return images;
    }

    private static String getCollections(StiRequestParams requestParams, String url) throws IOException, NoSuchAlgorithmException {
        HashMap<String, Object> collections = new HashMap<String, Object>();
        collections.put("images", StiResourcesHelper.getImagesArray(requestParams, url));
        collections.put("loc", StiCollectionsHelper.getLocalizationItems(requestParams));
        collections.put("encodingData", StiCollectionsHelper.getEncodingDataItems());
        collections.put("dateRanges", StiCollectionsHelper.getDateRangesItems());
        collections.put("months", new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"});
        collections.put("dayOfWeek", new String[]{"Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"});
        return new JSONObject(collections).toString();
    }

    public static StiWebActionResult get(String contextURL, StiRequestParams requestParams) throws IOException, JSONException, NoSuchAlgorithmException {
        byte[] bytes = null;
        switch (requestParams.component) {
            case Viewer: {
                if ("scripts".equals(requestParams.resource)) {
                    bytes = StiResourcesHelper.getScripts(requestParams, contextURL).toString().getBytes("UTF-8");
                    return new StiWebActionResult(bytes, "text/javascript");
                }
                if (!"styles".equals(requestParams.resource)) break;
                bytes = StiResourcesHelper.getViewerStyles(contextURL, requestParams.theme).toString().getBytes("UTF-8");
                return new StiWebActionResult(bytes, "text/css");
            }
            case Designer: {
                break;
            }
        }
        return new StiWebActionResult();
    }
}

