/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webviewer;

import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.mail.StiMailProperties;
import com.stimulsoft.base.system.StiGuid;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.export.settings.StiExportSettings;
import com.stimulsoft.web.cache.StiCacheOptions;
import com.stimulsoft.web.classes.StiRequestParams;
import com.stimulsoft.web.helper.StiCacheHelper;
import com.stimulsoft.web.helper.StiExportsHelper;
import com.stimulsoft.web.helper.StiRequestParamsHelper;
import com.stimulsoft.webviewer.StiWebViewerOptions;
import com.stimulsoft.webviewer.StiWebViewerRender;
import java.io.IOException;
import java.net.URL;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.ParserConfigurationException;

public class StiWebViewerHelper {
    private static StiCacheHelper cacheHelper = null;

    public static StiCacheHelper getCacheHelper() {
        if (cacheHelper == null) {
            cacheHelper = new StiCacheHelper();
        }
        return cacheHelper;
    }

    public static StiReport getReportObject(HttpServletRequest httpContext, StiRequestParams requestParams) {
        return requestParams.cache.helper.getReportInternal(requestParams, httpContext);
    }

    public String getWebViewer(URL context, HttpServletRequest request, StiReport report, ServletContext servletContext) throws ParserConfigurationException, IOException, StiException {
        return this.getWebViewer("WebViewer1" + StiGuid.newGuidStringPlain(), context, request, report, servletContext);
    }

    public String getWebViewer(StiWebViewerOptions options, StiMailProperties mailProperties, URL context, HttpServletRequest request, StiReport report, ServletContext servletContext) throws ParserConfigurationException, IOException, StiException {
        return this.getWebViewer("WebViewer1" + StiGuid.newGuidStringPlain(), options, mailProperties, context, request, report, servletContext);
    }

    public String getWebViewer(String viewerID, URL context, HttpServletRequest request, StiReport report, ServletContext servletContext) throws ParserConfigurationException, IOException, StiException {
        return this.getWebViewer(viewerID, new StiWebViewerOptions(), null, context, request, report, servletContext);
    }

    public String getWebViewer(String viewerID, StiWebViewerOptions options, StiMailProperties mailProperties, URL context, HttpServletRequest request, StiReport report, ServletContext servletContext) throws ParserConfigurationException, IOException, StiException {
        if (options == null) {
            options = new StiWebViewerOptions();
        }
        if (StiValidationUtil.isNotNullOrEmpty((String)viewerID)) {
            options.setViewerID(viewerID);
        } else {
            options.setViewerID("WebViewer1");
        }
        StiWebViewerRender viewer = new StiWebViewerRender(options, context, false);
        if (options.getServer().isClearCashe()) {
            StiCacheOptions.cache.clearStoredObjects(request);
        }
        StiCacheOptions.cache.storeObject(request, (Object)report, options.getViewerID() + "webviewer_cached_report");
        StiCacheOptions.cache.storeObject(request, (Object)mailProperties, options.getViewerID() + "mailProperties" + "webviewer_cached_report");
        StiCacheOptions.cache.storeObject(request, (Object)options.getExceptionHandler(), "exceptionHandlerwebviewer_cached_report");
        return viewer.getViewer(context, servletContext);
    }

    public static StiRequestParams getRequestParams(HttpServletRequest httpContext, HttpServletResponse response) throws IOException, JSONException {
        StiRequestParams requestParams = StiRequestParamsHelper.get((HttpServletRequest)httpContext, (HttpServletResponse)response, null);
        requestParams.cache.helper = StiWebViewerHelper.getCacheHelper();
        return requestParams;
    }

    public static StiExportSettings getExportSettings(StiRequestParams requestParams) {
        return StiExportsHelper.getExportSettings((StiRequestParams)requestParams);
    }
}

