/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.viewer.utils;

import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.viewer.visual.StiVisual;
import com.stimulsoft.viewer.controls.visual.StiPageVisual;
import com.stimulsoft.viewer.events.StiViewCommonEvent;
import com.stimulsoft.viewer.panels.StiThumbnailsPannel;
import com.stimulsoft.viewer.panels.StiViewPannel;

public class StiNavigateButtonsProcessor {
    private static final int VIEW_PANEL_SCROLL_STEP = 50;
    public static final int VIEW_PANEL_FOCUS_INDEX = 0;
    public static final int THUMBLAMILS_PANEL_FOCUS_INDEX = 1;
    private static StiViewPannel viewPanel;
    private static StiThumbnailsPannel thumnailsPanel;
    private static int focusedPanel;

    public static void setup(StiViewPannel viewPanel, StiThumbnailsPannel thumbnailsPanel) {
        StiNavigateButtonsProcessor.viewPanel = viewPanel;
        thumnailsPanel = thumbnailsPanel;
    }

    public static void changeFocus(int focus) {
        focusedPanel = focus;
        if (viewPanel != null) {
            viewPanel.requestFocusInWindow();
        }
    }

    public static void actionPerformed(int keyCode) {
        if (focusedPanel == 0 && viewPanel != null) {
            switch (keyCode) {
                case 34: {
                    if (viewPanel.getStiViewModel().getCurrentPage() + 1 >= viewPanel.getStiViewModel().getPagesCount()) break;
                    viewPanel.getEventDispatcher().dispatchStiEvent(new StiViewCommonEvent("CurrentPageChanged", viewPanel.getStiViewModel().getCurrentPage() + 1));
                    break;
                }
                case 33: {
                    if (viewPanel.getStiViewModel().getCurrentPage() <= 0) break;
                    viewPanel.getEventDispatcher().dispatchStiEvent(new StiViewCommonEvent("CurrentPageChanged", viewPanel.getStiViewModel().getCurrentPage() - 1));
                    break;
                }
                case 35: {
                    if (viewPanel.getStiViewModel().getCurrentPage() + 1 >= viewPanel.getStiViewModel().getPagesCount()) break;
                    viewPanel.getEventDispatcher().dispatchStiEvent(new StiViewCommonEvent("CurrentPageChanged", viewPanel.getStiViewModel().getPagesCount() - 1));
                    break;
                }
                case 36: {
                    if (viewPanel.getStiViewModel().getCurrentPage() <= 0) break;
                    viewPanel.getEventDispatcher().dispatchStiEvent(new StiViewCommonEvent("CurrentPageChanged", 0));
                    break;
                }
                case 40: {
                    viewPanel.getVerticalScrollBar().setValue(viewPanel.getVerticalScrollBar().getValue() + 50);
                    StiNavigateButtonsProcessor.checkCurrentPage();
                    break;
                }
                case 38: {
                    viewPanel.getVerticalScrollBar().setValue(viewPanel.getVerticalScrollBar().getValue() - 50);
                    StiNavigateButtonsProcessor.checkCurrentPage();
                    break;
                }
                case 37: {
                    viewPanel.getHorizontalScrollBar().setValue(viewPanel.getHorizontalScrollBar().getValue() - 50);
                    break;
                }
                case 39: {
                    viewPanel.getHorizontalScrollBar().setValue(viewPanel.getHorizontalScrollBar().getValue() + 50);
                }
            }
        } else if (focusedPanel == 1 && thumnailsPanel != null) {
            switch (keyCode) {
                case 35: {
                    if (thumnailsPanel.getScrolledPage() + 1 >= viewPanel.getStiViewModel().getPagesCount()) break;
                    thumnailsPanel.scrollToPage(viewPanel.getStiViewModel().getPagesCount() - 1, true);
                    break;
                }
                case 36: {
                    if (thumnailsPanel.getScrolledPage() <= 0) break;
                    thumnailsPanel.scrollToPage(0, true);
                    break;
                }
                case 39: 
                case 40: {
                    if (thumnailsPanel.getScrolledPage() + 1 >= viewPanel.getStiViewModel().getPagesCount()) break;
                    thumnailsPanel.scrollToPage(thumnailsPanel.getScrolledPage() + 1, true);
                    break;
                }
                case 37: 
                case 38: {
                    if (thumnailsPanel.getScrolledPage() <= 0) break;
                    thumnailsPanel.scrollToPage(thumnailsPanel.getScrolledPage() - 1, true);
                }
            }
        }
    }

    private static void checkCurrentPage() {
        if (viewPanel != null && !StiNavigateButtonsProcessor.isVisualInView(viewPanel.getVisuals().get(viewPanel.getStiViewModel().getCurrentPage())).booleanValue()) {
            for (int i = 0; i < viewPanel.getVisuals().size(); ++i) {
                StiVisual visual = viewPanel.getVisuals().get(i);
                if (!StiNavigateButtonsProcessor.isVisualInView(visual).booleanValue()) continue;
                viewPanel.getEventDispatcher().dispatchStiEvent(new StiViewCommonEvent("CurrentPageChanged", i, false));
                return;
            }
        }
    }

    private static Boolean isVisualInView(StiVisual visual) {
        if (visual instanceof StiPageVisual) {
            StiPageVisual pageVisual = (StiPageVisual)visual;
            StiRectangle visualRect = new StiRectangle((long)(pageVisual.getX() - viewPanel.getHorizontalScrollBar().getValue()), (long)(pageVisual.getY() - viewPanel.getVerticalScrollBar().getValue()), (long)pageVisual.getWidth(), (long)pageVisual.getHeight());
            if (0.0 > visualRect.getRight() || (double)viewPanel.getWidth() < visualRect.getX() || 0.0 > visualRect.getBottom() || (double)viewPanel.getHeight() < visualRect.getY()) {
                return false;
            }
            return true;
        }
        return true;
    }

    static {
        focusedPanel = 0;
    }
}

