/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.viewer.requestfromuser.value;

import com.stimulsoft.base.exception.StiExceptionProvider;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.utils.StiResourceUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.simplecomponents.StiImageHelper;
import com.stimulsoft.report.dictionary.StiVariable;
import com.stimulsoft.report.dictionary.StiVariableItem;
import com.stimulsoft.viewer.StiViewerFx;
import com.stimulsoft.viewer.controls.dialogs.StiFileChooser;
import com.stimulsoft.viewer.requestfromuser.StiDialogInfoValue;
import com.stimulsoft.viewer.requestfromuser.components.StiRequestButton;
import com.stimulsoft.viewer.requestfromuser.components.StiRequestCheckBox;
import com.stimulsoft.viewer.requestfromuser.components.StiRequestPanel;
import com.stimulsoft.viewer.requestfromuser.controls.StiRequestFromUserDropDownButton;
import com.stimulsoft.viewer.requestfromuser.value.IStiValueItemControl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class StiValueImageItemControl
extends StiRequestPanel
implements IStiValueItemControl {
    private static final long serialVersionUID = -3245853900353155288L;
    private StiRequestButton btOpen;
    private StiRequestButton btRemove;
    private ImagePanel pictureBox;
    private StiRequestFromUserDropDownButton dropDownButton;
    private StiRequestCheckBox checkBoxNotAssigned;

    public StiValueImageItemControl(StiVariable variable, StiReport report) {
        super(null);
        this.initializeComponent();
        BufferedImage defaultValue = null;
        try {
            defaultValue = StiImageHelper.decodeImage((String)variable.getValueObject().toString(), null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        boolean allowUserValues = variable.getDialogInfo().getAllowUserValues();
        List list = variable.getDialogInfoItems();
        ArrayList<StiDialogInfoValue> listValues = new ArrayList<StiDialogInfoValue>();
        for (StiVariableItem item : list) {
            listValues.add(new StiDialogInfoValue(item));
        }
        this.dropDownButton.setListValues(listValues);
        this.dropDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object object = ((JComboBox)e.getSource()).getSelectedItem();
                StiValueImageItemControl.this.dropDownButtonItemChanged((StiDialogInfoValue)object);
            }
        });
        if (listValues.size() == 0) {
            this.dropDownButton.setVisible(false);
        }
        if (!allowUserValues) {
            this.btOpen.setVisible(false);
            this.btRemove.setVisible(false);
            this.checkBoxNotAssigned.setVisible(false);
            this.dropDownButton.setLeft(this.pictureBox.getX() + this.pictureBox.getWidth() + 3);
            this.setWidth(this.dropDownButton.getRight() + 2);
        } else {
            this.setWidth(this.checkBoxNotAssigned.getX() + this.checkBoxNotAssigned.getWidth() + 2);
        }
        this.dropDownButton.setHorizontalOffset(-this.dropDownButton.getX());
        if (defaultValue != null) {
            this.pictureBox.setImage(defaultValue);
        } else if (this.checkBoxNotAssigned.isVisible()) {
            this.checkBoxNotAssigned.setSelected(true);
        }
    }

    @Override
    public Object getValue() {
        if (this.checkBoxNotAssigned.isSelected()) {
            return null;
        }
        return this.pictureBox.getImage();
    }

    private void checkBoxNotAssignedCheckedChanged() {
        this.btOpen.setEnabled(!this.checkBoxNotAssigned.isSelected());
        this.btRemove.setEnabled(!this.checkBoxNotAssigned.isSelected());
    }

    private void btRemoveImageVariableClick() {
        this.pictureBox.setImage(null);
    }

    private void btLoadImageVariableClick() {
        StiFileChooser fileChooser = new StiFileChooser("Image Files(*.png;*.bmp;*.jpg;*.jpeg;)", new String[]{".png", ".bmp", ".jpg", ".jpeg"});
        int result = fileChooser.showDialog(null, StiLocalization.getValue((String)"Buttons", (String)"Open"));
        if (result == 0) {
            try {
                this.pictureBox.setImage(ImageIO.read(fileChooser.getSelectedFile()));
            }
            catch (Exception e) {
                e.printStackTrace();
                StiExceptionProvider.show((Throwable)e, null);
            }
        }
    }

    private void dropDownButtonItemChanged(StiDialogInfoValue value) {
        if (value == null || value.getKey() == null) {
            if (this.checkBoxNotAssigned.isVisible()) {
                this.checkBoxNotAssigned.setSelected(true);
            }
        } else {
            this.pictureBox.setImage((BufferedImage)value.getKey());
        }
    }

    private void initializeComponent() {
        this.checkBoxNotAssigned = new StiRequestCheckBox();
        this.btOpen = new StiRequestButton();
        this.btRemove = new StiRequestButton();
        this.pictureBox = new ImagePanel();
        this.dropDownButton = new StiRequestFromUserDropDownButton();
        this.checkBoxNotAssigned.setLocation(173, 2);
        this.checkBoxNotAssigned.setName("checkBoxNotAssigned");
        this.checkBoxNotAssigned.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                StiValueImageItemControl.this.checkBoxNotAssignedCheckedChanged();
            }
        });
        this.btOpen.setIcon(StiResourceUtil.loadIcon((String)"/icons/ReportOpen.png"));
        this.btOpen.setLocation(101, 0);
        this.btOpen.setName("btOpen");
        this.btOpen.setSize(21, 21);
        this.btOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiValueImageItemControl.this.btLoadImageVariableClick();
            }
        });
        this.btRemove.setIcon(StiResourceUtil.loadIcon((String)"/icons/Delete.png"));
        this.btRemove.setLocation(123, 0);
        this.btRemove.setName("btRemove");
        this.btRemove.setSize(21, 21);
        this.btRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiValueImageItemControl.this.btRemoveImageVariableClick();
            }
        });
        this.pictureBox.setLocation(0, 0);
        this.pictureBox.setName("pictureBox");
        this.pictureBox.setSize(100, 21);
        this.pictureBox.setFocusable(false);
        this.pictureBox.setBackground(StiViewerFx.BACKGROUND_COLOR);
        this.pictureBox.setBorder(BorderFactory.createLineBorder(new Color(100, 100, 100)));
        this.dropDownButton.setHorizontalOffset(0);
        this.dropDownButton.setLocation(147, 0);
        this.dropDownButton.setName("dropDownButton");
        this.dropDownButton.setPopupHeight(200);
        this.dropDownButton.setPopupWidth(250);
        this.dropDownButton.setSize(21, 21);
        this.add(this.pictureBox);
        this.add(this.btRemove);
        this.add(this.btOpen);
        this.add((Component)((Object)this.dropDownButton));
        this.add(this.checkBoxNotAssigned);
        this.setName("StiValueImageItemControl");
        this.setSize(192, 21);
    }

    public StiRequestCheckBox getCheckBoxNotAssigned() {
        return this.checkBoxNotAssigned;
    }

    private class ImagePanel
    extends StiRequestPanel {
        private static final long serialVersionUID = 395645824602570007L;
        private BufferedImage image;

        private ImagePanel() {
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.image != null) {
                g.drawImage(this.image, 0, 0, null);
            }
        }

        public void setImage(BufferedImage image) {
            this.image = image;
            this.repaint();
        }

        public BufferedImage getImage() {
            return this.image;
        }
    }
}

