/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.viewer.requestfromuser.components;

import com.stimulsoft.base.system.StiDateTime;
import com.stimulsoft.base.system.StiTimeSpan;
import com.stimulsoft.base.utils.StiResourceUtil;
import com.stimulsoft.lib.utils.StiDateUtil;
import com.stimulsoft.report.components.StiShadowPanel;
import com.stimulsoft.viewer.requestfromuser.components.StiRequestButton;
import com.stimulsoft.viewer.requestfromuser.components.StiRequestCheckBox;
import com.stimulsoft.viewer.requestfromuser.components.StiRequestLabel;
import com.stimulsoft.viewer.requestfromuser.components.StiRequestPanel;
import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JWindow;
import javax.swing.SpinnerDateModel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class StiDateTimePicker
extends StiRequestPanel
implements AncestorListener {
    private static final long serialVersionUID = 499145064504498156L;
    private static final SimpleDateFormat DAY_OF_WEEK = new SimpleDateFormat("EEE");
    private static final SimpleDateFormat MONTH_YEAR = new SimpleDateFormat("MMMM yyyy");
    private final SButton[] button = new SButton[49];
    private String customFormat = StiDateUtil.DEFAULT_DATE_TIME_PATTERN;
    private Boolean showCheckBox = true;
    private StiDateTime value = StiDateTime.currentDate();
    private final StiRequestButton prevButton = new StiRequestButton();
    private final StiRequestButton nextButton = new StiRequestButton();
    private final StiRequestLabel dateLabel = new StiRequestLabel("", 0);
    private final StiRequestCheckBox checkBox = new StiRequestCheckBox();
    private final JSpinner spinner;
    private final StiRequestButton downButton = new StiRequestButton();
    private JWindow popup;
    private final StiShadowPanel downPanel = new StiShadowPanel(null);
    private final int firstDayOfWeek = 1;
    private final JPanel gridPanel = new JPanel(new GridLayout(7, 7));

    public StiDateTimePicker() {
        super(null);
        this.setBackground(new Color(0, 0, 0, 0));
        SpinnerDateModel dateModel = new SpinnerDateModel(this.value.getTime(), new Date(Long.MIN_VALUE), new Date(Long.MAX_VALUE), 1);
        this.spinner = new JSpinner(dateModel);
        this.spinner.setEditor(new JSpinner.DateEditor(this.spinner, this.customFormat));
        this.spinner.setBounds(14, 0, 145, 20);
        this.checkBox.setBounds(-4, 0, 18, 18);
        this.checkBox.setSelected(true);
        this.downButton.setBounds(162, 0, 30, 20);
        this.downButton.setIcon(StiResourceUtil.loadIcon((String)"/icons/DatePicker.png"));
        this.downButton.setFocusable(false);
        this.add(this.checkBox);
        this.add(this.spinner);
        this.add(this.downButton);
        this.setSize(new Dimension(230, 20));
        this.setPreferredSize(new Dimension(230, 20));
        this.downPanel.setSize(196, 126);
        this.downPanel.setBackground(Color.WHITE);
        this.prevButton.setBounds(3, 3, 20, 20);
        this.prevButton.setBackground(Color.WHITE);
        this.prevButton.setIcon(StiResourceUtil.loadIcon((String)"/icons/DatePickerPrev.png"));
        this.prevButton.setFocusable(false);
        this.dateLabel.setBounds(25, 3, 150, 20);
        this.dateLabel.setText("");
        this.dateLabel.setVerticalAlignment(0);
        this.dateLabel.setPreferredSize(new Dimension(150, 20));
        this.nextButton.setBounds(173, 3, 20, 20);
        this.nextButton.setBackground(Color.WHITE);
        this.nextButton.setFocusable(false);
        this.nextButton.setIcon(StiResourceUtil.loadIcon((String)"/icons/DatePickerNext.png"));
        this.gridPanel.setBounds(3, 25, 190, 100);
        this.gridPanel.setBorder(BorderFactory.createEmptyBorder());
        this.gridPanel.setBackground(Color.WHITE);
        this.downPanel.add((Component)this.prevButton);
        this.downPanel.add((Component)this.nextButton);
        this.downPanel.add((Component)this.dateLabel);
        this.downPanel.add((Component)this.gridPanel);
        this.bindEvents();
        this.setShowCheckBox(false);
    }

    public void setDateTime(boolean isDateTime) {
        this.downButton.setVisible(isDateTime);
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.downButton.setLocation(width - 30, this.downButton.getY());
        this.spinner.setSize(width - this.spinner.getX() - 30, this.spinner.getHeight());
    }

    private void createPanel() {
        this.updateSpinner();
        this.gridPanel.removeAll();
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(0L));
        cal.add(5, 3);
        String[] header = new String[7];
        for (int i = 0; i < 7; ++i) {
            cal.add(5, 1);
            header[i] = DAY_OF_WEEK.format(cal.getTime());
        }
        for (int x = 0; x < this.button.length; ++x) {
            final int selection = x;
            this.button[x] = new SButton(x < 7, false);
            if (x > 6) {
                this.button[x].addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        String day = StiDateTimePicker.this.button[selection].getActionCommand();
                        if (!"".equals(day)) {
                            StiDateTimePicker.this.value.set(5, Integer.parseInt(day));
                            StiDateTimePicker.this.updateSpinner();
                            StiDateTimePicker.this.hidePopup();
                        }
                    }
                });
            }
            if (x < 7) {
                this.button[x].setText(header[x]);
            }
            this.gridPanel.add(this.button[x]);
        }
        this.displayDate();
    }

    private void bindEvents() {
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiDateTimePicker.this.checkBox.setSelected(true);
                StiDateTimePicker.this.spinner.setEnabled(true);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (StiDateTimePicker.this.popup == null) {
                            JWindow windowParent = StiDateTimePicker.this.getWindow(null);
                            StiDateTimePicker.this.popup = new JWindow(windowParent != null ? windowParent : StiDateTimePicker.this.getFrame(null));
                            StiDateTimePicker.this.popup.add((Component)StiDateTimePicker.this.downPanel);
                            StiDateTimePicker.this.popup.setBackground(Color.WHITE);
                            StiDateTimePicker.this.popup.addWindowFocusListener(new WindowAdapter(){

                                @Override
                                public void windowLostFocus(WindowEvent evt) {
                                    StiDateTimePicker.this.hidePopup();
                                }
                            });
                        }
                        StiDateTimePicker.this.downPanel.updateBackground();
                        Dimension size = StiDateTimePicker.this.downPanel.getSize();
                        size.height += 4;
                        size.width += 4;
                        StiDateTimePicker.this.popup.setSize(size);
                        StiDateTimePicker.this.createPanel();
                        Point pt = StiDateTimePicker.this.getLocationOnScreen();
                        pt.translate(0, StiDateTimePicker.this.getHeight());
                        StiDateTimePicker.this.popup.setLocation(pt);
                        StiDateTimePicker.this.popup.toFront();
                        StiDateTimePicker.this.popup.setVisible(true);
                        StiDateTimePicker.this.popup.requestFocusInWindow();
                    }
                });
            }
        });
        this.addAncestorListener(this);
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent e) {
                MouseEvent event = (MouseEvent)e;
                if ((e.getID() == 500 || e.getID() == 501) && StiDateTimePicker.this.popup != null && StiDateTimePicker.this.popup.isVisible() && !StiDateTimePicker.this.isChild((Component)event.getSource(), StiDateTimePicker.this.popup)) {
                    StiDateTimePicker.this.hidePopup();
                }
            }
        }, 16L);
        this.spinner.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                StiDateTimePicker.this.value.setTime(((SpinnerDateModel)e.getSource()).getDate());
            }
        });
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                StiDateTimePicker.this.value.add(2, 1);
                StiDateTimePicker.this.value.set(5, 1);
                StiDateTimePicker.this.updateSpinner();
                StiDateTimePicker.this.displayDate();
            }
        });
        this.prevButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                StiDateTimePicker.this.value.add(2, -1);
                StiDateTimePicker.this.value.set(5, 1);
                StiDateTimePicker.this.updateSpinner();
                StiDateTimePicker.this.displayDate();
            }
        });
        this.checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiDateTimePicker.this.spinner.setEnabled(StiDateTimePicker.this.checkBox.isSelected());
            }
        });
    }

    private boolean isChild(Component child, Component parent) {
        while (child.getParent() != null) {
            if (child.getParent() == parent) {
                return true;
            }
            child = child.getParent();
        }
        return false;
    }

    private void updateSpinner() {
        ((SpinnerDateModel)this.spinner.getModel()).setValue(this.value.getTime());
        String sDate = MONTH_YEAR.format(this.value.getTime());
        this.dateLabel.setText(sDate);
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        this.hidePopup();
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
        this.hidePopup();
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
        if (event.getSource() != this.popup) {
            this.hidePopup();
        }
    }

    protected Frame getFrame(Component comp) {
        if (comp == null) {
            comp = this;
        }
        if (comp instanceof Frame) {
            return (Frame)comp;
        }
        return this.getFrame(comp.getParent());
    }

    protected JWindow getWindow(Component comp) {
        if (comp == null) {
            comp = this;
        }
        if (comp instanceof JWindow) {
            return (JWindow)comp;
        }
        return comp.getParent() == null ? null : this.getWindow(comp.getParent());
    }

    private void hidePopup() {
        if (this.popup != null && this.popup.isVisible()) {
            this.popup.setVisible(false);
        }
    }

    public void displayDate() {
        for (int x = 7; x < this.button.length; ++x) {
            this.button[x].setText("");
            this.button[x].setCurDate(false);
        }
        StiDateTime cal = this.value.clone();
        cal.set(this.value.get(1), this.value.get(2), 1);
        int dayOfWeek = cal.get(7);
        int daysInMonth = cal.getActualMaximum(5);
        int curDay = this.value.get(5);
        Integer x = 6 + dayOfWeek;
        Integer day = 1;
        while (day <= daysInMonth) {
            this.button[x].setText(day.toString());
            this.button[x].setCurDate(day == curDay);
            Integer n = x;
            Integer n2 = x = Integer.valueOf(x + 1);
            n = day;
            n2 = day = Integer.valueOf(day + 1);
        }
    }

    public String getCustomFormat() {
        return this.customFormat;
    }

    public void setCustomFormat(String customFormat) {
        this.customFormat = customFormat;
        this.spinner.setEditor(new JSpinner.DateEditor(this.spinner, customFormat));
    }

    public Boolean getShowCheckBox() {
        return this.showCheckBox;
    }

    public void setShowCheckBox(Boolean showCheckBox) {
        if (this.showCheckBox != showCheckBox) {
            this.showCheckBox = showCheckBox;
            this.checkBox.setVisible(showCheckBox);
            if (showCheckBox.booleanValue()) {
                this.spinner.setLocation(this.spinner.getX() + 14, this.spinner.getLocation().y);
                this.downButton.setLeft(this.downButton.getX() + 14);
            } else {
                this.spinner.setLocation(this.spinner.getX() - 14, this.spinner.getLocation().y);
                this.downButton.setLeft(this.downButton.getX() - 14);
            }
            this.setSize(super.getSize());
        }
    }

    public StiDateTime getValue() {
        return this.value;
    }

    public void setValue(StiDateTime value) {
        this.value = value;
        this.updateSpinner();
    }

    public void setValue(Date value) {
        StiDateTime cal = StiDateTime.currentDate();
        cal.setTime(value);
        this.setValue(cal);
    }

    public void setValue(StiTimeSpan value) {
        StiDateTime cal = StiDateTime.currentDate();
        cal.setTimeSpan(value);
        this.setValue(cal);
    }

    public boolean isChecked() {
        return this.checkBox.isSelected();
    }

    public void setChecked(boolean checked) {
        this.checkBox.setSelected(checked);
        this.spinner.setEnabled(checked);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.checkBox.setEnabled(enabled);
        this.spinner.setEnabled(enabled);
        this.downButton.setEnabled(enabled);
    }

    public int getRight() {
        return this.getX() + this.getWidth();
    }

    public void focus() {
        this.spinner.requestFocusInWindow();
    }

    public void setLeft(int left) {
        this.setLocation(left, this.getLocation().y);
    }

    public class SButton
    extends JButton {
        private static final long serialVersionUID = -1849206380795147131L;
        private boolean mouseOver = false;
        private boolean header = false;
        private boolean curDate = false;

        public SButton(boolean header, boolean curDate) {
            this.header = header;
            this.curDate = curDate;
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setFocusable(false);
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            super.processMouseEvent(e);
            if (e.getID() == 504) {
                this.mouseOver = true;
            } else if (e.getID() == 505) {
                this.mouseOver = false;
            }
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            Graphics2D gd = (Graphics2D)graphics;
            gd.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            gd.clearRect(0, 0, this.getWidth(), this.getHeight());
            int xl = 5;
            int xr = 17;
            if (this.curDate) {
                gd.setPaint(new GradientPaint(new Point(1, 1), new Color(242, 248, 255), new Point(1, this.getHeight() - 2), new Color(208, 229, 255)));
                gd.fillRect(xl, 0, xr, this.getHeight());
                gd.setColor(new Color(132, 172, 221));
                gd.drawRect(xl - 1, 0, xr + 1, this.getHeight() - 1);
                gd.setColor(new Color(29, 17, 0));
                gd.setStroke(new BasicStroke(1.0f, 0, 1, 1.0f, new float[]{1.0f, 0.0f, 1.0f}, 1.0f));
                gd.drawRect(xl, 1, xr - 1, this.getHeight() - 3);
            }
            gd.setColor(Color.BLACK);
            if (this.mouseOver && !this.header && !"".equals(this.getText())) {
                gd.setColor(new Color(132, 172, 231));
                gd.drawRect(xl - 1, 0, xr + 1, this.getHeight() - 1);
                gd.setColor(new Color(0, 102, 204));
            }
            Font font = this.header ? new Font("Arial", 1, 11) : new Font("Arial", 0, 11);
            double wd = font.getStringBounds(this.getText(), gd.getFontRenderContext()).getWidth();
            gd.setFont(font);
            int left = this.getWidth() / 2 - (int)wd / 2;
            if (!this.header) {
                left = this.getText().length() == 1 ? 12 : 8;
            }
            gd.drawString(this.getText(), left, 11);
        }

        public void setCurDate(boolean curDate) {
            this.curDate = curDate;
        }
    }
}

