/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.viewer.requestfromuser;

import com.stimulsoft.base.exception.StiExceptionProvider;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.range.Range;
import com.stimulsoft.base.system.type.StiSystemTypeEnum;
import com.stimulsoft.base.worker.StiSimpleWorker;
import com.stimulsoft.lib.utils.StiStringUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.dialogs.StiForm;
import com.stimulsoft.report.dictionary.StiVariable;
import com.stimulsoft.report.enums.StiCalculationMode;
import com.stimulsoft.report.enums.StiOrientation;
import com.stimulsoft.report.saveLoad.StiDocument;
import com.stimulsoft.viewer.StiViewerFx;
import com.stimulsoft.viewer.events.StiViewCommonEvent;
import com.stimulsoft.viewer.logic.StiViewModel;
import com.stimulsoft.viewer.requestfromuser.StiRequestFromUserHelper;
import com.stimulsoft.viewer.requestfromuser.components.StiRequestLabel;
import com.stimulsoft.viewer.requestfromuser.components.StiRequestPanel;
import com.stimulsoft.viewer.requestfromuser.list.StiListButtonXControl;
import com.stimulsoft.viewer.requestfromuser.range.IStiRangeItemControl;
import com.stimulsoft.viewer.requestfromuser.range.StiRangeCharItemControl;
import com.stimulsoft.viewer.requestfromuser.range.StiRangeDateTimeItemControl;
import com.stimulsoft.viewer.requestfromuser.range.StiRangeDoubleItemControl;
import com.stimulsoft.viewer.requestfromuser.range.StiRangeGuidItemControl;
import com.stimulsoft.viewer.requestfromuser.range.StiRangeLongItemControl;
import com.stimulsoft.viewer.requestfromuser.range.StiRangeStringItemControl;
import com.stimulsoft.viewer.requestfromuser.value.IStiValueItemControl;
import com.stimulsoft.viewer.requestfromuser.value.StiValueBoolItemControl;
import com.stimulsoft.viewer.requestfromuser.value.StiValueCharItemControl;
import com.stimulsoft.viewer.requestfromuser.value.StiValueDateTimeItemControl;
import com.stimulsoft.viewer.requestfromuser.value.StiValueDoubleItemControl;
import com.stimulsoft.viewer.requestfromuser.value.StiValueGuidItemControl;
import com.stimulsoft.viewer.requestfromuser.value.StiValueImageItemControl;
import com.stimulsoft.viewer.requestfromuser.value.StiValueLongItemControl;
import com.stimulsoft.viewer.requestfromuser.value.StiValueStringItemControl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class StiViewerControlsDialog {
    private static final int BOTTOM_PANEL_HEIGHT = 30;
    private StiViewModel model;
    private StiRequestPanel panelDialogs;
    private StiViewerFx viewerPanel;
    private Hashtable<String, JComponent> controlVariables = null;
    private List<StiVariable> storedVariables = new ArrayList<StiVariable>();

    public StiViewerControlsDialog(StiViewModel model, StiViewerFx viewerPanel) {
        this.model = model;
        this.viewerPanel = viewerPanel;
        this.panelDialogs = viewerPanel.getPanelDialogs();
    }

    public void refreshDialogs(Boolean storeVariables) {
        StiReport reportForCheck;
        this.clearDialogs();
        if (this.model.getReport() == null) {
            return;
        }
        StiReport report = this.model.getReport();
        StiReport stiReport = reportForCheck = report.getCompiledReport() != null ? report.getCompiledReport() : report;
        if (storeVariables.booleanValue()) {
            this.storedVariables.clear();
            for (StiVariable variable : report.getDictionary().getVariables()) {
                this.storedVariables.add((StiVariable)variable.clone());
            }
        }
        for (StiVariable variable : report.getDictionary().getVariables()) {
            if (!variable.getRequestFromUser() || reportForCheck.getCalculationMode() != StiCalculationMode.Interpretation) continue;
            this.showDialogRequestFromUserVariables(false);
            return;
        }
        for (StiPage page : reportForCheck.getPages()) {
            StiForm formControl;
            StiForm stiForm = formControl = page instanceof StiForm ? (StiForm)page : null;
            if (formControl == null) continue;
        }
    }

    private void showDialogRequestFromUserVariables(Boolean useStoredVariables) {
        String checkBoxNotAssignedTooltip = StiLocalization.getValue((String)"Report", (String)"NotAssigned");
        this.clearDialogs();
        this.controlVariables = new Hashtable();
        Hashtable<StiRequestLabel, JComponent> requestFromUserComponents = new Hashtable<StiRequestLabel, JComponent>();
        ArrayList<StiRequestLabel> requestFromUserLabels = new ArrayList<StiRequestLabel>();
        StiReport report = this.model.getReport();
        StiReport compileReport = report.getCompiledReport() == null ? report : report.getCompiledReport();
        for (StiVariable variable : useStoredVariables != false ? this.storedVariables : compileReport.getDictionary().getVariables()) {
            if (!variable.getRequestFromUser() || variable.getType() == StiSystemTypeEnum.SystemObject || variable.getType() == StiSystemTypeEnum.SystemByteArray) continue;
            StiRequestLabel lbVariable = null;
            StiRequestPanel itemControl = null;
            if (variable.isRange()) {
                lbVariable = StiRequestFromUserHelper.createLabel(this.getNameVariable(variable));
                if (variable.isTime()) {
                    itemControl = new StiRangeDateTimeItemControl(variable, compileReport);
                } else if (variable.getType() == StiSystemTypeEnum.SystemChar) {
                    itemControl = new StiRangeCharItemControl(variable, compileReport);
                } else if (variable.isDecimal()) {
                    itemControl = new StiRangeDoubleItemControl(variable, compileReport);
                } else if (variable.getType() == StiSystemTypeEnum.SystemGuid) {
                    itemControl = new StiRangeGuidItemControl(variable, compileReport);
                } else if (variable.getType() == StiSystemTypeEnum.SystemString) {
                    itemControl = new StiRangeStringItemControl(variable, compileReport);
                } else if (variable.isInteger()) {
                    itemControl = new StiRangeLongItemControl(variable, compileReport);
                }
            } else if (variable.isList()) {
                lbVariable = StiRequestFromUserHelper.createLabel(this.getNameVariable(variable));
                itemControl = new StiListButtonXControl(variable.getType(), variable);
            } else {
                lbVariable = StiRequestFromUserHelper.createLabel(this.getNameVariable(variable));
                if (variable.getType() == StiSystemTypeEnum.SystemBoolean) {
                    itemControl = new StiValueBoolItemControl(variable);
                    ((StiValueBoolItemControl)itemControl).getCheckBoxNotAssigned().setToolTipText(checkBoxNotAssignedTooltip);
                } else if (variable.isTime()) {
                    itemControl = new StiValueDateTimeItemControl(variable, report);
                } else if (variable.getType() == StiSystemTypeEnum.SystemDrawingImage || variable.getType() == StiSystemTypeEnum.SystemDrawingBitmap) {
                    itemControl = new StiValueImageItemControl(variable, report);
                    ((StiValueImageItemControl)itemControl).getCheckBoxNotAssigned().setToolTipText(checkBoxNotAssignedTooltip);
                } else if (variable.getType() == StiSystemTypeEnum.SystemChar) {
                    itemControl = new StiValueCharItemControl(variable);
                    ((StiValueCharItemControl)itemControl).getCheckBoxNotAssigned().setToolTipText(checkBoxNotAssignedTooltip);
                } else if (variable.isDecimal()) {
                    itemControl = new StiValueDoubleItemControl(variable);
                    ((StiValueDoubleItemControl)itemControl).getCheckBoxNotAssigned().setToolTipText(checkBoxNotAssignedTooltip);
                } else if (variable.getType() == StiSystemTypeEnum.SystemGuid) {
                    itemControl = new StiValueGuidItemControl(variable);
                    ((StiValueGuidItemControl)itemControl).getCheckBoxNotAssigned().setToolTipText(checkBoxNotAssignedTooltip);
                } else if (variable.getType() == StiSystemTypeEnum.SystemString) {
                    itemControl = new StiValueStringItemControl(variable, this.viewerPanel.getParentFrame());
                } else {
                    itemControl = new StiValueLongItemControl(variable);
                    ((StiValueLongItemControl)itemControl).getCheckBoxNotAssigned().setToolTipText(checkBoxNotAssignedTooltip);
                }
            }
            if (lbVariable == null || itemControl == null) continue;
            this.controlVariables.put(variable.getName(), itemControl);
            requestFromUserLabels.add(lbVariable);
            requestFromUserComponents.put(lbVariable, itemControl);
        }
        StiRequestPanel bottomPanel = new StiRequestPanel(null);
        bottomPanel.setBackground(StiViewerFx.BACKGROUND_COLOR);
        StiRequestPanel controlsPanel = new StiRequestPanel(null);
        controlsPanel.setBackground(StiViewerFx.BACKGROUND_COLOR);
        controlsPanel.setHeight(100);
        JButton btSubmit = new JButton();
        btSubmit.setText(StiLocalization.getValue((String)"Buttons", (String)"Submit"));
        btSubmit.setSize(75, 23);
        btSubmit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiViewerControlsDialog.this.btSubmitClick();
            }
        });
        JButton btReset = new JButton();
        btReset.setText(StiLocalization.getHingValue((String)"Wizards", (String)"Reset"));
        btReset.setSize(75, 23);
        btReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiViewerControlsDialog.this.showDialogRequestFromUserVariables(true);
            }
        });
        bottomPanel.add(btSubmit);
        bottomPanel.add(btReset);
        this.panelDialogs.add(controlsPanel);
        this.panelDialogs.add(bottomPanel);
        int rightPosition = 0;
        JPanel centerBorderPanel = this.viewerPanel.getCenterBorderPanel();
        centerBorderPanel.remove(this.panelDialogs);
        if (report.getParametersOrientation() == StiOrientation.Horizontal) {
            if (requestFromUserComponents.size() > StiOptions.Viewer.getRequestFromUserElementsPerColumn()) {
                int bottom = 0;
                Point point = this.placeComponentsByColumn(controlsPanel, requestFromUserLabels, requestFromUserComponents, bottom);
                rightPosition = (int)point.getX();
                bottom = (int)point.getY();
                this.panelDialogs.setHeight(bottom + 30);
            } else {
                rightPosition = this.placeComponentsOfOneColumn(controlsPanel, requestFromUserLabels, requestFromUserComponents);
            }
            centerBorderPanel.add((Component)this.panelDialogs, "North");
            bottomPanel.setHeight(30);
            bottomPanel.setMaximumSize(new Dimension(10000, 30));
            bottomPanel.setPreferredSize(new Dimension(10000, 30));
        } else {
            rightPosition = this.placeComponentsOfOneColumn(controlsPanel, requestFromUserLabels, requestFromUserComponents);
            this.panelDialogs.setWidth(rightPosition + 20);
            centerBorderPanel.add((Component)this.panelDialogs, "West");
            bottomPanel.setHeight(30);
            bottomPanel.setMaximumSize(new Dimension(10000, 30));
            bottomPanel.setPreferredSize(new Dimension(10000, 30));
        }
        requestFromUserComponents.get(requestFromUserLabels.get(0)).requestFocus();
        if (this.panelDialogs.getWidth() < 310) {
            this.panelDialogs.setWidth(310);
        }
        btSubmit.setLocation(rightPosition - 78, 3);
        btReset.setLocation(rightPosition - 156, 3);
        if (btReset.getLocation().getX() < 0.0) {
            btReset.setLocation(3, (int)btReset.getLocation().getY());
            btSubmit.setLocation((int)btReset.getLocation().getX() + btReset.getWidth() + 5, btSubmit.getLocation().y);
        }
        requestFromUserComponents = null;
        requestFromUserLabels = null;
        this.panelDialogs.setPreferredSize(this.panelDialogs.getSize());
        this.panelDialogs.revalidate();
    }

    private void btSubmitClick() {
        try {
            final StiReport report = this.getCurrentReport();
            if (report != null) {
                this.checkVariables();
                StiSimpleWorker renderWorker = new StiSimpleWorker(){

                    public void doInBackground() {
                        report.setPreviewDialogs(true);
                        report.isStopped = false;
                        report.Render();
                        report.setPreviewDialogs(false);
                        StiDocument document = new StiDocument(StiViewerControlsDialog.this.getCurrentReport());
                        StiViewerControlsDialog.this.model.getEventDispatcher().dispatchStiEvent(new StiViewCommonEvent("DocumentFileLoaded", document, false));
                    }
                };
                renderWorker.execute();
            }
        }
        catch (Throwable t) {
            StiExceptionProvider.show((Throwable)t, null);
        }
    }

    private void onRequestFromUserButtonClick() {
    }

    private void checkVariables() {
        if (this.controlVariables == null) {
            return;
        }
        StiReport currentReport = this.getCurrentReport();
        for (String name : this.controlVariables.keySet()) {
            StiVariable variable = currentReport.getDictionary().getVariables().get(name);
            if (variable.isRange()) {
                if (!(this.controlVariables.get(name) instanceof IStiRangeItemControl)) continue;
                IStiRangeItemControl rangeItemControl = (IStiRangeItemControl)((Object)this.controlVariables.get(name));
                Range rangeResult = rangeItemControl.getValue();
                currentReport.getDictionary().getVariables().get(name).setValue(rangeResult != null ? rangeResult.serialize() : null);
                if (rangeResult != null) {
                    currentReport.getVariables().put(name, (Object)rangeResult);
                    continue;
                }
                currentReport.getVariables().remove((Object)name);
                continue;
            }
            if (this.controlVariables.get(name) instanceof StiListButtonXControl) {
                StiListButtonXControl buttonXControl = (StiListButtonXControl)this.controlVariables.get(name);
                ArrayList<String> buttonResult = buttonXControl.getResult();
                currentReport.getDictionary().getVariables().get(name).getDialogInfo().setKeys(buttonResult);
                currentReport.getDictionary().getVariables().get(name).getDialogInfo().setValues(buttonResult);
                currentReport.getVariables().put(name, buttonResult);
                continue;
            }
            if (!(this.controlVariables.get(name) instanceof IStiValueItemControl)) continue;
            IStiValueItemControl itemControl = (IStiValueItemControl)((Object)this.controlVariables.get(name));
            Object value = itemControl.getValue();
            currentReport.getDictionary().getVariables().get(name).setValue(value);
            currentReport.getVariables().put(name, value);
        }
    }

    private StiReport getCurrentReport() {
        return this.model == null || this.model.getReport() == null ? null : (this.model.getReport().getCompiledReport() != null ? this.model.getReport().getCompiledReport() : this.model.getReport());
    }

    private void clearDialogs() {
        this.panelDialogs.removeAll();
        JPanel centerBorderPanel = this.viewerPanel.getCenterBorderPanel();
        centerBorderPanel.remove(this.panelDialogs);
    }

    private String getNameVariable(StiVariable variable) {
        if (StiStringUtil.stringsEquals((String)variable.getName(), (String)variable.getAlias())) {
            return variable.getName();
        }
        if (!StiValidationUtil.isNullOrEmpty((String)variable.getAlias())) {
            return variable.getAlias();
        }
        return variable.getName();
    }

    private Point placeComponentsByColumn(JPanel panel, List<StiRequestLabel> labels, Hashtable<StiRequestLabel, JComponent> controls, int bottom) {
        int[] indexes = new int[2];
        indexes[0] = indexes[1] = labels.size() / 2;
        if (labels.size() % 2 > 0) {
            indexes[0] = indexes[0] + 1;
        }
        int indexElement = 0;
        int xPos = 0;
        int right = 0;
        for (int index = 0; index < 2; ++index) {
            JLabel label;
            int index1;
            xPos = right;
            int yPos = 3;
            int lastIndex = indexElement;
            int maxLabelWidth = 0;
            for (index1 = 0; index1 < indexes[index] && indexElement < labels.size(); ++indexElement, ++index1) {
                label = labels.get(indexElement);
                panel.add(label);
                if (label.getWidth() <= maxLabelWidth) continue;
                maxLabelWidth = label.getWidth();
            }
            maxLabelWidth += 5;
            indexElement = lastIndex;
            for (index1 = 0; index1 < indexes[index] && indexElement < labels.size(); ++indexElement, ++index1) {
                label = labels.get(indexElement);
                JComponent control = controls.get(label);
                label.setLocation(xPos, yPos + 4);
                control.setLocation(xPos + maxLabelWidth, yPos);
                panel.add(control);
                if (control.getY() + control.getHeight() > bottom) {
                    bottom = control.getY() + control.getHeight();
                }
                if (control.getX() + control.getWidth() > right) {
                    right = control.getX() + control.getWidth();
                }
                yPos += control.getHeight() + 4;
            }
            right += 10;
        }
        return new Point(5, bottom += 5);
    }

    private int placeComponentsOfOneColumn(StiRequestPanel panel, List<StiRequestLabel> labels, Hashtable<StiRequestLabel, JComponent> controls) {
        int yPos = 3;
        int maxLabelWidth = 0;
        int rightPosition = 0;
        for (JLabel jLabel : labels) {
            panel.add(jLabel);
            if (jLabel.getWidth() <= maxLabelWidth) continue;
            maxLabelWidth = jLabel.getWidth();
        }
        maxLabelWidth += 18;
        for (StiRequestLabel stiRequestLabel : labels) {
            JComponent itemControl = controls.get(stiRequestLabel);
            itemControl.setLocation(maxLabelWidth, yPos);
            panel.add(itemControl);
            stiRequestLabel.setLocation(3, yPos + (itemControl.getHeight() - stiRequestLabel.getHeight()) / 2 - 2);
            yPos += itemControl.getHeight() + 3;
            if (itemControl.getX() + itemControl.getWidth() <= rightPosition) continue;
            rightPosition = itemControl.getX() + itemControl.getWidth();
        }
        this.panelDialogs.setHeight(yPos + 30);
        return rightPosition + 1;
    }
}

