/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.viewer.panels;

import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.viewer.visual.StiVisual;
import com.stimulsoft.viewer.StiViewerFx;
import com.stimulsoft.viewer.controls.mouse.StiCursorManager;
import com.stimulsoft.viewer.controls.visual.StiThumbPageVisual;
import com.stimulsoft.viewer.events.StiViewEventable;
import com.stimulsoft.viewer.events.StiViewerEventDispatcher;
import com.stimulsoft.viewer.logic.StiViewModel;
import com.stimulsoft.viewer.utils.StiNavigateButtonsProcessor;
import com.stimulsoft.viewer.view.StiView;
import java.awt.Dimension;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;

public class StiThumbnailsPannel
extends JScrollPane
implements StiViewEventable,
MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = -4577402800123183888L;
    public static final Dimension MINIMUM_DIMENSION = new Dimension(100, 100);
    public static final Dimension DEFAULT_DIMENSION = new Dimension(180, 100);
    private static final int distanceBetweenPagesVert = 5;
    private static final int distanceFromLeft = 10;
    private static final int distanceFromRight = 10;
    private static final int distanceFromTop = 10;
    private static final int distanceFromBottom = 10;
    private StiView view;
    private Boolean isHandModeActivated = false;
    private Boolean isLeftMouseButtonPressed = false;
    private StiPoint lastMousePosition = new StiPoint();
    private Boolean clearAllVisual = false;
    private StiViewerEventDispatcher eventDispatcher = new StiViewerEventDispatcher();
    private StiViewModel stiViewModel;
    private Rectangle componentBounds;
    private int scrolledPage = 0;

    public StiThumbnailsPannel(StiViewModel model) {
        super(new StiView(), 22, 31);
        this.stiViewModel = model;
        this.view = (StiView)this.getViewport().getView();
        this.setMinimumSize(MINIMUM_DIMENSION);
        this.setFocusable(true);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.getVerticalScrollBar().setUnitIncrement(20);
        this.view.setBackground(StiViewerFx.BACKGROUND_COLOR);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                StiThumbnailsPannel.this.onScrollViewerResize();
            }
        });
    }

    public void updateThumbnails() {
        for (StiVisual stiVisual : this.view.getVisuals()) {
            StiThumbPageVisual pageVisual = (StiThumbPageVisual)stiVisual;
            if (pageVisual == null) continue;
            pageVisual.setSelected(this.getCurrentPage() == pageVisual.getPageIndex());
        }
    }

    public void createThumbnails() {
        Integer widthOfThumbnails = this.getViewWidth();
        if (this.getReport() != null && widthOfThumbnails > 0) {
            if (!this.clearAllVisual.booleanValue()) {
                this.clearAllVisual = true;
                this.view.clearVisuals();
            }
            this.clearAllVisual = false;
            int visualWidth = widthOfThumbnails - 10 - 10;
            int visualHeight = Math.round((float)visualWidth * 1.3f);
            Integer posY = 10;
            Integer pageIndex = 0;
            for (StiPage page : this.getReport().getRenderedPages()) {
                StiThumbPageVisual pageVisual = new StiThumbPageVisual(this, this.stiViewModel);
                pageVisual.setPageIndex(pageIndex);
                pageVisual.setSelected(this.getCurrentPage() == pageIndex);
                pageVisual.setBounds(this.getViewWidth() / 2 - visualWidth / 2, posY, visualWidth, visualHeight);
                pageVisual.setDestLeft(Math.round((widthOfThumbnails - visualWidth) / 2));
                pageVisual.setDestTop(posY);
                pageVisual.setDestWidth(visualWidth);
                pageVisual.setDestHeight(visualHeight);
                pageVisual.setPage(page);
                this.view.addVisual(pageVisual);
                posY = posY + (visualHeight + 5);
                Integer n = pageIndex;
                Integer n2 = pageIndex = Integer.valueOf(pageIndex + 1);
            }
            posY = posY + 5;
            this.view.updateSize(0, posY < this.getViewHeight() ? this.getViewHeight() : posY);
        }
        this.componentBounds = this.getBounds();
    }

    public void scrollToCurrentPage() {
        this.scrollToPage(this.getCurrentPage(), false);
    }

    public void scrollToPage(int pageNumber, boolean select) {
        StiThumbPageVisual pageVisual = (StiThumbPageVisual)this.view.getPageVisualFromIndex(pageNumber);
        if (pageVisual == null) {
            return;
        }
        if (select) {
            ((StiThumbPageVisual)this.view.getVisuals().get(this.scrolledPage)).setSelected(false);
        }
        this.scrollToRect(new StiRectangle((long)pageVisual.getDestLeft().intValue(), (long)pageVisual.getDestTop().intValue(), (long)pageVisual.getDestWidth().intValue(), (long)pageVisual.getDestHeight().intValue()));
        this.scrolledPage = pageNumber;
        if (select) {
            pageVisual.setSelected(true);
        }
    }

    private void scrollToRect(StiRectangle rect) {
        Double toX = 0.0;
        Double toY = 0.0;
        toX = (double)this.getViewWidth().intValue() < rect.getWidth() ? Double.valueOf(rect.getX() - 10.0) : Double.valueOf(rect.getX() - ((double)this.getViewWidth().intValue() - rect.getWidth()) / 2.0);
        toY = (double)this.getViewHeight().intValue() < rect.getHeight() ? Double.valueOf(rect.getY() - 10.0) : Double.valueOf(rect.getY() - ((double)this.getViewHeight().intValue() - rect.getHeight()) / 2.0);
        this.getVerticalScrollBar().setValue(toY.intValue());
        this.getHorizontalScrollBar().setValue(toX.intValue());
    }

    public void clearAll() {
        this.view.clearVisuals();
    }

    private void onViewMouseDown(MouseEvent event) {
        if (event.getButton() == 1) {
            this.lastMousePosition = new StiPoint(MouseInfo.getPointerInfo().getLocation().getX(), MouseInfo.getPointerInfo().getLocation().getY());
            this.isLeftMouseButtonPressed = true;
        }
    }

    private void onViewMouseMove(MouseEvent event) {
        Point point = this.getMousePosition();
        if (point == null) {
            return;
        }
        StiPoint cursorPosition = new StiPoint(MouseInfo.getPointerInfo().getLocation().getX(), MouseInfo.getPointerInfo().getLocation().getY());
        if (this.isLeftMouseButtonPressed.booleanValue() && !this.isHandModeActivated.booleanValue()) {
            Double dx = Math.abs(this.lastMousePosition.x - cursorPosition.x);
            Double dy = Math.abs(this.lastMousePosition.y - cursorPosition.y);
            Double length = Math.sqrt(dx * dx + dy * dy);
            if (length > 10.0) {
                this.isHandModeActivated = true;
            }
        }
        if (this.getReport() != null && !this.lastMousePosition.equals((Object)cursorPosition) && this.isHandModeActivated.booleanValue()) {
            StiCursorManager.setDraggingHand(this);
            Integer moveX = new Double(this.lastMousePosition.x - cursorPosition.x).intValue();
            Integer moveY = new Double(this.lastMousePosition.y - cursorPosition.y).intValue();
            this.getHorizontalScrollBar().setValue(this.getHorizontalScrollBar().getValue() + moveX);
            this.getVerticalScrollBar().setValue(this.getVerticalScrollBar().getValue() + moveY);
            this.lastMousePosition = cursorPosition;
            this.updateThumbnails();
        }
    }

    private void onViewMouseUp(MouseEvent event) {
        if (this.isHandModeActivated.booleanValue()) {
            this.onViewMouseMove(event);
            this.isHandModeActivated = false;
        } else if (this.isLeftMouseButtonPressed.booleanValue()) {
            // empty if block
        }
        StiCursorManager.setDefaultCursor(this);
        this.isLeftMouseButtonPressed = false;
    }

    public void onScrollViewerResize() {
        if (this.stiViewModel != null && this.stiViewModel.getDocument() != null) {
            if (this.componentBounds == null || this.componentBounds.getWidth() != this.getBounds().getWidth()) {
                this.createThumbnails();
            }
            this.updateThumbnails();
            this.scrollToCurrentPage();
        }
    }

    @Override
    public Dimension getMinimumSize() {
        if (new Throwable().fillInStackTrace().getStackTrace()[1].getClassName().startsWith("javax.swing.plaf.basic.BasicSplitPaneDivider")) {
            return MINIMUM_DIMENSION;
        }
        return this.getBounds().getWidth() < (double)StiThumbnailsPannel.MINIMUM_DIMENSION.width ? MINIMUM_DIMENSION : this.getBounds().getSize();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.onViewMouseDown(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        StiNavigateButtonsProcessor.changeFocus(1);
        this.onViewMouseUp(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.onViewMouseMove(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public StiViewerEventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    public StiViewModel getStiViewModel() {
        return this.stiViewModel;
    }

    public void setStiViewModel(StiViewModel value) {
        this.stiViewModel = value;
    }

    public StiReport getReport() {
        return this.stiViewModel.getDocument().getReport();
    }

    public Integer getCurrentPage() {
        return this.stiViewModel.getCurrentPage();
    }

    public Integer getViewHeight() {
        return this.getBounds().height;
    }

    public Integer getViewWidth() {
        return this.getBounds().width - this.getVerticalScrollBar().getWidth() - 4;
    }

    public int getScrolledPage() {
        return this.scrolledPage;
    }
}

