/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.viewer.panels;

import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.utils.StiResourceUtil;
import com.stimulsoft.viewer.controls.visual.StiFlatButton;
import com.stimulsoft.viewer.events.StiViewCommonEvent;
import com.stimulsoft.viewer.events.StiViewEventable;
import com.stimulsoft.viewer.events.StiViewerEventDispatcher;
import com.stimulsoft.viewer.form.StiGoToPageDialog;
import com.stimulsoft.viewer.logic.StiViewModel;
import com.stimulsoft.viewer.utils.StiTooltipUtil;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JFrame;
import javax.swing.JToolBar;

public class StiNavigateToolBar
extends JToolBar
implements StiViewEventable {
    private static final long serialVersionUID = -2811804664741382826L;
    private StiFlatButton buttonPageFirst;
    private StiFlatButton buttonPagePrev;
    private StiFlatButton buttonGoToPage;
    private StiFlatButton buttonPageNext;
    private StiFlatButton buttonPageLast;
    private StiViewerEventDispatcher eventDispatcher = new StiViewerEventDispatcher();
    private StiViewModel model;
    private JFrame parentFrame;
    private String pageOf;

    public StiNavigateToolBar(StiViewModel model, JFrame parentFrame) {
        this.model = model;
        this.parentFrame = parentFrame;
        this.setFloatable(false);
        this.buildComponent();
        this.setMaximumSize(new Dimension(10000, 30));
        this.bindEvents();
        this.enableControls(false);
    }

    private void buildComponent() {
        String url = "http://www.stimulsoft.com/en/documentation/online/user-manual/index.html?viewing_reports_page_navigation.htm";
        this.buttonPageFirst = new StiFlatButton(null, StiResourceUtil.loadIcon((String)"/icons/PageFirst.png"), StiTooltipUtil.formatTooltip("FirstPage", "PageFirst", ""), url);
        this.add(this.buttonPageFirst);
        this.buttonPagePrev = new StiFlatButton(null, StiResourceUtil.loadIcon((String)"/icons/PagePrevious.png"), StiTooltipUtil.formatTooltip("PrevPage", "PagePrevious", ""), url);
        this.add(this.buttonPagePrev);
        this.addSeparator();
        this.pageOf = StiLocalization.getFormatValue((String)"FormViewer", (String)"PageNofM");
        this.buttonGoToPage = new StiFlatButton(String.format(this.pageOf, 0, 0), null, StiTooltipUtil.formatTooltip("PageGoTo", "PageGoTo", "(Ctrl + G)"), 71, 128, url);
        this.add(this.buttonGoToPage);
        this.addSeparator();
        this.buttonPageNext = new StiFlatButton(null, StiResourceUtil.loadIcon((String)"/icons/PageNext.png"), StiTooltipUtil.formatTooltip("NextPage", "PageNext", ""), url);
        this.add(this.buttonPageNext);
        this.buttonPageLast = new StiFlatButton(null, StiResourceUtil.loadIcon((String)"/icons/PageLast.png"), StiTooltipUtil.formatTooltip("LastPage", "PageLast", ""), url);
        this.add(this.buttonPageLast);
    }

    private void bindEvents() {
        this.buttonPageFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StiNavigateToolBar.this.getModel().getDocument() != null && StiNavigateToolBar.this.getModel().getCurrentDisplayPage() != 1) {
                    StiNavigateToolBar.this.changePage(1);
                }
            }
        });
        this.buttonPagePrev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StiNavigateToolBar.this.getModel().getDocument() != null && StiNavigateToolBar.this.getModel().getCurrentDisplayPage() != 1) {
                    StiNavigateToolBar.this.changePage(StiNavigateToolBar.this.getModel().getCurrentDisplayPage() - 1);
                }
            }
        });
        this.buttonPageNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StiNavigateToolBar.this.getModel().getDocument() != null && StiNavigateToolBar.this.getModel().getCurrentDisplayPage() < StiNavigateToolBar.this.getModel().getDisplayPagesCount()) {
                    StiNavigateToolBar.this.changePage(StiNavigateToolBar.this.getModel().getCurrentDisplayPage() + 1);
                }
            }
        });
        this.buttonPageLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StiNavigateToolBar.this.getModel().getDocument() != null && StiNavigateToolBar.this.getModel().getCurrentDisplayPage() < StiNavigateToolBar.this.getModel().getDisplayPagesCount()) {
                    StiNavigateToolBar.this.changePage(StiNavigateToolBar.this.getModel().getDisplayPagesCount());
                }
            }
        });
        this.buttonGoToPage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiGoToPageDialog stiGoToPageDialog = new StiGoToPageDialog(StiNavigateToolBar.this.getModel(), StiNavigateToolBar.this.getThis(), StiNavigateToolBar.this.parentFrame);
                stiGoToPageDialog.setVisible(true);
            }
        });
        this.model.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("currentDisplayPage") || evt.getPropertyName().equals("document")) {
                    StiNavigateToolBar.this.buttonGoToPage.setText(String.format(StiNavigateToolBar.this.pageOf, StiNavigateToolBar.this.getModel().getCurrentDisplayPage(), StiNavigateToolBar.this.getModel().getDisplayPagesCount()));
                }
            }
        });
        this.model.addPropertyChangeListener("document", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                StiNavigateToolBar.this.enableControls(evt.getNewValue() != null);
            }
        });
    }

    private StiNavigateToolBar getThis() {
        return this;
    }

    private void enableControls(Boolean enabled) {
        this.buttonPageFirst.setEnabled(enabled);
        this.buttonPagePrev.setEnabled(enabled);
        this.buttonGoToPage.setEnabled(enabled);
        this.buttonPageNext.setEnabled(enabled);
        this.buttonPageLast.setEnabled(enabled);
    }

    private void changePage(Integer pageIndex) {
        this.eventDispatcher.dispatchStiEvent(new StiViewCommonEvent("CurrentDisplayPageChanged", pageIndex));
    }

    @Override
    public StiViewerEventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    private StiViewModel getModel() {
        return this.model;
    }
}

