/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.viewer.form.export;

import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.settings.StiSettings;
import com.stimulsoft.base.utils.StiCharsetHelper;
import com.stimulsoft.report.export.settings.StiExportSettings;
import com.stimulsoft.report.export.settings.StiTxtExportSettings;
import com.stimulsoft.report.export.tools.StiTxtBorderType;
import com.stimulsoft.viewer.controls.visual.StiLabel;
import com.stimulsoft.viewer.form.export.StiBaseExportDialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class StiTxtExportDialog
extends StiBaseExportDialog {
    private static final long serialVersionUID = 8504451915597681783L;
    protected JCheckBox killSpaceLinesCheckBox;
    protected JCheckBox putFeedPageCheckBox;
    protected JCheckBox drawBorderCheckBox;
    protected JCheckBox cutLongLinesCheckBox;
    protected JRadioButton simpleRadio;
    protected JRadioButton unicodeSingledRadio;
    protected JRadioButton unicodeDoubleRadio;
    protected JComboBox zoomXComboBox;
    protected JComboBox zoomYComboBox;
    protected JComboBox encodingComboBox;

    private StiTxtExportDialog(JFrame parent, Boolean sendEmail, int curretPage) throws HeadlessException {
        super(parent, sendEmail, curretPage);
    }

    public static StiExportSettings showDialog(JFrame parent, Boolean sendEmail, int curretPage) {
        StiTxtExportDialog dialog = new StiTxtExportDialog(parent, sendEmail, curretPage);
        dialog.setVisible(true);
        return dialog.okResult ? dialog.getExportSettings() : null;
    }

    @Override
    protected void buildComponent() {
        super.buildComponent();
        this.killSpaceLinesCheckBox = new JCheckBox(StiLocalization.getValue((String)"Export", (String)"TxtKillSpaceLines"));
        this.addC(this.addInfo(this.killSpaceLinesCheckBox, "KillSpaceLines"), 0, 0, 1, 0.5, -1);
        this.putFeedPageCheckBox = new JCheckBox(StiLocalization.getValue((String)"Export", (String)"TxtPutFeedPageCode"));
        this.addC(this.addInfo(this.putFeedPageCheckBox, "PutFeedPageCode"), 0, 1, 1, 0.5, -1);
        this.drawBorderCheckBox = new JCheckBox(StiLocalization.getValue((String)"Export", (String)"TxtDrawBorder"));
        this.addC(this.addInfo(this.drawBorderCheckBox, "DrawBorder"), 0, 2, 1, 0.5, -1);
        this.cutLongLinesCheckBox = new JCheckBox(StiLocalization.getValue((String)"Export", (String)"TxtCutLongLines"));
        this.addC(this.addInfo(this.cutLongLinesCheckBox, "CutLongLines"), 0, 3, 1, 0.5, -1);
        Border radioBorder = BorderFactory.createEmptyBorder(-5, -5, 0, 0);
        JPanel borderTypePanel = new JPanel();
        borderTypePanel.setLayout(new BoxLayout(borderTypePanel, 1));
        borderTypePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), StiLocalization.getValue((String)"Export", (String)"TxtBorderType")));
        JPanel simplePanel = new JPanel(new FlowLayout(0));
        this.simpleRadio = new JRadioButton(StiLocalization.getValue((String)"Export", (String)"TxtBorderTypeSimple"));
        simplePanel.add(this.addInfo(this.simpleRadio, "BorderType"));
        JPanel unicodeSingledPanel = new JPanel(new FlowLayout(0));
        this.unicodeSingledRadio = new JRadioButton(StiLocalization.getValue((String)"Export", (String)"TxtBorderTypeSingle"));
        unicodeSingledPanel.add(this.addInfo(this.unicodeSingledRadio, "BorderType"));
        JPanel unicodeDoublePanel = new JPanel(new FlowLayout(0));
        this.unicodeDoubleRadio = new JRadioButton(StiLocalization.getValue((String)"Export", (String)"TxtBorderTypeDouble"));
        unicodeDoublePanel.add(this.addInfo(this.unicodeDoubleRadio, "BorderType"));
        this.simpleRadio.setSelected(true);
        ButtonGroup group = new ButtonGroup();
        group.add(this.simpleRadio);
        group.add(this.unicodeSingledRadio);
        group.add(this.unicodeDoubleRadio);
        simplePanel.setBorder(radioBorder);
        unicodeSingledPanel.setBorder(radioBorder);
        unicodeDoublePanel.setBorder(radioBorder);
        borderTypePanel.add(simplePanel);
        borderTypePanel.add(unicodeSingledPanel);
        borderTypePanel.add(unicodeDoublePanel);
        Dimension ppDimension = new Dimension(165, 115);
        JPanel zoomPanel = new JPanel();
        zoomPanel.setLayout(new BoxLayout(zoomPanel, 1));
        zoomPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), StiLocalization.getValue((String)"Export", (String)"Zoom").replaceAll(":", "")));
        JPanel xPanel = this.createXPanel(BorderFactory.createEmptyBorder(5, 0, 9, 10));
        StiLabel xLabel = new StiLabel(StiLocalization.getValue((String)"Export", (String)"X"));
        xPanel.add(this.addInfo(xLabel, "ZoomTxt"));
        this.zoomXComboBox = new JComboBox<String>(ZOOM_VALUES);
        xPanel.add(this.zoomXComboBox);
        this.zoomXComboBox.setEditable(true);
        this.zoomXComboBox.setMaximumSize(new Dimension(75, 22));
        this.zoomXComboBox.setPreferredSize(new Dimension(75, 22));
        this.zoomXComboBox.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        JPanel yPanel = this.createXPanel(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        StiLabel yLabel = new StiLabel(StiLocalization.getValue((String)"Export", (String)"Y"));
        yPanel.add(this.addInfo(yLabel, "ZoomTxt"));
        this.zoomYComboBox = new JComboBox<String>(ZOOM_VALUES);
        yPanel.add(this.zoomYComboBox);
        this.zoomYComboBox.setEditable(true);
        this.zoomYComboBox.setEditable(true);
        this.zoomYComboBox.setMaximumSize(new Dimension(75, 22));
        this.zoomYComboBox.setPreferredSize(new Dimension(75, 22));
        this.zoomYComboBox.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        zoomPanel.add(xPanel);
        zoomPanel.add(yPanel);
        zoomPanel.setPreferredSize(ppDimension);
        borderTypePanel.setPreferredSize(ppDimension);
        JPanel bzPanel = new JPanel(new FlowLayout(1));
        bzPanel.add(borderTypePanel);
        bzPanel.add(zoomPanel);
        this.addC(bzPanel, 0, 4, 2);
        this.addC(this.addInfo(new StiLabel(StiLocalization.getValue((String)"Export", (String)"Encoding")), "Encoding"), 0, 5, 1);
        this.encodingComboBox = new JComboBox<String>(StiCharsetHelper.CHARSET_NAMES);
        this.addC(this.encodingComboBox, 1, 5, 1, 0.5);
        this.encodingComboBox.setSelectedIndex(0);
        this.expandPanel.setWidth(360);
        this.expandPanel.setExpandedHeight(310);
        this.bindEvents();
        this.loadSettings();
    }

    protected void bindEvents() {
        this.drawBorderCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean enabled = ((JCheckBox)e.getSource()).isSelected();
                StiTxtExportDialog.this.simpleRadio.setEnabled(enabled);
                StiTxtExportDialog.this.unicodeDoubleRadio.setEnabled(enabled);
                StiTxtExportDialog.this.unicodeSingledRadio.setEnabled(enabled);
            }
        });
    }

    @Override
    protected StiExportSettings getExportSettings() {
        StiTxtExportSettings settings = new StiTxtExportSettings(super.getExportSettings());
        settings.setBorderType(this.simpleRadio.isSelected() ? StiTxtBorderType.Simple : (this.unicodeDoubleRadio.isSelected() ? StiTxtBorderType.UnicodeDouble : StiTxtBorderType.UnicodeSingle));
        settings.setCutLongLines(this.cutLongLinesCheckBox.isSelected());
        settings.setDrawBorder(this.drawBorderCheckBox.isSelected());
        settings.setKillSpaceLines(this.killSpaceLinesCheckBox.isSelected());
        settings.setPutFeedPageCode(this.putFeedPageCheckBox.isSelected());
        settings.setEncoding(StiCharsetHelper.getCharsetFromName((String)((String)this.encodingComboBox.getItemAt(this.encodingComboBox.getSelectedIndex()))));
        float zoomX = 100.0f;
        try {
            zoomX = Float.parseFloat(((String)this.zoomXComboBox.getSelectedItem()).replaceAll("[^\\d]", ""));
        }
        catch (Exception e) {
            System.out.println("Unable to parse zoom value: " + this.zoomXComboBox.getSelectedItem());
            e.printStackTrace();
        }
        settings.setZoomX(zoomX / 100.0f);
        float zoomY = 100.0f;
        try {
            zoomY = Float.parseFloat(((String)this.zoomYComboBox.getSelectedItem()).replaceAll("[^\\d]", ""));
        }
        catch (Exception e) {
            System.out.println("Unable to parse zoom value: " + this.zoomYComboBox.getSelectedItem());
            e.printStackTrace();
        }
        settings.setZoomY(zoomY / 100.0f);
        return settings;
    }

    private void loadSettings() {
        int yZoom;
        int xZoom = StiSettings.getDoubleValue((String)"Export", (String)"TxtZoomX", (Double)100.0).intValue();
        if (!this.selectStringCombo(this.zoomXComboBox, xZoom + "%")) {
            this.zoomXComboBox.setSelectedItem(String.valueOf(xZoom));
        }
        if (!this.selectStringCombo(this.zoomYComboBox, (yZoom = StiSettings.getDoubleValue((String)"Export", (String)"TxtZoomY", (Double)100.0).intValue()) + "%")) {
            this.zoomYComboBox.setSelectedItem(String.valueOf(yZoom));
        }
        this.killSpaceLinesCheckBox.setSelected(StiSettings.getBoolValue((String)"Export", (String)"TxtKillSpaceLInes", (Boolean)true));
        this.putFeedPageCheckBox.setSelected(StiSettings.getBoolValue((String)"Export", (String)"TxtPutFeedPageCode", (Boolean)true));
        this.drawBorderCheckBox.setSelected(StiSettings.getBoolValue((String)"Export", (String)"TxtDrawBorder", (Boolean)true));
        this.cutLongLinesCheckBox.setSelected(StiSettings.getBoolValue((String)"Export", (String)"TxtCutLongLines", (Boolean)true));
        this.simpleRadio.setSelected(StiSettings.getBoolValue((String)"Export", (String)"TxtBorderSimple", (Boolean)true));
        this.unicodeSingledRadio.setSelected(StiSettings.getBoolValue((String)"Export", (String)"TxtBorderUnicodeSingled", (Boolean)true));
        this.unicodeDoubleRadio.setSelected(StiSettings.getBoolValue((String)"Export", (String)"TxtBorderUnicodeDouble", (Boolean)true));
        this.selectStringCombo(this.encodingComboBox, StiSettings.getStringValue((String)"Export", (String)"TxtEncoding", (String)StiCharsetHelper.CHARSET_NAMES[0]));
        this.expandPanel.setExpanded(StiSettings.getBoolValue((String)"Export", (String)"TxtSettingsPanelExpanded", (Boolean)false));
        this.openAfterExport.setSelected(StiSettings.getBoolValue((String)"Export", (String)"TxtOpenAfterExport", (Boolean)true));
    }

    @Override
    protected void saveSettings() {
        try {
            double zoomX = Double.parseDouble(((String)this.zoomXComboBox.getSelectedItem()).replaceAll("[^\\d]", ""));
            StiSettings.setDoubleValue((String)"Export", (String)"TxtZoomX", (Double)zoomX);
        }
        catch (Exception zoomX) {
            // empty catch block
        }
        try {
            double zoomY = Double.parseDouble(((String)this.zoomYComboBox.getSelectedItem()).replaceAll("[^\\d]", ""));
            StiSettings.setDoubleValue((String)"Export", (String)"TxtZoomY", (Double)zoomY);
        }
        catch (Exception exception) {
            // empty catch block
        }
        StiSettings.setBoolValue((String)"Export", (String)"TxtKillSpaceLInes", (Boolean)this.killSpaceLinesCheckBox.isSelected());
        StiSettings.setBoolValue((String)"Export", (String)"TxtPutFeedPageCode", (Boolean)this.putFeedPageCheckBox.isSelected());
        StiSettings.setBoolValue((String)"Export", (String)"TxtDrawBorder", (Boolean)this.drawBorderCheckBox.isSelected());
        StiSettings.setBoolValue((String)"Export", (String)"TxtCutLongLines", (Boolean)this.cutLongLinesCheckBox.isSelected());
        StiSettings.setBoolValue((String)"Export", (String)"TxtBorderSimple", (Boolean)this.simpleRadio.isSelected());
        StiSettings.setBoolValue((String)"Export", (String)"TxtBorderUnicodeDouble", (Boolean)this.unicodeDoubleRadio.isSelected());
        StiSettings.setBoolValue((String)"Export", (String)"TxtBorderUnicodeSingled", (Boolean)this.unicodeSingledRadio.isSelected());
        StiSettings.setStringValue((String)"Export", (String)"TxtEncoding", (String)((String)this.encodingComboBox.getSelectedItem()));
        StiSettings.setBoolValue((String)"Export", (String)"TxtSettingsPanelExpanded", (Boolean)this.expandPanel.getExpanded());
        StiSettings.setBoolValue((String)"Export", (String)"TxtOpenAfterExport", (Boolean)this.openAfterExport.isSelected());
    }
}

