/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.viewer.form;

import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.viewer.controls.visual.StiFlatButton;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

public class TextEditorDialog
extends JDialog {
    private static final long serialVersionUID = -744024289885320828L;
    private JTextArea textArea;
    private StiFlatButton okButton;
    private StiFlatButton cancelButton;
    private JTextArea textField;

    public TextEditorDialog(JFrame parent, JTextArea textField) throws HeadlessException {
        super(parent, StiLocalization.getValue((String)"FormTitles", (String)"TextEditorForm"), true);
        this.textField = textField;
        this.buildComponent();
        this.bindEvents();
        this.setDefaultCloseOperation(2);
        this.setSize(500, 420);
        this.setResizable(false);
        this.setLocationRelativeTo(parent);
    }

    private void buildComponent() {
        this.setLayout(new BoxLayout(this.getContentPane(), 1));
        this.textArea = new JTextArea();
        this.textArea.setText(this.textField.getText());
        this.textArea.setLocation(0, 0);
        this.textArea.setPreferredSize(new Dimension(200, 122));
        this.add(this.textArea);
        this.add(new JSeparator());
        JPanel bottomPanel = new JPanel(new FlowLayout(2));
        this.okButton = new StiFlatButton(StiLocalization.getHingValue((String)"Buttons", (String)"Ok"));
        bottomPanel.add(this.okButton);
        this.cancelButton = new StiFlatButton(StiLocalization.getHingValue((String)"Buttons", (String)"Cancel"));
        bottomPanel.add(this.cancelButton);
        this.add(bottomPanel);
    }

    private void bindEvents() {
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TextEditorDialog.this.dispose();
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextEditorDialog.this.changeText();
            }
        });
        int c = 2;
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        this.cancelButton.getInputMap(c).put(ks, "hotPress");
        this.cancelButton.getActionMap().put("hotPress", new AbstractAction(){
            private static final long serialVersionUID = 8935120531469858422L;

            @Override
            public void actionPerformed(ActionEvent e) {
                TextEditorDialog.this.dispose();
            }
        });
    }

    private void changeText() {
        this.textField.setText(this.textArea.getText());
        this.dispose();
    }
}

