/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.viewer.controls.visual;

import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.utils.StiResourceUtil;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.options.ViewerOptions;
import com.stimulsoft.viewer.events.StiViewCommonEvent;
import com.stimulsoft.viewer.events.StiViewEventable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class StiExportPopupMenu
extends JPopupMenu {
    private static final long serialVersionUID = 2907009781086599037L;
    private StiViewEventable eventDispatcher;
    private Boolean sendEmail = false;

    public StiExportPopupMenu(StiViewEventable eveventDispatcher) {
        this.eventDispatcher = eveventDispatcher;
        JMenuItem item = new JMenuItem(StiLocalization.getValue((String)"FormViewer", (String)"DocumentFile"), StiResourceUtil.loadIcon((String)"/export/DocumentFile.png"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiExportPopupMenu.this.showExportDialog(StiExportFormat.Document);
            }
        });
        this.add(item);
        this.addSeparator();
        if (ViewerOptions.Windows.Exports.getShowPdf()) {
            item = new JMenuItem(StiLocalization.getValue((String)"Export", (String)"ExportTypePdfFile"), StiResourceUtil.loadIcon((String)"/export/Pdf.png"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StiExportPopupMenu.this.showExportDialog(StiExportFormat.Pdf);
                }
            });
            this.add(item);
        }
        if (ViewerOptions.Windows.Exports.getShowXps()) {
            item = new JMenuItem(StiLocalization.getValue((String)"Export", (String)"ExportTypeXpsFile"), StiResourceUtil.loadIcon((String)"/export/Xps.png"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StiExportPopupMenu.this.showExportDialog(StiExportFormat.Xps);
                }
            });
            this.add(item);
        }
        if (ViewerOptions.Windows.Exports.getShowPpt2007()) {
            item = new JMenuItem(StiLocalization.getValue((String)"Export", (String)"ExportTypePpt2007File"), StiResourceUtil.loadIcon((String)"/export/Ppt.png"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StiExportPopupMenu.this.showExportDialog(StiExportFormat.Ppt2007);
                }
            });
            this.add(item);
        }
        if (ViewerOptions.Windows.Exports.getShowPdf() || ViewerOptions.Windows.Exports.getShowXps() || ViewerOptions.Windows.Exports.getShowPpt2007()) {
            this.addSeparator();
        }
        if (ViewerOptions.Windows.Exports.getShowHtml()) {
            item = new JMenuItem(StiLocalization.getValue((String)"Export", (String)"ExportTypeHtmlFile"), StiResourceUtil.loadIcon((String)"/export/Html.png"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StiExportPopupMenu.this.showExportDialog(StiExportFormat.Html);
                }
            });
            this.add(item);
        }
        if (ViewerOptions.Windows.Exports.getShowMht()) {
            item = new JMenuItem(StiLocalization.getValue((String)"Export", (String)"ExportTypeMhtFile"), StiResourceUtil.loadIcon((String)"/export/Mht.png"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StiExportPopupMenu.this.showExportDialog(StiExportFormat.Mht);
                }
            });
            this.add(item);
        }
        if (ViewerOptions.Windows.Exports.getShowHtml() || ViewerOptions.Windows.Exports.getShowMht()) {
            this.addSeparator();
        }
        if (ViewerOptions.Windows.Exports.getShowText()) {
            item = new JMenuItem(StiLocalization.getValue((String)"Export", (String)"ExportTypeTxtFile"), StiResourceUtil.loadIcon((String)"/export/Txt.png"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StiExportPopupMenu.this.showExportDialog(StiExportFormat.Text);
                }
            });
            this.add(item);
        }
        if (ViewerOptions.Windows.Exports.getShowRtf()) {
            item = new JMenuItem(StiLocalization.getValue((String)"Export", (String)"ExportTypeRtfFile"), StiResourceUtil.loadIcon((String)"/export/Rtf.png"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StiExportPopupMenu.this.showExportDialog(StiExportFormat.Rtf);
                }
            });
            this.add(item);
        }
        if (ViewerOptions.Windows.Exports.getShowWord2007()) {
            item = new JMenuItem(StiLocalization.getValue((String)"Export", (String)"ExportTypeWord2007File"), StiResourceUtil.loadIcon((String)"/export/Word.png"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StiExportPopupMenu.this.showExportDialog(StiExportFormat.Word2007);
                }
            });
            this.add(item);
        }
        if (ViewerOptions.Windows.Exports.getShowOdt()) {
            item = new JMenuItem(StiLocalization.getValue((String)"Export", (String)"ExportTypeWriterFile"), StiResourceUtil.loadIcon((String)"/export/Odt.png"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StiExportPopupMenu.this.showExportDialog(StiExportFormat.Odt);
                }
            });
            this.add(item);
        }
        if (ViewerOptions.Windows.Exports.getShowText() || ViewerOptions.Windows.Exports.getShowRtf() || ViewerOptions.Windows.Exports.getShowWord2007() || ViewerOptions.Windows.Exports.getShowOdt()) {
            this.addSeparator();
        }
        if (ViewerOptions.Windows.Exports.getShowExcel() || ViewerOptions.Windows.Exports.getShowExcelXml() || ViewerOptions.Windows.Exports.getShowExcel2007()) {
            item = new JMenuItem(StiLocalization.getValue((String)"Export", (String)"ExportTypeExcelFile"), StiResourceUtil.loadIcon((String)"/export/Excel.png"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StiExportPopupMenu.this.showExportDialog(StiExportFormat.Excel);
                }
            });
            this.add(item);
        }
        if (ViewerOptions.Windows.Exports.getShowOds()) {
            item = new JMenuItem(StiLocalization.getValue((String)"Export", (String)"ExportTypeCalcFile"), StiResourceUtil.loadIcon((String)"/export/Ods.png"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StiExportPopupMenu.this.showExportDialog(StiExportFormat.Ods);
                }
            });
            this.add(item);
        }
        if (ViewerOptions.Windows.Exports.getShowBmp() || ViewerOptions.Windows.Exports.getShowGif() || ViewerOptions.Windows.Exports.getShowJpeg() || ViewerOptions.Windows.Exports.getShowPcx() || ViewerOptions.Windows.Exports.getShowPng() || ViewerOptions.Windows.Exports.getShowTiff() || ViewerOptions.Windows.Exports.getShowMetafile() || ViewerOptions.Windows.Exports.getShowSvg() || ViewerOptions.Windows.Exports.getShowSvgz() || ViewerOptions.Windows.Exports.getShowCsv() || ViewerOptions.Windows.Exports.getShowDbf() || ViewerOptions.Windows.Exports.getShowXml() || ViewerOptions.Windows.Exports.getShowDif() || ViewerOptions.Windows.Exports.getShowSylk()) {
            this.addSeparator();
        }
        if (ViewerOptions.Windows.Exports.getShowCsv() || ViewerOptions.Windows.Exports.getShowDbf() || ViewerOptions.Windows.Exports.getShowXml() || ViewerOptions.Windows.Exports.getShowDif() || ViewerOptions.Windows.Exports.getShowSylk()) {
            item = new JMenuItem(StiLocalization.getValue((String)"Export", (String)"ExportTypeDataFile"), StiResourceUtil.loadIcon((String)"/export/Csv.png"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StiExportPopupMenu.this.showExportDialog(StiExportFormat.Csv);
                }
            });
            this.add(item);
        }
        if (ViewerOptions.Windows.Exports.getShowBmp() || ViewerOptions.Windows.Exports.getShowJpeg() || ViewerOptions.Windows.Exports.getShowPcx() || ViewerOptions.Windows.Exports.getShowPng() || ViewerOptions.Windows.Exports.getShowSvg() || ViewerOptions.Windows.Exports.getShowSvgz()) {
            item = new JMenuItem(StiLocalization.getValue((String)"Export", (String)"ExportTypeImageFile"), StiResourceUtil.loadIcon((String)"/export/Bmp.png"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StiExportPopupMenu.this.showExportDialog(StiExportFormat.ImageJpeg);
                }
            });
            this.add(item);
        }
    }

    public void show(Component invoker, int x, int y, Boolean sendEmail) {
        this.sendEmail = sendEmail;
        super.show(invoker, x, y);
    }

    private void showExportDialog(StiExportFormat format) {
        this.eventDispatcher.getEventDispatcher().dispatchStiEvent(new StiViewCommonEvent("ShowExportDialog", format, this.sendEmail));
    }
}

