/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary.internal;

import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.SpannableStringBuilder;
import android.text.style.ReplacementSpan;
import android.text.style.UnderlineSpan;
import com.squareup.leakcanary.R;

class SquigglySpan
extends ReplacementSpan {
    private final Paint squigglyPaint = new Paint(1);
    private final Path path;
    private final int referenceColor;
    private final float halfStrokeWidth;
    private final float amplitude;
    private final float halfWaveHeight;
    private final float periodDegrees;
    private int width;

    public static void replaceUnderlineSpans(SpannableStringBuilder builder, Resources resources) {
        UnderlineSpan[] underlineSpans;
        for (UnderlineSpan span : underlineSpans = (UnderlineSpan[])builder.getSpans(0, builder.length(), UnderlineSpan.class)) {
            int start = builder.getSpanStart((Object)span);
            int end = builder.getSpanEnd((Object)span);
            builder.removeSpan((Object)span);
            builder.setSpan((Object)new SquigglySpan(resources), start, end, 0);
        }
    }

    SquigglySpan(Resources resources) {
        this.squigglyPaint.setStyle(Paint.Style.STROKE);
        this.squigglyPaint.setColor(resources.getColor(R.color.leak_canary_leak));
        float strokeWidth = resources.getDimensionPixelSize(R.dimen.leak_canary_squiggly_span_stroke_width);
        this.squigglyPaint.setStrokeWidth(strokeWidth);
        this.halfStrokeWidth = strokeWidth / 2.0f;
        this.amplitude = resources.getDimensionPixelSize(R.dimen.leak_canary_squiggly_span_amplitude);
        this.periodDegrees = resources.getDimensionPixelSize(R.dimen.leak_canary_squiggly_span_period_degrees);
        this.path = new Path();
        float waveHeight = 2.0f * this.amplitude + strokeWidth;
        this.halfWaveHeight = waveHeight / 2.0f;
        this.referenceColor = resources.getColor(R.color.leak_canary_reference);
    }

    public int getSize(@NonNull Paint paint, CharSequence text, int start, int end, @Nullable Paint.FontMetricsInt fm) {
        this.width = (int)paint.measureText(text, start, end);
        return this.width;
    }

    public void draw(@NonNull Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, @NonNull Paint paint) {
        SquigglySpan.squigglyHorizontalPath(this.path, x + this.halfStrokeWidth, x + (float)this.width - this.halfStrokeWidth, (float)bottom - this.halfWaveHeight, this.amplitude, this.periodDegrees);
        canvas.drawPath(this.path, this.squigglyPaint);
        paint.setColor(this.referenceColor);
        canvas.drawText(text, start, end, x, (float)y, paint);
    }

    private static void squigglyHorizontalPath(Path path, float left, float right, float centerY, float amplitude, float periodDegrees) {
        path.reset();
        path.moveTo(left, centerY);
        float period = (float)(Math.PI * 2 / (double)periodDegrees);
        for (float x = 0.0f; x <= right - left; x += 1.0f) {
            float y = (float)((double)amplitude * Math.sin(40.0f + period * x) + (double)centerY);
            path.lineTo(left + x, y);
        }
    }
}

