/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary.internal;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import com.squareup.leakcanary.R;

public final class MoreDetailsView
extends View {
    private final Paint iconPaint;
    private boolean opened;

    public MoreDetailsView(Context context, AttributeSet attrs) {
        super(context, attrs);
        Resources resources = this.getResources();
        this.iconPaint = new Paint(1);
        float strokeSize = resources.getDimensionPixelSize(R.dimen.leak_canary_more_stroke_width);
        this.iconPaint.setStrokeWidth(strokeSize);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.leak_canary_MoreDetailsView);
        int plusColor = a.getColor(R.styleable.leak_canary_MoreDetailsView_leak_canary_plus_color, -16777216);
        a.recycle();
        this.iconPaint.setColor(plusColor);
    }

    protected void onDraw(Canvas canvas) {
        int width = this.getWidth();
        int height = this.getHeight();
        int halfHeight = height / 2;
        int halfWidth = width / 2;
        if (this.opened) {
            canvas.drawLine(0.0f, (float)halfHeight, (float)width, (float)halfHeight, this.iconPaint);
        } else {
            canvas.drawLine(0.0f, (float)halfHeight, (float)width, (float)halfHeight, this.iconPaint);
            canvas.drawLine((float)halfWidth, 0.0f, (float)halfWidth, (float)height, this.iconPaint);
        }
    }

    public void setOpened(boolean opened) {
        if (opened != this.opened) {
            this.opened = opened;
            this.invalidate();
        }
    }
}

