/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;

public final class CanaryLog {
    private static volatile Logger logger = new DefaultLogger();

    public static void setLogger(@Nullable Logger logger) {
        CanaryLog.logger = logger;
    }

    public static void d(@NonNull String message, Object ... args) {
        Logger logger = CanaryLog.logger;
        if (logger == null) {
            return;
        }
        logger.d(message, args);
    }

    public static void d(@Nullable Throwable throwable, @NonNull String message, Object ... args) {
        Logger logger = CanaryLog.logger;
        if (logger == null) {
            return;
        }
        logger.d(throwable, message, args);
    }

    private CanaryLog() {
        throw new AssertionError();
    }

    private static class DefaultLogger
    implements Logger {
        DefaultLogger() {
        }

        @Override
        public void d(@NonNull String message, Object ... args) {
            String formatted = String.format(message, args);
            if (formatted.length() < 4000) {
                Log.d((String)"LeakCanary", (String)formatted);
            } else {
                String[] lines;
                for (String line : lines = formatted.split("\n", -1)) {
                    Log.d((String)"LeakCanary", (String)line);
                }
            }
        }

        @Override
        public void d(@Nullable Throwable throwable, @NonNull String message, Object ... args) {
            this.d(String.format(message, args) + '\n' + Log.getStackTraceString((Throwable)throwable), new Object[0]);
        }
    }

    public static interface Logger {
        public void d(@NonNull String var1, Object ... var2);

        public void d(@Nullable Throwable var1, @NonNull String var2, Object ... var3);
    }
}

