/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli.command;

import com.google.common.collect.ImmutableList;
import com.spotify.helios.cli.command.HostResolver;
import com.spotify.helios.cli.command.WildcardJobCommand;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.JobStatus;
import com.spotify.helios.common.protocol.JobUndeployResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.concurrent.ExecutionException;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public class JobUndeployCommand
extends WildcardJobCommand {
    private final Argument hostsArg;
    private final Argument allArg;
    private final Argument forceArg;

    public JobUndeployCommand(Subparser parser) {
        super(parser);
        parser.help("undeploy a job from hosts");
        this.allArg = parser.addArgument(new String[]{"-a", "--all"}).action((ArgumentAction)Arguments.storeTrue()).help("Undeploy from all currently deployed hosts.");
        this.forceArg = parser.addArgument(new String[]{"-f", "--force"}).action((ArgumentAction)Arguments.storeTrue()).help("Force yes. Immediately undeploy job without prompting. Useful together with -a/--all. Please use with care.");
        this.hostsArg = parser.addArgument(new String[]{"hosts"}).nargs("*").help("The hosts to undeploy the job from.");
    }

    @Override
    protected int runWithJobId(Namespace options, HeliosClient client, PrintStream out, boolean json, JobId jobId, BufferedReader stdin) throws ExecutionException, InterruptedException, IOException {
        List hosts;
        boolean all = options.getBoolean(this.allArg.getDest());
        boolean force = options.getBoolean(this.forceArg.getDest());
        if (all) {
            JobStatus status = (JobStatus)client.jobStatus(jobId).get();
            hosts = ImmutableList.copyOf(status.getDeployments().keySet());
            if (hosts.isEmpty()) {
                out.printf("%s is not currently deployed on any hosts.", jobId);
                return 0;
            }
            if (!force) {
                out.printf("This will undeploy %s from %s%n", jobId, hosts);
                out.printf("Do you want to continue? [y/N]%n", new Object[0]);
                int c = System.in.read();
                if (c != 89 && c != 121) {
                    return 1;
                }
            }
        } else {
            hosts = options.getList(this.hostsArg.getDest());
            if (hosts.isEmpty()) {
                out.println("Please either specify a list of hosts or use the -a/--all flag.");
                return 1;
            }
        }
        if (!json) {
            out.printf("Undeploying %s from %s%n", jobId, hosts);
        }
        int code = 0;
        HostResolver resolver = HostResolver.create(client);
        for (String candidateHost : hosts) {
            JobUndeployResponse response;
            String host = resolver.resolveName(candidateHost);
            if (!json) {
                out.printf("%s: ", host);
            }
            if ((response = (JobUndeployResponse)client.undeploy(jobId, host).get()).getStatus() == JobUndeployResponse.Status.OK) {
                if (!json) {
                    out.println("done");
                    continue;
                }
                out.printf(response.toJsonString(), new Object[0]);
                continue;
            }
            if (!json) {
                out.println("failed: " + response);
            } else {
                out.printf(response.toJsonString(), new Object[0]);
            }
            code = -1;
        }
        return code;
    }
}

