/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli.command;

import com.spotify.helios.cli.command.WildcardJobCommand;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.protocol.JobDeleteResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.concurrent.ExecutionException;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public class JobRemoveCommand
extends WildcardJobCommand {
    private final Argument forceArg;

    public JobRemoveCommand(Subparser parser) {
        super(parser);
        parser.help("remove a job");
        this.forceArg = parser.addArgument(new String[]{"--force"}).action((ArgumentAction)Arguments.storeTrue()).help("Force removal.");
    }

    @Override
    protected int runWithJobId(Namespace options, HeliosClient client, PrintStream out, boolean json, JobId jobId, BufferedReader stdin) throws IOException, ExecutionException, InterruptedException {
        boolean force = options.getBoolean(this.forceArg.getDest());
        if (!force) {
            out.printf("This will remove the job %s%n", jobId);
            out.printf("Do you want to continue? [y/N]%n", new Object[0]);
            String line = stdin.readLine().trim();
            if (line.length() < 1) {
                return 1;
            }
            char c = line.charAt(0);
            if (c != 'Y' && c != 'y') {
                return 1;
            }
        }
        out.printf("Removing job %s%n", jobId);
        int code = 0;
        JobDeleteResponse response = (JobDeleteResponse)client.deleteJob(jobId).get();
        out.printf("%s: ", jobId);
        if (response.getStatus() == JobDeleteResponse.Status.OK) {
            out.printf("done%n", new Object[0]);
        } else {
            out.printf("failed: %s%n", response);
            code = 1;
        }
        return code;
    }
}

