/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli.command;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import com.spotify.helios.cli.Output;
import com.spotify.helios.cli.Table;
import com.spotify.helios.cli.command.ControlCommand;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.Json;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.JobStatus;
import java.io.BufferedReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public class JobListCommand
extends ControlCommand {
    private final Argument quietArg;
    private final Argument patternArg;
    private final Argument fullArg;

    public JobListCommand(Subparser parser) {
        super(parser);
        parser.help("list jobs");
        this.patternArg = parser.addArgument(new String[]{"pattern"}).nargs("?").help("Job reference to filter on");
        this.fullArg = parser.addArgument(new String[]{"-f"}).action((ArgumentAction)Arguments.storeTrue()).help("Print full job id's.");
        this.quietArg = parser.addArgument(new String[]{"-q"}).action((ArgumentAction)Arguments.storeTrue()).help("only print job id's");
    }

    @Override
    int run(Namespace options, HeliosClient client, PrintStream out, boolean json, BufferedReader stdin) throws ExecutionException, InterruptedException {
        boolean full = options.getBoolean(this.fullArg.getDest());
        boolean quiet = options.getBoolean(this.quietArg.getDest());
        String pattern = options.getString(this.patternArg.getDest());
        Map jobs = pattern == null ? (Map)client.jobs().get() : (Map)client.jobs(pattern).get();
        if (!Strings.isNullOrEmpty((String)pattern) && jobs.isEmpty()) {
            if (json) {
                out.println(Json.asPrettyStringUnchecked((Object)jobs));
            } else if (!quiet) {
                out.printf("job pattern %s matched no jobs%n", pattern);
            }
            return 1;
        }
        TreeSet sortedJobIds = Sets.newTreeSet(jobs.keySet());
        if (json) {
            if (quiet) {
                out.println(Json.asPrettyStringUnchecked((Object)sortedJobIds));
            } else {
                out.println(Json.asPrettyStringUnchecked((Object)jobs));
            }
        } else if (quiet) {
            for (JobId jobId : sortedJobIds) {
                out.println(jobId);
            }
        } else {
            Table table = Output.table(out);
            table.row("JOB ID", "NAME", "VERSION", "HOSTS", "COMMAND", "ENVIRONMENT");
            TreeMap statuses = Maps.newTreeMap();
            for (JobId jobId : sortedJobIds) {
                statuses.put(jobId, client.jobStatus(jobId));
            }
            for (Map.Entry entry : statuses.entrySet()) {
                JobId jobId = (JobId)entry.getKey();
                Job job = (Job)jobs.get(jobId);
                String command = Joiner.on((char)' ').join(JobListCommand.escape(job.getCommand()));
                String env = Joiner.on((String)" ").withKeyValueSeparator("=").join(job.getEnv());
                JobStatus status = (JobStatus)((ListenableFuture)entry.getValue()).get();
                table.row(full ? jobId : jobId.toShortString(), jobId.getName(), jobId.getVersion(), status != null ? status.getDeployments().keySet().size() : 0, command, env);
            }
            table.print();
        }
        return 0;
    }

    private static List<String> escape(List<String> command) {
        ArrayList escaped = Lists.newArrayList();
        for (String s : command) {
            escaped.add(JobListCommand.escape(s));
        }
        return escaped;
    }

    private static String escape(String arg) {
        return CharMatcher.WHITESPACE.matchesAnyOf((CharSequence)arg) ? '\"' + arg + '\"' : arg;
    }
}

