/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli;

import com.google.common.base.Ascii;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.spotify.helios.cli.Output;
import com.spotify.helios.cli.Table;
import com.spotify.helios.common.descriptors.Deployment;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.PortMapping;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.common.descriptors.ThrottleState;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Map;

public class JobStatusTable {
    private final Table table;
    private final boolean full;

    public JobStatusTable(PrintStream out, boolean full) {
        this.table = Output.table(out);
        this.full = full;
        this.table.row("JOB ID", "HOST", "GOAL", "STATE", "CONTAINER ID", "PORTS");
    }

    public void task(JobId jobId, String host, TaskStatus ts, Deployment deployment) {
        String jobIdString;
        String goal = deployment == null ? "" : deployment.getGoal().toString();
        int maxContainerId = this.full ? Integer.MAX_VALUE : 7;
        String string = jobIdString = this.full ? jobId.toString() : jobId.toShortString();
        if (ts == null) {
            this.table.row(jobIdString, host, goal, "", "", "");
        } else {
            ArrayList<String> portMappings = new ArrayList<String>();
            for (Map.Entry entry : ts.getPorts().entrySet()) {
                PortMapping portMapping = (PortMapping)entry.getValue();
                portMappings.add(String.format("%s=%d:%d", entry.getKey(), portMapping.getInternalPort(), portMapping.getExternalPort()));
            }
            String state = ts.getState().toString();
            if (ts.getThrottled() != ThrottleState.NO) {
                state = state + " (" + ts.getThrottled() + ")";
            }
            String ports = Joiner.on((String)" ").join(portMappings);
            String cid = Ascii.truncate((CharSequence)((CharSequence)Optional.fromNullable((Object)ts.getContainerId()).or((Object)"")), (int)maxContainerId, (String)"");
            this.table.row(jobIdString, host, goal, state, cid, ports);
        }
    }

    public void print() {
        this.table.print();
    }
}

