/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import com.google.common.collect.Iterables;
import com.spotify.helios.cli.CliParser;
import com.spotify.helios.common.LoggingConfig;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Arrays;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import org.slf4j.LoggerFactory;

public class CliMain {
    private final CliParser parser;
    private final PrintStream out;
    private final PrintStream err;

    public static void main(String ... args) {
        try {
            int exitCode = new CliMain(System.out, System.err, args).run();
            System.exit(exitCode);
        }
        catch (Throwable e) {
            if (!(e instanceof ArgumentParserException)) {
                System.err.println(e.toString());
            }
            System.exit(1);
        }
    }

    public CliMain(PrintStream out, PrintStream err, String ... args) throws Exception {
        this.parser = new CliParser(args);
        this.out = out;
        this.err = err;
        this.setupLogging();
    }

    public int run() {
        try {
            BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
            return this.parser.getCommand().run(this.parser.getNamespace(), this.parser.getTargets(), this.out, this.err, this.parser.getUsername(), this.parser.getJson(), stdin);
        }
        catch (Exception e) {
            if (this.parser.getNamespace().getInt("verbose") > 0) {
                e.printStackTrace(this.err);
            } else {
                this.err.println(e.getMessage());
            }
            return 1;
        }
    }

    private void setupLogging() {
        LoggingConfig config = this.parser.getLoggingConfig();
        if (config.getNoLogSetup()) {
            return;
        }
        int verbose = config.getVerbosity();
        Level level = (Level)Iterables.get(Arrays.asList(Level.WARN, Level.INFO, Level.DEBUG, Level.ALL), (int)verbose, (Object)Level.ALL);
        Logger rootLogger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        rootLogger.setLevel(level);
    }
}

