/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.mapstream.util;

import com.speedment.common.mapstream.MapStream;
import com.speedment.common.mapstream.util.StaticClassUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public final class CollectorUtil {
    public static <T, C> Collector<T, ?, MapStream<C, List<T>>> groupBy(Function<T, C> grouper) {
        return new CollectorImpl<Object, GroupHolder, MapStream>(() -> new GroupHolder(grouper), GroupHolder::add, GroupHolder::merge, GroupHolder::finisher, Collections.emptySet());
    }

    private CollectorUtil() {
        StaticClassUtil.instanceNotAllowed(this.getClass());
    }

    static class CollectorImpl<T, A, R>
    implements Collector<T, A, R> {
        private final Supplier<A> supplier;
        private final BiConsumer<A, T> accumulator;
        private final BinaryOperator<A> combiner;
        private final Function<A, R> finisher;
        private final Set<Collector.Characteristics> characteristics;

        CollectorImpl(Supplier<A> supplier, BiConsumer<A, T> accumulator, BinaryOperator<A> combiner, Function<A, R> finisher, Set<Collector.Characteristics> characteristics) {
            this.supplier = supplier;
            this.accumulator = accumulator;
            this.combiner = combiner;
            this.finisher = finisher;
            this.characteristics = characteristics;
        }

        CollectorImpl(Supplier<A> supplier, BiConsumer<A, T> accumulator, BinaryOperator<A> combiner, Set<Collector.Characteristics> characteristics) {
            this(supplier, accumulator, combiner, i -> i, characteristics);
        }

        @Override
        public BiConsumer<A, T> accumulator() {
            return this.accumulator;
        }

        @Override
        public Supplier<A> supplier() {
            return this.supplier;
        }

        @Override
        public BinaryOperator<A> combiner() {
            return this.combiner;
        }

        @Override
        public Function<A, R> finisher() {
            return this.finisher;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return this.characteristics;
        }
    }

    private static class GroupHolder<C, T> {
        private final Function<T, C> grouper;
        private final Map<C, List<T>> elements;
        private final Function<C, List<T>> createList = c -> new ArrayList();

        public GroupHolder(Function<T, C> grouper) {
            this.grouper = grouper;
            this.elements = new HashMap<C, List<T>>();
        }

        public void add(T element) {
            C key = this.grouper.apply(element);
            this.elements.computeIfAbsent(key, this.createList).add(element);
        }

        public GroupHolder<C, T> merge(GroupHolder<C, T> holder) {
            holder.elements.entrySet().forEach(e -> this.elements.computeIfAbsent(e.getKey(), this.createList).addAll((Collection)e.getValue()));
            return this;
        }

        public MapStream<C, List<T>> finisher() {
            return MapStream.of(this.elements);
        }
    }
}

