/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.mapstream;

import com.speedment.common.mapstream.util.CollectorUtil;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.Spliterator;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleBiFunction;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntBiFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongBiFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public final class MapStream<K, V>
implements Stream<Map.Entry<K, V>> {
    private Stream<Map.Entry<K, V>> inner;

    public static <K, V> MapStream<K, V> of(Map.Entry<K, V> entry) {
        return new MapStream<K, V>(Stream.of(entry));
    }

    @SafeVarargs
    public static <K, V> MapStream<K, V> of(Map.Entry<K, V> ... entries) {
        return new MapStream<K, V>(Stream.of(entries));
    }

    public static <K, V> MapStream<K, V> of(Map<K, V> map) {
        return MapStream.of(map, false);
    }

    public static <K, V> MapStream<K, V> of(Map<K, V> map, boolean parallel) {
        MapStream<K, V> stream = new MapStream<K, V>(map.entrySet().stream());
        if (parallel) {
            stream.inner = (Stream)stream.inner.parallel();
        }
        return stream;
    }

    public static <K, V> MapStream<K, V> of(Stream<Map.Entry<K, V>> stream) {
        return new MapStream<K, V>(stream);
    }

    public static <K, V> MapStream<K, V> fromKeys(Stream<K> keys, Function<K, V> valueFromKey) {
        return new MapStream<K, V>(keys.map((? super T k) -> new AbstractMap.SimpleEntry(k, valueFromKey.apply(k))));
    }

    public static <K, V> MapStream<K, V> fromValues(Stream<V> values, Function<V, K> keyFromValue) {
        return new MapStream<K, V>(values.map((? super T v) -> new AbstractMap.SimpleEntry(keyFromValue.apply(v), v)));
    }

    public static <E, K, V> MapStream<K, V> fromStream(Stream<E> stream, Function<E, K> keyMapper, Function<E, V> valueMapper) {
        return new MapStream<K, V>(stream.map((? super T e) -> new AbstractMap.SimpleEntry(keyMapper.apply(e), valueMapper.apply(e))));
    }

    public static <K, V> MapStream<K, V> empty() {
        return new MapStream<K, V>(Stream.empty());
    }

    public static <K, V> MapStream<V, K> flip(MapStream<K, V> original) {
        return MapStream.fromStream(original, Map.Entry::getValue, Map.Entry::getKey);
    }

    public MapStream<K, V> filter(Predicate<? super Map.Entry<K, V>> predicate) {
        this.inner = this.inner.filter(predicate);
        return this;
    }

    public MapStream<K, V> filter(BiPredicate<? super K, ? super V> predicate) {
        return this.filter((T e) -> predicate.test((Object)e.getKey(), (Object)e.getValue()));
    }

    public MapStream<K, V> filterKey(Predicate<? super K> predicate) {
        return this.filter((T e) -> predicate.test((Object)e.getKey()));
    }

    public MapStream<K, V> filterValue(Predicate<? super V> predicate) {
        return this.filter((T e) -> predicate.test((Object)e.getValue()));
    }

    @Override
    public <R> Stream<R> map(Function<? super Map.Entry<K, V>, ? extends R> mapper) {
        return this.inner.map(mapper);
    }

    public <R> Stream<R> map(BiFunction<? super K, ? super V, ? extends R> mapper) {
        return this.map((Function<? super Map.Entry<K, V>, ? extends R>)((Function<Map.Entry, Object>)e -> mapper.apply((Object)e.getKey(), (Object)e.getValue())));
    }

    public <R> MapStream<R, V> mapKey(BiFunction<? super K, ? super V, ? extends R> mapper) {
        return new MapStream<K, V>(this.inner.map((? super T e) -> new AbstractMap.SimpleEntry(mapper.apply((Object)e.getKey(), (Object)e.getValue()), e.getValue())));
    }

    public <R> MapStream<R, V> mapKey(Function<? super K, ? extends R> mapper) {
        return new MapStream<K, V>(this.inner.map((? super T e) -> new AbstractMap.SimpleEntry(mapper.apply((Object)e.getKey()), e.getValue())));
    }

    public <R> MapStream<K, R> mapValue(BiFunction<? super K, ? super V, ? extends R> mapper) {
        return new MapStream<K, V>(this.inner.map((? super T e) -> new AbstractMap.SimpleEntry(e.getKey(), mapper.apply((Object)e.getKey(), (Object)e.getValue()))));
    }

    public <R> MapStream<K, R> mapValue(Function<? super V, ? extends R> mapper) {
        return new MapStream<K, V>(this.inner.map((? super T e) -> new AbstractMap.SimpleEntry(e.getKey(), mapper.apply((Object)e.getValue()))));
    }

    @Override
    public IntStream mapToInt(ToIntFunction<? super Map.Entry<K, V>> mapper) {
        return this.inner.mapToInt(mapper);
    }

    public IntStream mapToInt(ToIntBiFunction<? super K, ? super V> mapper) {
        return this.inner.mapToInt((? super T e) -> mapper.applyAsInt((Object)e.getKey(), (Object)e.getValue()));
    }

    @Override
    public LongStream mapToLong(ToLongFunction<? super Map.Entry<K, V>> mapper) {
        return this.inner.mapToLong(mapper);
    }

    public LongStream mapToLong(ToLongBiFunction<? super K, ? super V> mapper) {
        return this.inner.mapToLong((? super T e) -> mapper.applyAsLong((Object)e.getKey(), (Object)e.getValue()));
    }

    @Override
    public DoubleStream mapToDouble(ToDoubleFunction<? super Map.Entry<K, V>> mapper) {
        return this.inner.mapToDouble(mapper);
    }

    public DoubleStream mapToDouble(ToDoubleBiFunction<? super K, ? super V> mapper) {
        return this.inner.mapToDouble((? super T e) -> mapper.applyAsDouble((Object)e.getKey(), (Object)e.getValue()));
    }

    @Override
    public <R> Stream<R> flatMap(Function<? super Map.Entry<K, V>, ? extends Stream<? extends R>> mapper) {
        return this.inner.flatMap(mapper);
    }

    public <R> Stream<R> flatMap(BiFunction<? super K, ? super V, ? extends Stream<? extends R>> mapper) {
        return this.inner.flatMap((? super T e) -> (Stream)mapper.apply((Object)e.getKey(), (Object)e.getValue()));
    }

    public <R> MapStream<R, V> flatMapKey(BiFunction<? super K, ? super V, ? extends Stream<? extends R>> mapper) {
        return new MapStream<K, V>(this.inner.flatMap((? super T e) -> ((Stream)mapper.apply((Object)e.getKey(), (Object)e.getValue())).map((? super T k) -> new AbstractMap.SimpleEntry(k, e.getValue()))));
    }

    public <R> MapStream<R, V> flatMapKey(Function<? super K, ? extends Stream<? extends R>> mapper) {
        return new MapStream<K, V>(this.inner.flatMap((? super T e) -> ((Stream)mapper.apply((Object)e.getKey())).map((? super T k) -> new AbstractMap.SimpleEntry(k, e.getValue()))));
    }

    public <R> MapStream<K, R> flatMapValue(BiFunction<? super K, ? super V, ? extends Stream<? extends R>> mapper) {
        return new MapStream<K, V>(this.inner.flatMap((? super T e) -> ((Stream)mapper.apply((Object)e.getKey(), (Object)e.getValue())).map((? super T v) -> new AbstractMap.SimpleEntry(e.getKey(), v))));
    }

    public <R> MapStream<K, R> flatMapValue(Function<? super V, ? extends Stream<? extends R>> mapper) {
        return new MapStream<K, V>(this.inner.flatMap((? super T e) -> ((Stream)mapper.apply((Object)e.getValue())).map((? super T v) -> new AbstractMap.SimpleEntry(e.getKey(), v))));
    }

    @Override
    public IntStream flatMapToInt(Function<? super Map.Entry<K, V>, ? extends IntStream> mapper) {
        return this.inner.flatMapToInt(mapper);
    }

    public IntStream flatMapToInt(BiFunction<? super K, ? super V, ? extends IntStream> mapper) {
        return this.inner.flatMapToInt((? super T e) -> (IntStream)mapper.apply((Object)e.getKey(), (Object)e.getValue()));
    }

    @Override
    public LongStream flatMapToLong(Function<? super Map.Entry<K, V>, ? extends LongStream> mapper) {
        return this.inner.flatMapToLong(mapper);
    }

    public LongStream flatMapToLong(BiFunction<? super K, ? super V, ? extends LongStream> mapper) {
        return this.inner.flatMapToLong((? super T e) -> (LongStream)mapper.apply((Object)e.getKey(), (Object)e.getValue()));
    }

    @Override
    public DoubleStream flatMapToDouble(Function<? super Map.Entry<K, V>, ? extends DoubleStream> mapper) {
        return this.inner.flatMapToDouble(mapper);
    }

    public DoubleStream flatMapToDouble(BiFunction<? super K, ? super V, ? extends DoubleStream> mapper) {
        return this.inner.flatMapToDouble((? super T e) -> (DoubleStream)mapper.apply((Object)e.getKey(), (Object)e.getValue()));
    }

    public Stream<K> keys() {
        return this.inner.map(Map.Entry::getKey);
    }

    public Stream<V> values() {
        return this.inner.map(Map.Entry::getValue);
    }

    public MapStream<K, V> distinct() {
        this.inner = this.inner.distinct();
        return this;
    }

    public MapStream<K, V> distinctKeys() {
        Set temp = Collections.newSetFromMap(new ConcurrentHashMap());
        this.inner = this.inner.flatMap((? super T e) -> temp.add(e.getKey()) ? Stream.of(e) : Stream.empty());
        return this;
    }

    public MapStream<K, V> distinctValues() {
        Set temp = Collections.newSetFromMap(new ConcurrentHashMap());
        this.inner = this.inner.flatMap((? super T e) -> temp.add(e.getValue()) ? Stream.of(e) : Stream.empty());
        return this;
    }

    public MapStream<K, V> distinctKeys(BinaryOperator<V> merger) {
        boolean parallel = this.isParallel();
        Map result = parallel ? Collections.synchronizedMap(new LinkedHashMap()) : new LinkedHashMap();
        this.inner.forEachOrdered((? super T e) -> result.compute(e.getKey(), (k, v) -> v == null ? e.getValue() : merger.apply(e.getValue(), v)));
        return MapStream.of(result, parallel);
    }

    public MapStream<K, V> distinctValues(BinaryOperator<K> merger) {
        return MapStream.flip(MapStream.flip(this).distinctKeys(merger));
    }

    public MapStream<K, V> sorted() {
        Comparator c = (a, b) -> {
            if (a == null && b == null) {
                return 0;
            }
            if (a != null && b != null && a instanceof Comparable) {
                Comparable ac = (Comparable)a;
                return ac.compareTo(b);
            }
            throw new UnsupportedOperationException("Can only sort keys that implement Comparable.");
        };
        this.inner = this.inner.sorted((a, b) -> c.compare(a.getKey(), b.getKey()));
        return this;
    }

    public MapStream<K, V> sorted(Comparator<? super Map.Entry<K, V>> comparator) {
        this.inner = this.inner.sorted(comparator);
        return this;
    }

    public MapStream<K, V> sortedByKey(Comparator<K> comparator) {
        this.inner = this.inner.sorted(MapStream.byKeyOnly(comparator));
        return this;
    }

    public MapStream<K, V> sortedByValue(Comparator<V> comparator) {
        this.inner = this.inner.sorted(MapStream.byValueOnly(comparator));
        return this;
    }

    public MapStream<K, V> peek(Consumer<? super Map.Entry<K, V>> action) {
        this.inner = this.inner.peek(action);
        return this;
    }

    public MapStream<K, V> peek(BiConsumer<? super K, ? super V> action) {
        this.inner = this.inner.peek((? super T e) -> action.accept((Object)e.getKey(), (Object)e.getValue()));
        return this;
    }

    public MapStream<K, V> limit(long maxSize) {
        this.inner = this.inner.limit(maxSize);
        return this;
    }

    public MapStream<K, V> skip(long n) {
        this.inner = this.inner.skip(n);
        return this;
    }

    @Override
    public void forEach(Consumer<? super Map.Entry<K, V>> action) {
        this.inner.forEach(action);
    }

    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.inner.forEach((? super T e) -> action.accept((Object)e.getKey(), (Object)e.getValue()));
    }

    @Override
    public void forEachOrdered(Consumer<? super Map.Entry<K, V>> action) {
        this.inner.forEachOrdered(action);
    }

    public void forEachOrdered(BiConsumer<? super K, ? super V> action) {
        this.inner.forEachOrdered((? super T e) -> action.accept((Object)e.getKey(), (Object)e.getValue()));
    }

    @Override
    public Object[] toArray() {
        return this.inner.toArray();
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        return this.inner.toArray(generator);
    }

    @Override
    public Map.Entry<K, V> reduce(Map.Entry<K, V> identity, BinaryOperator<Map.Entry<K, V>> accumulator) {
        return this.inner.reduce(identity, accumulator);
    }

    @Override
    public Optional<Map.Entry<K, V>> reduce(BinaryOperator<Map.Entry<K, V>> accumulator) {
        return this.inner.reduce(accumulator);
    }

    @Override
    public <U> U reduce(U identity, BiFunction<U, ? super Map.Entry<K, V>, U> accumulator, BinaryOperator<U> combiner) {
        return this.inner.reduce(identity, accumulator, combiner);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super Map.Entry<K, V>> accumulator, BiConsumer<R, R> combiner) {
        return this.inner.collect(supplier, accumulator, combiner);
    }

    @Override
    public <R, A> R collect(Collector<? super Map.Entry<K, V>, A, R> collector) {
        return this.inner.collect(collector);
    }

    public <K2> MapStream<K2, List<V>> groupingBy(Function<V, K2> grouper) {
        return this.inner.map(Map.Entry::getValue).collect(CollectorUtil.groupBy(grouper));
    }

    @Override
    public Optional<Map.Entry<K, V>> min(Comparator<? super Map.Entry<K, V>> comparator) {
        return this.inner.min(comparator);
    }

    public Optional<Map.Entry<K, V>> minByKey(Comparator<K> comparator) {
        return this.inner.min(MapStream.byKeyOnly(comparator));
    }

    public Optional<Map.Entry<K, V>> minByValue(Comparator<V> comparator) {
        return this.inner.min(MapStream.byValueOnly(comparator));
    }

    @Override
    public Optional<Map.Entry<K, V>> max(Comparator<? super Map.Entry<K, V>> comparator) {
        return this.inner.max(comparator);
    }

    public Optional<Map.Entry<K, V>> maxByKey(Comparator<K> comparator) {
        return this.inner.max(MapStream.byKeyOnly(comparator));
    }

    public Optional<Map.Entry<K, V>> maxByValue(Comparator<V> comparator) {
        return this.inner.max(MapStream.byValueOnly(comparator));
    }

    @Override
    public long count() {
        return this.inner.count();
    }

    @Override
    public boolean anyMatch(Predicate<? super Map.Entry<K, V>> predicate) {
        return this.inner.anyMatch(predicate);
    }

    public boolean anyMatch(BiPredicate<? super K, ? super V> predicate) {
        return this.inner.anyMatch((? super T e) -> predicate.test((Object)e.getKey(), (Object)e.getValue()));
    }

    @Override
    public boolean allMatch(Predicate<? super Map.Entry<K, V>> predicate) {
        return this.inner.allMatch(predicate);
    }

    public boolean allMatch(BiPredicate<? super K, ? super V> predicate) {
        return this.inner.allMatch((? super T e) -> predicate.test((Object)e.getKey(), (Object)e.getValue()));
    }

    @Override
    public boolean noneMatch(Predicate<? super Map.Entry<K, V>> predicate) {
        return this.inner.noneMatch(predicate);
    }

    public boolean noneMatch(BiPredicate<? super K, ? super V> predicate) {
        return this.inner.noneMatch((? super T e) -> predicate.test((Object)e.getKey(), (Object)e.getValue()));
    }

    @Override
    public Optional<Map.Entry<K, V>> findFirst() {
        return this.inner.findFirst();
    }

    @Override
    public Optional<Map.Entry<K, V>> findAny() {
        return this.inner.findAny();
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.inner.iterator();
    }

    @Override
    public Spliterator<Map.Entry<K, V>> spliterator() {
        return this.inner.spliterator();
    }

    @Override
    public boolean isParallel() {
        return this.inner.isParallel();
    }

    @Override
    public MapStream<K, V> sequential() {
        this.inner = (Stream)this.inner.sequential();
        return this;
    }

    @Override
    public MapStream<K, V> parallel() {
        this.inner = (Stream)this.inner.parallel();
        return this;
    }

    @Override
    public MapStream<K, V> unordered() {
        this.inner = (Stream)this.inner.unordered();
        return this;
    }

    @Override
    public MapStream<K, V> onClose(Runnable closeHandler) {
        this.inner = (Stream)this.inner.onClose(closeHandler);
        return this;
    }

    @Override
    public void close() {
        this.inner.close();
    }

    public Map<K, V> toMap() {
        return this.inner.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Map<K, V> toMap(BinaryOperator<V> mergeFunction) {
        return this.inner.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, mergeFunction));
    }

    public Map<K, V> toConcurrentMap() {
        return this.inner.collect(Collectors.toConcurrentMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Map<K, V> toConcurrentMap(BinaryOperator<V> mergeFunction) {
        return this.inner.collect(Collectors.toConcurrentMap(Map.Entry::getKey, Map.Entry::getValue, mergeFunction));
    }

    public SortedMap<K, V> toSortedMap() {
        return this.inner.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, MapStream.throwingMerger(), TreeMap::new));
    }

    public SortedMap<K, V> toSortedMapByKey(Comparator<K> keyComparator) {
        return this.inner.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, MapStream.throwingMerger(), () -> new TreeMap(keyComparator)));
    }

    public SortedMap<K, V> toSortedMap(BinaryOperator<V> mergeFunction) {
        return this.inner.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, mergeFunction, TreeMap::new));
    }

    public SortedMap<K, V> toSortedMap(Comparator<K> keyComparator, BinaryOperator<V> mergeFunction) {
        return this.inner.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, mergeFunction, () -> new TreeMap(keyComparator)));
    }

    public ConcurrentNavigableMap<K, V> toConcurrentNavigableMap() {
        return this.inner.collect(Collectors.toConcurrentMap(Map.Entry::getKey, Map.Entry::getValue, MapStream.throwingMerger(), ConcurrentSkipListMap::new));
    }

    public ConcurrentNavigableMap<K, V> toConcurrentNavigableMapByKey(Comparator<K> keyComparator) {
        return this.inner.collect(Collectors.toConcurrentMap(Map.Entry::getKey, Map.Entry::getValue, MapStream.throwingMerger(), () -> new ConcurrentSkipListMap(keyComparator)));
    }

    public ConcurrentNavigableMap<K, V> toConcurrentNavigableMap(BinaryOperator<V> mergeFunction) {
        return this.inner.collect(Collectors.toConcurrentMap(Map.Entry::getKey, Map.Entry::getValue, mergeFunction, ConcurrentSkipListMap::new));
    }

    public ConcurrentNavigableMap<K, V> toConcurrentNavigableMap(Comparator<K> keyComparator, BinaryOperator<V> mergeFunction) {
        return this.inner.collect(Collectors.toConcurrentMap(Map.Entry::getKey, Map.Entry::getValue, mergeFunction, () -> new ConcurrentSkipListMap(keyComparator)));
    }

    @Override
    public List<Map.Entry<K, V>> toList() {
        return this.inner.collect(Collectors.toList());
    }

    @SafeVarargs
    public static <K> Comparator<K> comparing(Function<K, ? extends Comparable<?>> ... methods) {
        return (a, b) -> {
            for (Function method : methods) {
                Comparable bc;
                Function m = method;
                Comparable ac = (Comparable)m.apply(a);
                int c = ac.compareTo(bc = (Comparable)m.apply(b));
                if (c == 0) continue;
                return c;
            }
            return 0;
        };
    }

    private MapStream(Stream<Map.Entry<K, V>> inner) {
        this.inner = inner;
    }

    private static <K, V> Comparator<Map.Entry<K, V>> byKeyOnly(Comparator<K> comparator) {
        return (a, b) -> comparator.compare(a.getKey(), b.getKey());
    }

    private static <K, V> Comparator<Map.Entry<K, V>> byValueOnly(Comparator<V> comparator) {
        return (a, b) -> comparator.compare(a.getValue(), b.getValue());
    }

    public static <T> BinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        };
    }
}

