/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms.impl;

import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.impl.JCSMPBasicSession;
import com.solacesystems.jcsmp.impl.transaction.xa.XASessionImpl;
import com.solacesystems.jcsmp.transaction.xa.XASession;
import com.solacesystems.jms.impl.ConnectionConsumerTransactionStrategy;
import com.solacesystems.jms.impl.JCSMPConsumerFactory;
import com.solacesystems.jms.impl.JCSMPXASession;
import com.solacesystems.jms.impl.Validator;
import jakarta.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConnectionConsumerXATransactionStrategy
extends ConnectionConsumerTransactionStrategy {
    private static final Log log = LogFactory.getLog(ConnectionConsumerXATransactionStrategy.class);
    private XASessionImpl mXaSession;

    public ConnectionConsumerXATransactionStrategy(ConnectionConsumerTransactionStrategy.InitProperties iprop) {
        super(iprop);
        this.mTxState = ConnectionConsumerTransactionStrategy.TransactionState.ACTIVE;
        if (log.isDebugEnabled()) {
            log.debug((Object)"ConnectionConsumerXAStrategy created.");
        }
    }

    @Override
    public void createConsumer() throws JMSException {
        try {
            XASession xasession = ((JCSMPBasicSession)this.mConnection.getProperties().getJCSMPSession()).createXASession();
            this.mSessionProps.getUserProperties().put("XASession", new JCSMPXASession(xasession));
            this.mXaSession = (XASessionImpl)xasession;
        }
        catch (JCSMPException e) {
            throw Validator.createJMSException("soljms.operation.session.create", e);
        }
        this.createConsumerImpl(JCSMPConsumerFactory.standard);
    }

    @Override
    public void closeConsumer() throws JMSException {
        super.closeConsumer();
        if (this.mXaSession != null) {
            this.mXaSession.close();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Consumer closed");
        }
    }

    public XASessionImpl getJCSMPXASession() {
        return this.mXaSession;
    }
}

